/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.main.ClassWriter;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.TextBuffer;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.ListStack;

public class NewExprent
extends Exprent {
    private InvocationExprent constructor;
    private final VarType newType;
    private List<Exprent> lstDims = new ArrayList<Exprent>();
    private List<Exprent> lstArrayElements = new ArrayList<Exprent>();
    private boolean directArrayInit;
    private boolean anonymous;
    private boolean lambda;
    private boolean enumConst;

    public NewExprent(VarType newType, ListStack<Exprent> stack, int arrayDim, Set<Integer> bytecodeOffsets) {
        this(newType, NewExprent.getDimensions(arrayDim, stack), bytecodeOffsets);
    }

    public NewExprent(VarType newType, List<Exprent> lstDims, Set<Integer> bytecodeOffsets) {
        super(10);
        ClassesProcessor.ClassNode node;
        this.newType = newType;
        this.lstDims = lstDims;
        this.anonymous = false;
        this.lambda = false;
        if (newType.type == 8 && newType.arrayDim == 0 && (node = DecompilerContext.getClassProcessor().getMapRootClasses().get(newType.value)) != null && (node.type == 2 || node.type == 8)) {
            this.anonymous = true;
            if (node.type == 8) {
                this.lambda = true;
            }
        }
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    private static List<Exprent> getDimensions(int arrayDim, ListStack<Exprent> stack) {
        ArrayList<Exprent> lstDims = new ArrayList<Exprent>();
        for (int i = 0; i < arrayDim; ++i) {
            lstDims.add(0, stack.pop());
        }
        return lstDims;
    }

    @Override
    public VarType getExprType() {
        return this.anonymous ? DecompilerContext.getClassProcessor().getMapRootClasses().get((Object)this.newType.value).anonymousClassType : this.newType;
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        if (this.newType.arrayDim != 0) {
            for (Exprent dim : this.lstDims) {
                result.addMinTypeExprent(dim, VarType.VARTYPE_BYTECHAR);
                result.addMaxTypeExprent(dim, VarType.VARTYPE_INT);
            }
            if (this.newType.arrayDim == 1) {
                VarType leftType = this.newType.decreaseArrayDim();
                for (Exprent element : this.lstArrayElements) {
                    result.addMinTypeExprent(element, VarType.getMinTypeInFamily(leftType.typeFamily));
                    result.addMaxTypeExprent(element, leftType);
                }
            }
        } else if (this.constructor != null) {
            return this.constructor.checkExprTypeBounds();
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        if (this.newType.arrayDim == 0) {
            if (this.constructor != null) {
                Exprent constructor_instance = this.constructor.getInstance();
                if (constructor_instance != null) {
                    lst.add(constructor_instance);
                }
                lst.addAll(this.constructor.getLstParameters());
            }
        } else {
            lst.addAll(this.lstDims);
            lst.addAll(this.lstArrayElements);
        }
        return lst;
    }

    @Override
    public Exprent copy() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        for (Exprent expr : this.lstDims) {
            lst.add(expr.copy());
        }
        NewExprent ret = new NewExprent(this.newType, lst, this.bytecode);
        ret.setConstructor(this.constructor == null ? null : (InvocationExprent)this.constructor.copy());
        ret.setLstArrayElements(this.lstArrayElements);
        ret.setDirectArrayInit(this.directArrayInit);
        ret.setAnonymous(this.anonymous);
        ret.setEnumConst(this.enumConst);
        return ret;
    }

    @Override
    public int getPrecedence() {
        return 1;
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        TextBuffer buf = new TextBuffer();
        if (this.anonymous) {
            ClassesProcessor.ClassNode child = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.newType.value);
            if (!this.enumConst) {
                String enclosing = null;
                if (!this.lambda && this.constructor != null && (enclosing = NewExprent.getQualifiedNewInstance(child.anonymousClassType.value, this.constructor.getLstParameters(), indent, tracer)) != null) {
                    buf.append(enclosing).append('.');
                }
                buf.append("new ");
                String typename = ExprProcessor.getCastTypeName(child.anonymousClassType);
                if (enclosing != null) {
                    ClassesProcessor.ClassNode anonymousNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(child.anonymousClassType.value);
                    typename = anonymousNode != null ? anonymousNode.simpleName : typename.substring(typename.lastIndexOf(46) + 1);
                }
                buf.append(typename);
            }
            buf.append('(');
            if (!this.lambda && this.constructor != null) {
                InvocationExprent invSuper = child.superInvocation;
                ClassesProcessor.ClassNode newNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(invSuper.getClassname());
                List<VarVersionPair> sigFields = null;
                if (newNode != null) {
                    if (newNode.getWrapper() != null) {
                        sigFields = newNode.getWrapper().getMethodWrapper((String)"<init>", (String)invSuper.getStringDescriptor()).signatureFields;
                    } else if (newNode.type == 1 && (newNode.access & 8) == 0 && !this.constructor.getLstParameters().isEmpty()) {
                        sigFields = new ArrayList<VarVersionPair>(Collections.nCopies(this.constructor.getLstParameters().size(), null));
                        sigFields.set(0, new VarVersionPair(-1, 0));
                    }
                }
                boolean firstParam = true;
                int start = 0;
                int end = invSuper.getLstParameters().size();
                if (this.enumConst) {
                    start += 2;
                    --end;
                }
                for (int i = start; i < end; ++i) {
                    int varIndex;
                    if (sigFields != null && sigFields.get(i) != null) continue;
                    if (!firstParam) {
                        buf.append(", ");
                    }
                    Exprent param = invSuper.getLstParameters().get(i);
                    if (param.type == 12 && (varIndex = ((VarExprent)param).getIndex()) > 0 && varIndex <= this.constructor.getLstParameters().size()) {
                        param = this.constructor.getLstParameters().get(varIndex - 1);
                    }
                    ExprProcessor.getCastedExprent(param, invSuper.getDescriptor().params[i], buf, indent, true, tracer);
                    firstParam = false;
                }
            }
            buf.append(')');
            if (this.enumConst && buf.length() == 2) {
                buf.setLength(0);
            }
            if (this.lambda) {
                if (!DecompilerContext.getOption("lac")) {
                    buf.setLength(0);
                }
                Exprent methodObject = this.constructor == null ? null : this.constructor.getInstance();
                TextBuffer clsBuf = new TextBuffer();
                new ClassWriter().classLambdaToJava(child, clsBuf, methodObject, indent, tracer);
                buf.append(clsBuf);
                tracer.incrementCurrentSourceLine(clsBuf.countLines());
            } else {
                TextBuffer clsBuf = new TextBuffer();
                new ClassWriter().classToJava(child, clsBuf, indent, tracer);
                buf.append(clsBuf);
                tracer.incrementCurrentSourceLine(clsBuf.countLines());
            }
        } else if (this.directArrayInit) {
            VarType leftType = this.newType.decreaseArrayDim();
            buf.append('{');
            for (int i = 0; i < this.lstArrayElements.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                ExprProcessor.getCastedExprent(this.lstArrayElements.get(i), leftType, buf, indent, false, tracer);
            }
            buf.append('}');
        } else if (this.newType.arrayDim == 0) {
            if (!this.enumConst) {
                String enclosing = null;
                if (this.constructor != null && (enclosing = NewExprent.getQualifiedNewInstance(this.newType.value, this.constructor.getLstParameters(), indent, tracer)) != null) {
                    buf.append(enclosing).append('.');
                }
                buf.append("new ");
                String typename = ExprProcessor.getTypeName(this.newType);
                if (enclosing != null) {
                    ClassesProcessor.ClassNode newNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.newType.value);
                    typename = newNode != null ? newNode.simpleName : typename.substring(typename.lastIndexOf(46) + 1);
                }
                buf.append(typename);
            }
            if (this.constructor != null) {
                int start;
                List<Exprent> lstParameters = this.constructor.getLstParameters();
                ClassesProcessor.ClassNode newNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.constructor.getClassname());
                List<VarVersionPair> sigFields = null;
                if (newNode != null) {
                    if (newNode.getWrapper() != null) {
                        sigFields = newNode.getWrapper().getMethodWrapper((String)"<init>", (String)this.constructor.getStringDescriptor()).signatureFields;
                    } else if (newNode.type == 1 && (newNode.access & 8) == 0 && !this.constructor.getLstParameters().isEmpty()) {
                        sigFields = new ArrayList<VarVersionPair>(Collections.nCopies(lstParameters.size(), null));
                        sigFields.set(0, new VarVersionPair(-1, 0));
                    }
                }
                int n = start = this.enumConst ? 2 : 0;
                if (!this.enumConst || start < lstParameters.size()) {
                    buf.append('(');
                    boolean firstParam = true;
                    for (int i = start; i < lstParameters.size(); ++i) {
                        ClassesProcessor.ClassNode node;
                        if (sigFields != null && sigFields.get(i) != null) continue;
                        Exprent expr = lstParameters.get(i);
                        VarType leftType = this.constructor.getDescriptor().params[i];
                        if (i == lstParameters.size() - 1 && expr.getExprType() == VarType.VARTYPE_NULL && (node = DecompilerContext.getClassProcessor().getMapRootClasses().get(leftType.value)) != null && node.namelessConstructorStub) break;
                        if (!firstParam) {
                            buf.append(", ");
                        }
                        ExprProcessor.getCastedExprent(expr, leftType, buf, indent, true, tracer);
                        firstParam = false;
                    }
                    buf.append(')');
                }
            }
        } else {
            buf.append("new ").append(ExprProcessor.getTypeName(this.newType));
            if (this.lstArrayElements.isEmpty()) {
                for (int i = 0; i < this.newType.arrayDim; ++i) {
                    buf.append('[');
                    if (i < this.lstDims.size()) {
                        buf.append(this.lstDims.get(i).toJava(indent, tracer));
                    }
                    buf.append(']');
                }
            } else {
                for (int i = 0; i < this.newType.arrayDim; ++i) {
                    buf.append("[]");
                }
                VarType leftType = this.newType.decreaseArrayDim();
                buf.append('{');
                for (int i = 0; i < this.lstArrayElements.size(); ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    ExprProcessor.getCastedExprent(this.lstArrayElements.get(i), leftType, buf, indent, false, tracer);
                }
                buf.append('}');
            }
        }
        return buf;
    }

    private static String getQualifiedNewInstance(String classname, List<Exprent> lstParams, int indent, BytecodeMappingTracer tracer) {
        ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(classname);
        if (node != null && node.type != 0 && node.type != 4 && (node.access & 8) == 0 && !lstParams.isEmpty()) {
            Exprent enclosing = lstParams.get(0);
            boolean isQualifiedNew = false;
            if (enclosing.type == 12) {
                VarExprent varEnclosing = (VarExprent)enclosing;
                StructClass current_class = ((ClassesProcessor.ClassNode)DecompilerContext.getProperty((String)"CURRENT_CLASS_NODE")).classStruct;
                String this_classname = varEnclosing.getProcessor().getThisVars().get(new VarVersionPair(varEnclosing));
                if (!current_class.qualifiedName.equals(this_classname)) {
                    isQualifiedNew = true;
                }
            } else {
                isQualifiedNew = true;
            }
            if (isQualifiedNew) {
                return enclosing.toJava(indent, tracer).toString();
            }
        }
        return null;
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        int i;
        if (oldExpr == this.constructor) {
            this.constructor = (InvocationExprent)newExpr;
        }
        if (this.constructor != null) {
            this.constructor.replaceExprent(oldExpr, newExpr);
        }
        for (i = 0; i < this.lstDims.size(); ++i) {
            if (oldExpr != this.lstDims.get(i)) continue;
            this.lstDims.set(i, newExpr);
        }
        for (i = 0; i < this.lstArrayElements.size(); ++i) {
            if (oldExpr != this.lstArrayElements.get(i)) continue;
            this.lstArrayElements.set(i, newExpr);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof NewExprent)) {
            return false;
        }
        NewExprent ne = (NewExprent)o;
        return InterpreterUtil.equalObjects(this.newType, ne.getNewType()) && InterpreterUtil.equalLists(this.lstDims, ne.getLstDims()) && InterpreterUtil.equalObjects(this.constructor, ne.getConstructor()) && this.directArrayInit == ne.directArrayInit && InterpreterUtil.equalLists(this.lstArrayElements, ne.getLstArrayElements());
    }

    public InvocationExprent getConstructor() {
        return this.constructor;
    }

    public void setConstructor(InvocationExprent constructor) {
        this.constructor = constructor;
    }

    public List<Exprent> getLstDims() {
        return this.lstDims;
    }

    public VarType getNewType() {
        return this.newType;
    }

    public List<Exprent> getLstArrayElements() {
        return this.lstArrayElements;
    }

    public void setLstArrayElements(List<Exprent> lstArrayElements) {
        this.lstArrayElements = lstArrayElements;
    }

    public void setDirectArrayInit(boolean directArrayInit) {
        this.directArrayInit = directArrayInit;
    }

    public boolean isLambda() {
        return this.lambda;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public void setEnumConst(boolean enumConst) {
        this.enumConst = enumConst;
    }
}

