/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import com.google.common.base.Objects;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.plugins.gradle.model.AbstractExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;

public class DefaultExternalProjectDependency
extends AbstractExternalDependency
implements ExternalProjectDependency {
    private static final long serialVersionUID = 1L;
    private String myProjectPath;
    private String myConfigurationName = "default";
    private Collection<File> myProjectDependencyArtifacts;

    public DefaultExternalProjectDependency() {
    }

    public DefaultExternalProjectDependency(ExternalProjectDependency dependency) {
        super((ExternalDependency)dependency);
        this.myProjectPath = dependency.getProjectPath();
        this.myConfigurationName = dependency.getConfigurationName();
        this.myProjectDependencyArtifacts = dependency.getProjectDependencyArtifacts() == null ? new ArrayList<File>() : new ArrayList(dependency.getProjectDependencyArtifacts());
    }

    public String getProjectPath() {
        return this.myProjectPath;
    }

    public void setProjectPath(String projectPath) {
        this.myProjectPath = projectPath;
    }

    public String getConfigurationName() {
        return this.myConfigurationName;
    }

    public void setConfigurationName(String configurationName) {
        this.myConfigurationName = configurationName;
        if (!"default".equals(configurationName)) {
            this.setClassifier(configurationName);
        }
    }

    public Collection<File> getProjectDependencyArtifacts() {
        return this.myProjectDependencyArtifacts;
    }

    public void setProjectDependencyArtifacts(Collection<File> projectArtifacts) {
        this.myProjectDependencyArtifacts = projectArtifacts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultExternalProjectDependency)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultExternalProjectDependency that = (DefaultExternalProjectDependency)o;
        return Objects.equal((Object)this.myProjectPath, (Object)that.myProjectPath) && Objects.equal((Object)this.myConfigurationName, (Object)that.myConfigurationName);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.myProjectPath, this.myConfigurationName});
    }

    public String toString() {
        return "project dependency '" + this.myProjectPath + ", " + this.myConfigurationName + '\'';
    }
}

