/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Dependency;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.ActionType;
import org.jetbrains.idea.devkit.util.ComponentType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

public abstract class DevKitInspectionBase
extends BaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = DevKitBundle.message("inspections.group.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/DevKitInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @Nullable
    protected static Set<PsiClass> getRegistrationTypes(PsiClass psiClass, boolean includeActions) {
        Project project = psiClass.getProject();
        PsiFile psiFile = psiClass.getContainingFile();
        assert (psiFile != null);
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Module module = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module == null) {
            return null;
        }
        if (PluginModuleType.isOfType(module)) {
            return DevKitInspectionBase.checkModule(module, psiClass, null, includeActions);
        }
        Set<PsiClass> types = null;
        List<Module> modules = PluginModuleType.getCandidateModules(module);
        for (Module m : modules) {
            types = DevKitInspectionBase.checkModule(m, psiClass, types, includeActions);
        }
        return types;
    }

    @Nullable
    private static Set<PsiClass> checkModule(Module module, PsiClass psiClass, @Nullable Set<PsiClass> types, boolean includeActions) {
        XmlFile pluginXml = PluginModuleType.getPluginXml(module);
        if (pluginXml == null) {
            return null;
        }
        DomFileElement<IdeaPlugin> fileElement = DescriptorUtil.getIdeaPlugin(pluginXml);
        if (fileElement == null) {
            return null;
        }
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName != null) {
            RegistrationTypeFinder finder = new RegistrationTypeFinder(psiClass, types);
            DevKitInspectionBase.processPluginXml(pluginXml, finder, includeActions);
            for (Dependency dependency : ((IdeaPlugin)fileElement.getRootElement()).getDependencies()) {
                XmlFile depPluginXml;
                PsiElement resolve;
                PathReference configFile;
                GenericAttributeValue<PathReference> configFileAttribute = dependency.getConfigFile();
                if (!DomUtil.hasXml(configFileAttribute) || (configFile = (PathReference)configFileAttribute.getValue()) == null || !((resolve = configFile.resolve()) instanceof XmlFile) || !DescriptorUtil.isPluginXml((PsiFile)(depPluginXml = (XmlFile)resolve))) continue;
                DevKitInspectionBase.processPluginXml(depPluginXml, finder, includeActions);
            }
            types = finder.getTypes();
        }
        return types;
    }

    private static void processPluginXml(XmlFile xmlFile, RegistrationTypeFinder finder, boolean includeActions) {
        XmlDocument document = xmlFile.getDocument();
        if (document == null) {
            return;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null) {
            return;
        }
        DescriptorUtil.processComponents(rootTag, finder);
        if (includeActions) {
            DescriptorUtil.processActions(rootTag, finder);
        }
    }

    @Nullable
    protected static PsiElement getAttValueToken(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/jetbrains/idea/devkit/inspections/DevKitInspectionBase", "getAttValueToken"));
        }
        XmlAttributeValue valueElement = attribute.getValueElement();
        if (valueElement == null) {
            return null;
        }
        PsiElement[] children = valueElement.getChildren();
        if (children.length == 3 && children[1] instanceof XmlToken) {
            return children[1];
        }
        if (children.length == 1 && children[0] instanceof PsiErrorElement) {
            return null;
        }
        return valueElement;
    }

    protected static boolean isAbstract(PsiModifierListOwner checkedClass) {
        return checkedClass.hasModifierProperty("abstract");
    }

    protected static boolean isPublic(PsiModifierListOwner checkedClass) {
        return checkedClass.hasModifierProperty("public");
    }

    protected static boolean isActionRegistered(PsiClass psiClass) {
        Set<PsiClass> registrationTypes = DevKitInspectionBase.getRegistrationTypes(psiClass, true);
        if (registrationTypes != null) {
            for (PsiClass type : registrationTypes) {
                if (AnAction.class.getName().equals(type.getQualifiedName())) {
                    return true;
                }
                if (!ActionGroup.class.getName().equals(type.getQualifiedName())) continue;
                return true;
            }
        }
        return false;
    }

    private static class RegistrationTypeFinder
    implements ComponentType.Processor,
    ActionType.Processor {
        private Set<PsiClass> myTypes;
        private final String myQualifiedName;
        private final PsiManager myManager;
        private final GlobalSearchScope myScope;

        private RegistrationTypeFinder(PsiClass psiClass, Set<PsiClass> types) {
            this.myTypes = types;
            this.myQualifiedName = psiClass.getQualifiedName();
            this.myManager = psiClass.getManager();
            this.myScope = psiClass.getResolveScope();
        }

        @Override
        public boolean process(ComponentType type, XmlTag component, XmlTagValue impl, XmlTagValue intf) {
            PsiClass clazz;
            if (impl != null && this.myQualifiedName.equals(impl.getTrimmedText()) && (clazz = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass(type.myClassName, this.myScope)) != null) {
                this.addType(clazz);
            }
            return true;
        }

        @Override
        public boolean process(ActionType type, XmlTag action) {
            PsiClass clazz;
            String actionClass = action.getAttributeValue("class");
            if (actionClass != null && actionClass.trim().equals(this.myQualifiedName) && (clazz = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass(type.myClassName, this.myScope)) != null) {
                this.addType(clazz);
                return false;
            }
            return true;
        }

        private void addType(PsiClass clazz) {
            if (this.myTypes == null) {
                this.myTypes = ContainerUtil.newIdentityTroveSet((int)2);
            }
            this.myTypes.add(clazz);
        }

        public Set<PsiClass> getTypes() {
            return this.myTypes;
        }
    }
}

