/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ServiceLoader;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestEngine;

class ServiceLoaderTestEngineRegistry {
    private static final Logger LOG = Logger.getLogger(ServiceLoaderTestEngineRegistry.class.getName());

    ServiceLoaderTestEngineRegistry() {
    }

    public Iterable<TestEngine> loadTestEngines() {
        ServiceLoader<TestEngine> testEngines = ServiceLoader.load(TestEngine.class, ReflectionUtils.getDefaultClassLoader());
        LOG.info(() -> "Discovered TestEngines with IDs: " + StreamSupport.stream(testEngines.spliterator(), false).map(TestEngine::getId).collect(Collectors.toList()));
        return testEngines;
    }
}

