/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.listeners;

import java.util.stream.Stream;
import org.junit.platform.commons.meta.API;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.listeners.MutableTestExecutionSummary;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

@API(value=API.Usage.Experimental)
public class SummaryGeneratingListener
implements TestExecutionListener {
    private TestPlan testPlan;
    private MutableTestExecutionSummary summary;

    public TestExecutionSummary getSummary() {
        return this.summary;
    }

    @Override
    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlan = testPlan;
        this.summary = new MutableTestExecutionSummary(testPlan);
    }

    @Override
    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.summary.timeFinished = System.currentTimeMillis();
    }

    @Override
    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        this.summary.testsFound.incrementAndGet();
    }

    @Override
    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        long skippedTests = Stream.concat(Stream.of(testIdentifier), this.testPlan.getDescendants(testIdentifier).stream()).filter(TestIdentifier::isTest).count();
        this.summary.testsSkipped.addAndGet(skippedTests);
    }

    @Override
    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest()) {
            this.summary.testsStarted.incrementAndGet();
        }
    }

    @Override
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testIdentifier.isTest()) {
            if (testExecutionResult.getStatus() == TestExecutionResult.Status.SUCCESSFUL) {
                this.summary.testsSucceeded.incrementAndGet();
            } else if (testExecutionResult.getStatus() == TestExecutionResult.Status.ABORTED) {
                this.summary.testsAborted.incrementAndGet();
            } else if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
                this.summary.testsFailed.incrementAndGet();
                testExecutionResult.getThrowable().ifPresent(throwable -> this.summary.addFailure(testIdentifier, (Throwable)throwable));
            }
        }
    }
}

