/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.event;

import com.intellij.openapi.editor.Editor;
import java.awt.Rectangle;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;

public class VisibleAreaEvent
extends EventObject {
    private final Rectangle myOldRectangle;
    private final Rectangle myNewRectangle;

    public VisibleAreaEvent(@NotNull Editor editor, Rectangle oldViewRectangle, @NotNull Rectangle newViewRectangle) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/event/VisibleAreaEvent", "<init>"));
        }
        if (newViewRectangle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newViewRectangle", "com/intellij/openapi/editor/event/VisibleAreaEvent", "<init>"));
        }
        super(editor);
        this.myNewRectangle = newViewRectangle;
        this.myOldRectangle = oldViewRectangle;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = (Editor)this.getSource();
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/event/VisibleAreaEvent", "getEditor"));
        }
        return editor;
    }

    public Rectangle getOldRectangle() {
        return this.myOldRectangle;
    }

    @NotNull
    public Rectangle getNewRectangle() {
        Rectangle rectangle = this.myNewRectangle;
        if (rectangle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/event/VisibleAreaEvent", "getNewRectangle"));
        }
        return rectangle;
    }
}

