/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.event.KeyEvent;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public abstract class SearchFieldAction
extends AnAction
implements CustomComponentAction {
    private final JPanel myComponent;
    private final SearchTextField myField = new SearchTextField(true){

        @Override
        protected boolean preprocessEventForTextField(KeyEvent e) {
            if (10 == e.getKeyCode() || '\n' == e.getKeyChar()) {
                e.consume();
                this.addCurrentTextToHistory();
                SearchFieldAction.this.actionPerformed(null);
            }
            return super.preprocessEventForTextField(e);
        }

        @Override
        protected void onFocusLost() {
            SearchFieldAction.this.myField.addCurrentTextToHistory();
            SearchFieldAction.this.actionPerformed(null);
        }

        @Override
        protected void onFieldCleared() {
            SearchFieldAction.this.actionPerformed(null);
        }
    };

    public SearchFieldAction(String text) {
        super("Find: ");
        Border border = this.myField.getBorder();
        Border emptyBorder = IdeBorderFactory.createEmptyBorder(3, 0, 2, 0);
        if (border instanceof CompoundBorder) {
            if (!UIUtil.isUnderDarcula()) {
                this.myField.setBorder(new CompoundBorder(emptyBorder, ((CompoundBorder)border).getInsideBorder()));
            }
        } else {
            this.myField.setBorder(emptyBorder);
        }
        this.myField.setSearchIcon(AllIcons.Actions.Filter_small);
        this.myComponent = new JPanel();
        BoxLayout layout = new BoxLayout(this.myComponent, 0);
        this.myComponent.setLayout(layout);
        if (text.length() > 0) {
            JLabel label = new JLabel(text);
            label.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getInactiveTextColor());
            label.setBorder((Border)JBUI.Borders.emptyLeft((int)3));
            this.myComponent.add(label);
        }
        this.myComponent.add(this.myField);
    }

    public String getText() {
        return this.myField.getText();
    }

    @Override
    public JComponent createCustomComponent(Presentation presentation) {
        return this.myComponent;
    }

    public void setTextFieldFg(boolean inactive) {
        this.myField.getTextEditor().setForeground(inactive ? UIUtil.getInactiveTextColor() : UIUtil.getActiveTextColor());
    }
}

