/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.converters.AbstractMethodParams;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMethodResolveConverter<ParentType extends DomElement>
extends ResolvingConverter<PsiMethod> {
    public static final String ALL_METHODS = "*";
    private final Class<ParentType> myDomMethodClass;

    protected AbstractMethodResolveConverter(Class<ParentType> domMethodClass) {
        this.myDomMethodClass = domMethodClass;
    }

    @NotNull
    protected abstract Collection<PsiClass> getPsiClasses(ParentType var1, ConvertContext var2);

    @Nullable
    protected abstract AbstractMethodParams getMethodParams(@NotNull ParentType var1);

    @Override
    public void bindReference(GenericDomValue<PsiMethod> genericValue, ConvertContext context, PsiElement element) {
        assert (element instanceof PsiMethod) : "PsiMethod expected";
        PsiMethod psiMethod = (PsiMethod)element;
        ParentType parent = this.getParent(context);
        AbstractMethodParams methodParams = this.getMethodParams(parent);
        genericValue.setStringValue(psiMethod.getName());
        if (methodParams != null) {
            methodParams.undefine();
            for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                methodParams.addMethodParam().setValue(parameter.getType());
            }
        }
    }

    @Override
    public String getErrorMessage(String s, ConvertContext context) {
        ParentType parent = this.getParent(context);
        return CodeInsightBundle.message("error.cannot.resolve.0.1", IdeBundle.message("element.method", new Object[0]), AbstractMethodResolveConverter.getReferenceCanonicalText(s, this.getMethodParams(parent)));
    }

    @NotNull
    protected final ParentType getParent(ConvertContext context) {
        ParentType parent = context.getInvocationElement().getParentOfType(this.myDomMethodClass, true);
        assert (parent != null) : "Can't get parent of type " + this.myDomMethodClass + " for " + context.getInvocationElement();
        ParentType ParentType = parent;
        if (ParentType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/converters/AbstractMethodResolveConverter", "getParent"));
        }
        return ParentType;
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element, String stringValue, PsiMethod resolveResult, ConvertContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/converters/AbstractMethodResolveConverter", "isReferenceTo"));
        }
        if (super.isReferenceTo(element, stringValue, resolveResult, context)) {
            return true;
        }
        Ref result = new Ref((Object)Boolean.FALSE);
        this.processMethods(context, (Processor<PsiMethod>)((Processor)method -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/converters/AbstractMethodResolveConverter", "lambda$isReferenceTo$0"));
            }
            if (method.equals(element)) {
                result.set((Object)Boolean.TRUE);
                return false;
            }
            return true;
        }), (Function<PsiClass, PsiMethod[]>)((Function)s -> s.findMethodsByName(stringValue, true)));
        return (Boolean)result.get();
    }

    protected void processMethods(ConvertContext context, Processor<PsiMethod> processor, Function<PsiClass, PsiMethod[]> methodGetter) {
        for (PsiClass psiClass : this.getPsiClasses(this.getParent(context), context)) {
            if (psiClass == null) continue;
            for (PsiMethod psiMethod : (PsiMethod[])methodGetter.fun((Object)psiClass)) {
                if (processor.process((Object)psiMethod)) continue;
                return;
            }
        }
    }

    @Override
    @NotNull
    public Collection<? extends PsiMethod> getVariants(ConvertContext context) {
        LinkedHashSet methodList = new LinkedHashSet();
        Processor processor = CommonProcessors.notNullProcessor(Processors.cancelableCollectProcessor(methodList));
        this.processMethods(context, (Processor<PsiMethod>)processor, (Function<PsiClass, PsiMethod[]>)((Function)s -> {
            List list = ContainerUtil.findAll(this.getVariants((PsiClass)s), object -> this.acceptMethod((PsiMethod)object, context));
            return list.toArray(new PsiMethod[list.size()]);
        }));
        LinkedHashSet linkedHashSet = methodList;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/converters/AbstractMethodResolveConverter", "getVariants"));
        }
        return linkedHashSet;
    }

    protected Collection<PsiMethod> getVariants(PsiClass s) {
        return Arrays.asList(s.getAllMethods());
    }

    protected boolean acceptMethod(PsiMethod psiMethod, ConvertContext context) {
        return AbstractMethodResolveConverter.methodSuits(psiMethod);
    }

    public static boolean methodSuits(PsiMethod psiMethod) {
        if (psiMethod.isConstructor()) {
            return false;
        }
        return psiMethod.getContainingClass().isInterface() || !psiMethod.hasModifierProperty("final") && !psiMethod.hasModifierProperty("static");
    }

    @Override
    @NotNull
    public Set<String> getAdditionalVariants() {
        Set<String> set = Collections.singleton(ALL_METHODS);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/converters/AbstractMethodResolveConverter", "getAdditionalVariants"));
        }
        return set;
    }

    @Override
    public PsiMethod fromString(String methodName, ConvertContext context) {
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.processMethods(context, (Processor<PsiMethod>)processor, (Function<PsiClass, PsiMethod[]>)((Function)s -> {
            PsiMethod method = AbstractMethodResolveConverter.findMethod(s, methodName, this.getMethodParams(this.getParent(context)));
            if (method != null && this.acceptMethod(method, context)) {
                return new PsiMethod[]{method};
            }
            return PsiMethod.EMPTY_ARRAY;
        }));
        if (processor.isFound()) {
            return (PsiMethod)processor.getFoundValue();
        }
        this.processMethods(context, (Processor<PsiMethod>)processor, (Function<PsiClass, PsiMethod[]>)((Function)s -> s.findMethodsByName(methodName, true)));
        return (PsiMethod)processor.getFoundValue();
    }

    @Override
    public String toString(PsiMethod method, ConvertContext context) {
        return method.getName();
    }

    public static String getReferenceCanonicalText(String name, @Nullable AbstractMethodParams methodParams) {
        StringBuilder sb = new StringBuilder(name);
        if (methodParams == null) {
            sb.append("()");
        } else if (methodParams.getXmlTag() != null) {
            sb.append("(");
            List<GenericDomValue<PsiType>> list = methodParams.getMethodParams();
            boolean first = true;
            for (GenericDomValue<PsiType> value : list) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(value.getStringValue());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    @Nullable
    public static PsiMethod findMethod(PsiClass psiClass, String methodName, @Nullable AbstractMethodParams methodParameters) {
        if (psiClass == null || methodName == null) {
            return null;
        }
        return (PsiMethod)ContainerUtil.find((Object[])psiClass.findMethodsByName(methodName, true), object -> AbstractMethodResolveConverter.methodParamsMatchSignature(methodParameters, object));
    }

    public static boolean methodParamsMatchSignature(@Nullable AbstractMethodParams params, PsiMethod psiMethod) {
        if (params != null && params.getXmlTag() == null) {
            return true;
        }
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        if (params == null) {
            return parameters.length == 0;
        }
        List<GenericDomValue<PsiType>> methodParams = params.getMethodParams();
        if (methodParams.size() != parameters.length) {
            return false;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (Comparing.equal((Object)parameters[i].getType(), (Object)methodParams.get(i).getValue())) continue;
            return false;
        }
        return true;
    }
}

