/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.hprof;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.SaveFileListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertHprofDialog
extends DialogWrapper {
    private static final String TITLE = AndroidBundle.message("android.profiler.hprof.actions.conv.savedialog.title", new Object[0]);
    private static String ourLastUsedPath = null;
    private final Project myProject;
    private JPanel myContentPane;
    private TextFieldWithBrowseButton myPathTextFieldWithButton;

    public ConvertHprofDialog(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/ddms/hprof/ConvertHprofDialog", "<init>"));
        }
        super(project);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.setTitle(TITLE);
        if (ourLastUsedPath != null) {
            this.myPathTextFieldWithButton.getTextField().setText(ourLastUsedPath);
        }
        this.myPathTextFieldWithButton.addActionListener((ActionListener)new SaveFileListener(this.myContentPane, this.myPathTextFieldWithButton, TITLE, "hprof"){

            @Override
            @Nullable
            protected String getDefaultLocation() {
                return ConvertHprofDialog.this.myProject.getBasePath();
            }
        });
        this.myPathTextFieldWithButton.setTextFieldPreferredWidth(60);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String path = this.myPathTextFieldWithButton.getText().trim();
        JTextField textField = this.myPathTextFieldWithButton.getTextField();
        if (path.isEmpty()) {
            return new ValidationInfo("Destination should not be empty", (JComponent)textField);
        }
        File f = new File(path);
        if (!f.isAbsolute()) {
            return new ValidationInfo("Destination path must be absolute.", (JComponent)textField);
        }
        if (f.getParentFile() == null || !f.getParentFile().isDirectory()) {
            return new ValidationInfo("Invalid path", (JComponent)textField);
        }
        return null;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "AndroidSaveHprofDialogDimensions";
    }

    protected void doOKAction() {
        ourLastUsedPath = this.myPathTextFieldWithButton.getText().trim();
        super.doOKAction();
    }

    @NotNull
    public File getHprofFile() {
        File file = new File(this.myPathTextFieldWithButton.getText().trim());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ddms/hprof/ConvertHprofDialog", "getHprofFile"));
        }
        return file;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Save As:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPathTextFieldWithButton = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

