/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.path;

import com.android.tools.idea.editors.gfxtrace.service.memory.MemoryRange;
import com.android.tools.idea.editors.gfxtrace.service.memory.PoolID;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomsPath;
import com.android.tools.idea.editors.gfxtrace.service.path.FieldPath;
import com.android.tools.idea.editors.gfxtrace.service.path.MemoryRangePath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.ResourceID;
import com.android.tools.idea.editors.gfxtrace.service.path.ResourcePath;
import com.android.tools.idea.editors.gfxtrace.service.path.StatePath;
import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import com.android.tools.rpclib.schema.Entity;
import com.android.tools.rpclib.schema.Field;
import com.android.tools.rpclib.schema.Method;
import com.android.tools.rpclib.schema.Pointer;
import com.android.tools.rpclib.schema.Primitive;
import com.android.tools.rpclib.schema.Struct;
import com.android.tools.rpclib.schema.Type;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class AtomPath
extends Path {
    private AtomsPath myAtoms;
    private long myIndex;
    private static final Entity ENTITY = new Entity("path", "Atom", "", "");

    @Override
    public StringBuilder stringPath(StringBuilder builder) {
        return this.myAtoms.stringPath(builder).append("[").append(this.myIndex).append("]");
    }

    @Override
    public Path getParent() {
        return this.myAtoms;
    }

    public StatePath stateAfter() {
        return new StatePath().setAfter(this);
    }

    public static StatePath stateAfter(AtomPath atomPath) {
        return atomPath == null ? null : atomPath.stateAfter();
    }

    public ResourcePath resourceAfter(ResourceID id) {
        return new ResourcePath().setAfter(this).setID(id);
    }

    public MemoryRangePath memoryAfter(PoolID pool, MemoryRange range) {
        return new MemoryRangePath().setAfter(this).setPool(pool.getValue()).setAddress(range.getBase()).setSize(range.getSize());
    }

    public FieldPath field(String name) {
        return new FieldPath().setStruct(this).setName(name);
    }

    public AtomsPath getAtoms() {
        return this.myAtoms;
    }

    public AtomPath setAtoms(AtomsPath v) {
        this.myAtoms = v;
        return this;
    }

    public long getIndex() {
        return this.myIndex;
    }

    public AtomPath setIndex(long v) {
        this.myIndex = v;
        return this;
    }

    @NotNull
    public BinaryClass klass() {
        Klass klass = Klass.INSTANCE;
        if (klass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/path/AtomPath", "klass"));
        }
        return klass;
    }

    public static void register() {
    }

    static {
        ENTITY.setFields(new Field[]{new Field("Atoms", (Type)new Pointer((Type)new Struct(AtomsPath.Klass.INSTANCE.entity()))), new Field("Index", (Type)new Primitive("uint64", Method.Uint64))});
        Namespace.register((BinaryClass)Klass.INSTANCE);
    }

    public static enum Klass implements BinaryClass
    {
        INSTANCE;


        @NotNull
        public Entity entity() {
            Entity entity = ENTITY;
            if (entity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/path/AtomPath$Klass", "entity"));
            }
            return entity;
        }

        @NotNull
        public BinaryObject create() {
            AtomPath atomPath = new AtomPath();
            if (atomPath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/path/AtomPath$Klass", "create"));
            }
            return atomPath;
        }

        public void encode(@NotNull Encoder e, BinaryObject obj) throws IOException {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/editors/gfxtrace/service/path/AtomPath$Klass", "encode"));
            }
            AtomPath o = (AtomPath)obj;
            e.object((BinaryObject)o.myAtoms);
            e.uint64(o.myIndex);
        }

        public void decode(@NotNull Decoder d, BinaryObject obj) throws IOException {
            if (d == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/idea/editors/gfxtrace/service/path/AtomPath$Klass", "decode"));
            }
            AtomPath o = (AtomPath)obj;
            o.myAtoms = (AtomsPath)d.object();
            o.myIndex = d.uint64();
        }
    }
}

