/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dependencies;

import com.android.tools.idea.dependencies.DependencyManager;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleDependencyManager
extends DependencyManager {
    private static final String ADD_DEPENDENCY = "Add Dependency";

    @NotNull
    public static GradleDependencyManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "getInstance"));
        }
        GradleDependencyManager gradleDependencyManager = (GradleDependencyManager)ServiceManager.getService((Project)project, GradleDependencyManager.class);
        if (gradleDependencyManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "getInstance"));
        }
        return gradleDependencyManager;
    }

    @Override
    @NotNull
    public List<String> findMissingDependencies(@NotNull Module module, @NotNull Iterable<String> androidDependencies) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "findMissingDependencies"));
        }
        if (androidDependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidDependencies", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "findMissingDependencies"));
        }
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        assert (buildModel != null);
        List<String> list = GradleDependencyManager.findMissingLibrariesFromGradleBuildFile(buildModel, androidDependencies);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "findMissingDependencies"));
        }
        return list;
    }

    @Override
    public boolean ensureLibraryIsIncluded(@NotNull Module module, @NotNull Iterable<String> androidDependencies, @Nullable Runnable callback) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "ensureLibraryIsIncluded"));
        }
        if (androidDependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidDependencies", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "ensureLibraryIsIncluded"));
        }
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        assert (buildModel != null);
        List<String> missing = GradleDependencyManager.findMissingLibrariesFromGradleBuildFile(buildModel, androidDependencies);
        if (missing.isEmpty()) {
            return true;
        }
        if (GradleDependencyManager.userWantToAddDependencies(module, missing)) {
            GradleDependencyManager.addDependenciesInTransaction(buildModel, module, missing, callback);
        }
        return false;
    }

    private static List<String> findMissingLibrariesFromGradleBuildFile(@NotNull GradleBuildModel buildModel, @NotNull Iterable<String> pathIds) {
        if (buildModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildModel", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "findMissingLibrariesFromGradleBuildFile"));
        }
        if (pathIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathIds", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "findMissingLibrariesFromGradleBuildFile"));
        }
        ArrayList missingLibraries = Lists.newArrayList();
        RepositoryUrlManager manager = RepositoryUrlManager.get();
        for (String pathId : pathIds) {
            String libraryCoordinate = manager.getLibraryCoordinate(pathId);
            boolean dependencyFound = false;
            for (ArtifactDependencyModel dependency : buildModel.dependencies().artifacts("compile")) {
                String compactNotation = dependency.getSpec().compactNotation();
                if (!compactNotation.equals(libraryCoordinate)) continue;
                dependencyFound = true;
                break;
            }
            if (dependencyFound) continue;
            missingLibraries.add(pathId);
        }
        return missingLibraries;
    }

    private static boolean userWantToAddDependencies(@NotNull Module module, @NotNull List<String> missing) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "userWantToAddDependencies"));
        }
        if (missing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "missing", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "userWantToAddDependencies"));
        }
        String libraryNames = StringUtil.join(missing, (String)", ");
        String message = String.format("This operation requires the %1$s: %2$s. \n\nWould you like to add %3$s %1$s now?", StringUtil.pluralize((String)"library", (int)missing.size()), libraryNames, StringUtil.pluralize((String)"this", (int)missing.size()));
        Project project = module.getProject();
        return Messages.showOkCancelDialog((Project)project, (String)message, (String)"Add Project Dependency", (Icon)Messages.getErrorIcon()) == 0;
    }

    private static void addDependenciesInTransaction(final @NotNull GradleBuildModel buildModel, final @NotNull Module module, @NotNull List<String> missing, final @Nullable Runnable callback) {
        if (buildModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildModel", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "addDependenciesInTransaction"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "addDependenciesInTransaction"));
        }
        if (missing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "missing", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "addDependenciesInTransaction"));
        }
        assert (!missing.isEmpty());
        final ArrayList missingLibraryCoordinates = Lists.newArrayList();
        RepositoryUrlManager manager = RepositoryUrlManager.get();
        for (String pathId : missing) {
            missingLibraryCoordinates.add(manager.getLibraryCoordinate(pathId));
        }
        final Project project = module.getProject();
        new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager$1", "run"));
                }
                GradleDependencyManager.addDependencies(buildModel, module, missingLibraryCoordinates);
                GradleProjectImporter.getInstance().requestProjectSync(project, false, GradleDependencyManager.createSyncListener(callback));
            }
        }.execute();
    }

    private static void addDependencies(final @NotNull GradleBuildModel buildModel, @NotNull Module module, final @NotNull List<String> libraryCoordinates) {
        if (buildModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildModel", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "addDependencies"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "addDependencies"));
        }
        if (libraryCoordinates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryCoordinates", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager", "addDependencies"));
        }
        ModuleRootModificationUtil.updateModel((Module)module, (Consumer)new Consumer<ModifiableRootModel>(){

            public void consume(ModifiableRootModel model) {
                DependenciesModel dependenciesModel = buildModel.dependencies();
                for (String libraryCoordinate : libraryCoordinates) {
                    dependenciesModel.addArtifact("compile", libraryCoordinate);
                }
                buildModel.applyChanges();
            }
        });
    }

    @Nullable
    private static GradleSyncListener createSyncListener(final @Nullable Runnable callback) {
        if (callback == null) {
            return null;
        }
        return new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager$3", "syncSucceeded"));
                }
                callback.run();
            }

            @Override
            public void syncSkipped(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dependencies/GradleDependencyManager$3", "syncSkipped"));
                }
                callback.run();
            }
        };
    }
}

