/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.gradle.run.RunAsValidator;
import com.android.tools.idea.run.AndroidDevice;
import com.google.common.collect.Sets;
import com.intellij.openapi.components.ServiceManager;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RunAsValidityService
implements RunAsValidator {
    private static final Set<String> ourBrokenDevices = Sets.newConcurrentHashSet();

    public static RunAsValidityService getInstance() {
        return (RunAsValidityService)ServiceManager.getService(RunAsValidityService.class);
    }

    private RunAsValidityService() {
    }

    @Override
    public boolean hasWorkingRunAs(@NotNull AndroidDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/gradle/run/RunAsValidityService", "hasWorkingRunAs"));
        }
        if (device.isVirtual()) {
            return true;
        }
        return !ourBrokenDevices.contains(device.getSerial());
    }

    public boolean hasWorkingRunAs(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/gradle/run/RunAsValidityService", "hasWorkingRunAs"));
        }
        if (device.isEmulator()) {
            return true;
        }
        return !ourBrokenDevices.contains(device.getSerialNumber());
    }

    public void addInvalidDevice(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/gradle/run/RunAsValidityService", "addInvalidDevice"));
        }
        ourBrokenDevices.add(device.getSerialNumber());
    }
}

