/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.sdk;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.base.Strings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class GradleAndroidSdkEventListener
implements IdeSdks.AndroidSdkEventListener {
    private static Logger LOG = Logger.getInstance(GradleAndroidSdkEventListener.class);

    @Override
    public void afterSdkPathChange(@NotNull File sdkPath, @NotNull Project project) {
        LocalProperties localProperties;
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "com/android/tools/idea/gradle/sdk/GradleAndroidSdkEventListener", "afterSdkPathChange"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/sdk/GradleAndroidSdkEventListener", "afterSdkPathChange"));
        }
        if (!Projects.isBuildWithGradle(project)) {
            return;
        }
        try {
            localProperties = new LocalProperties(project);
        }
        catch (IOException e) {
            GradleAndroidSdkEventListener.logAndShowErrorWhenUpdatingLocalProperties(project, e, "read", sdkPath);
            return;
        }
        if (!FileUtil.filesEqual((File)sdkPath, (File)localProperties.getAndroidSdkPath())) {
            try {
                localProperties.setAndroidSdkPath(sdkPath);
                localProperties.save();
            }
            catch (IOException e) {
                GradleAndroidSdkEventListener.logAndShowErrorWhenUpdatingLocalProperties(project, e, "update", sdkPath);
                return;
            }
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            GradleProjectImporter.getInstance().requestProjectSync(project, null);
        }
    }

    private static void logAndShowErrorWhenUpdatingLocalProperties(@NotNull Project project, @NotNull Exception error, @NotNull String action, @NotNull File sdkHomePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/sdk/GradleAndroidSdkEventListener", "logAndShowErrorWhenUpdatingLocalProperties"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/sdk/GradleAndroidSdkEventListener", "logAndShowErrorWhenUpdatingLocalProperties"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/gradle/sdk/GradleAndroidSdkEventListener", "logAndShowErrorWhenUpdatingLocalProperties"));
        }
        if (sdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomePath", "com/android/tools/idea/gradle/sdk/GradleAndroidSdkEventListener", "logAndShowErrorWhenUpdatingLocalProperties"));
        }
        LOG.info((Throwable)error);
        String msg = String.format("Unable to %1$s local.properties file in project '%2$s'.\n\nCause: %3$s\n\nPlease manually update the file's '%4$s' property value to \n'%5$s'\nand sync the project with Gradle files.", action, project.getName(), GradleAndroidSdkEventListener.getMessage(error), "sdk.dir", sdkHomePath.getPath());
        Messages.showErrorDialog((Project)project, (String)msg, (String)"Project SDK Update");
    }

    @NotNull
    private static String getMessage(@NotNull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/sdk/GradleAndroidSdkEventListener", "getMessage"));
        }
        String cause = e.getMessage();
        String string = Strings.isNullOrEmpty((String)cause) ? "[Unknown]" : cause;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/sdk/GradleAndroidSdkEventListener", "getMessage"));
        }
        return string;
    }
}

