/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.editor.dependencies;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Library;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.DependenciesPanel;
import com.android.tools.idea.gradle.structure.configurables.editor.treeview.ContainerNode;
import com.android.tools.idea.gradle.structure.configurables.editor.treeview.GradleNode;
import com.android.tools.idea.gradle.structure.configurables.editor.treeview.VariantNode;
import com.android.tools.idea.gradle.structure.configurables.model.ArtifactDependencyMergedModel;
import com.android.tools.idea.gradle.structure.configurables.model.Coordinates;
import com.google.common.collect.Lists;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import icons.AndroidIcons;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DependenciesTreeStructure
extends AbstractTreeStructure {
    @NotNull
    private final DependenciesPanel myDependenciesPanel;
    @NotNull
    private final GradleNode myRoot;

    DependenciesTreeStructure(@NotNull DependenciesPanel dependenciesPanel) {
        if (dependenciesPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependenciesPanel", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesTreeStructure", "<init>"));
        }
        this.myDependenciesPanel = dependenciesPanel;
        AndroidProject androidProject = this.myDependenciesPanel.getModel().getAndroidProject();
        this.myRoot = new ContainerNode.Variants(androidProject, true);
        this.myRoot.setAutoExpand(true);
    }

    public Object getRootElement() {
        return this.myRoot;
    }

    public Object[] getChildElements(Object element) {
        if (element instanceof GradleNode) {
            GradleNode node = (GradleNode)((Object)element);
            GradleNode[] children = node.getChildren();
            if (children != null) {
                return children;
            }
            if (node instanceof VariantNode) {
                this.setChildren((VariantNode)node);
                return node.getChildren();
            }
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private void setChildren(@NotNull VariantNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesTreeStructure", "setChildren"));
        }
        Variant variant = node.getVariant();
        ArrayList children = Lists.newArrayList();
        this.collectDependencies(node, (BaseArtifact)variant.getMainArtifact(), children);
        for (AndroidArtifact artifact : variant.getExtraAndroidArtifacts()) {
            this.collectDependencies(node, (BaseArtifact)artifact, children);
        }
        for (AndroidArtifact artifact : variant.getExtraJavaArtifacts()) {
            this.collectDependencies(node, (BaseArtifact)artifact, children);
        }
        Collections.sort(children, new Comparator<GradleNode>(){

            @Override
            public int compare(GradleNode o1, GradleNode o2) {
                if (o1 instanceof ArtifactNode) {
                    ArtifactNode n1 = (ArtifactNode)o1;
                    if (o2 instanceof ArtifactNode) {
                        ArtifactNode n2 = (ArtifactNode)o2;
                        if (n1.isInBuildFile() == n2.isInBuildFile()) {
                            return Collator.getInstance().compare(n1.getName(), n2.getName());
                        }
                        return n1.isInBuildFile() ? -1 : 1;
                    }
                }
                return -1;
            }
        });
        node.setChildren(children);
    }

    private void collectDependencies(@NotNull VariantNode node, @NotNull BaseArtifact artifact, @NotNull List<GradleNode> children) {
        ArtifactNode child;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesTreeStructure", "collectDependencies"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesTreeStructure", "collectDependencies"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesTreeStructure", "collectDependencies"));
        }
        Dependencies dependencies = artifact.getDependencies();
        for (JavaLibrary library : dependencies.getJavaLibraries()) {
            child = this.addIfMatching(node, (Library)library, children);
            if (child == null) continue;
            this.addTransitiveDependencies(child, library.getDependencies());
        }
        for (JavaLibrary library : dependencies.getLibraries()) {
            child = this.addIfMatching(node, (Library)library, children);
            if (child == null) continue;
            this.addTransitiveDependencies(child, library.getLibraryDependencies());
        }
    }

    @Nullable
    private ArtifactNode addIfMatching(@NotNull GradleNode node, @NotNull Library library, @NotNull List<GradleNode> children) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesTreeStructure", "addIfMatching"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesTreeStructure", "addIfMatching"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesTreeStructure", "addIfMatching"));
        }
        ArtifactDependencyMergedModel dependencyModel = this.myDependenciesPanel.find(library);
        GradleCoordinate coordinate = DependenciesTreeStructure.getGradleCoordinate(library, dependencyModel);
        if (coordinate != null) {
            ArtifactNode child = new ArtifactNode(coordinate, node, dependencyModel);
            children.add(child);
            return child;
        }
        return null;
    }

    private void addTransitiveDependencies(@NotNull ArtifactNode node, @NotNull List<? extends Library> dependencies) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesTreeStructure", "addTransitiveDependencies"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesTreeStructure", "addTransitiveDependencies"));
        }
        ArrayList transitiveNodes = Lists.newArrayList();
        for (Library library : dependencies) {
            ArtifactDependencyMergedModel dependencyModel;
            GradleCoordinate coordinate = DependenciesTreeStructure.getGradleCoordinate(library, dependencyModel = this.myDependenciesPanel.find(library));
            if (coordinate == null) continue;
            ArtifactNode child = new ArtifactNode(coordinate, node, this.myDependenciesPanel.find(library));
            transitiveNodes.add(child);
        }
        if (!transitiveNodes.isEmpty()) {
            node.setChildren(transitiveNodes);
        }
    }

    @Nullable
    private static GradleCoordinate getGradleCoordinate(@NotNull Library library, @Nullable ArtifactDependencyMergedModel dependencyModel) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesTreeStructure", "getGradleCoordinate"));
        }
        GradleCoordinate coordinate = null;
        if (dependencyModel != null) {
            coordinate = dependencyModel.getCoordinate();
        } else {
            MavenCoordinates coordinates = library.getResolvedCoordinates();
            if (coordinates != null) {
                coordinate = Coordinates.convert(coordinates);
            }
        }
        return coordinate;
    }

    @Nullable
    public Object getParentElement(Object element) {
        if (element instanceof GradleNode) {
            GradleNode node = (GradleNode)((Object)element);
            return node.getParentDescriptor();
        }
        return null;
    }

    @NotNull
    public GradleNode createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        if (element instanceof GradleNode) {
            GradleNode gradleNode = (GradleNode)((Object)element);
            if (gradleNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesTreeStructure", "createDescriptor"));
            }
            return gradleNode;
        }
        throw new IllegalArgumentException("Failed to find a node descriptor for " + element);
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    static class ArtifactNode
    extends GradleNode {
        @NotNull
        final GradleCoordinate coordinate;
        @Nullable
        final ArtifactDependencyMergedModel dependencyModel;

        ArtifactNode(@NotNull GradleCoordinate coordinate, @Nullable GradleNode parentDescriptor, @Nullable ArtifactDependencyMergedModel dependencyModel) {
            if (coordinate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinate", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesTreeStructure$ArtifactNode", "<init>"));
            }
            super(parentDescriptor);
            this.coordinate = coordinate;
            this.dependencyModel = dependencyModel;
            this.myName = coordinate.getArtifactId() + ":" + coordinate.getRevision();
            this.myClosedIcon = dependencyModel != null ? PlatformIcons.LIBRARY_ICON : AndroidIcons.ProjectStructure.UnknownLibrary;
            this.setChildren(NO_CHILDREN);
            this.setAutoExpand(true);
        }

        boolean isInBuildFile() {
            return this.dependencyModel != null;
        }

        @NotNull
        public Object[] getEqualityObjects() {
            Object[] objectArray;
            if (this.dependencyModel != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.dependencyModel;
            } else {
                objectArray = super.getEqualityObjects();
            }
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesTreeStructure$ArtifactNode", "getEqualityObjects"));
            }
            return objectArray;
        }
    }
}

