/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.resources.ScreenSize;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.model.MergedManifestInfo;
import com.android.tools.idea.model.PrimaryManifestInfo;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.ActivityAlias;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.Service;
import org.jetbrains.android.dom.manifest.UsesFeature;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ManifestInfo {
    static final Key<ManifestInfo> MANIFEST_FINDER = new Key("adt-manifest-info");
    static final Key<ManifestInfo> MERGED_MANIFEST_FINDER = new Key("adt-merged-manifest-info");

    @NotNull
    public static ManifestInfo get(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/model/ManifestInfo", "get"));
        }
        ManifestInfo manifestInfo = ManifestInfo.get(module, false);
        if (manifestInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/ManifestInfo", "get"));
        }
        return manifestInfo;
    }

    public static ManifestInfo get(@NotNull Module module, boolean useMergedManifest) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/model/ManifestInfo", "get"));
        }
        Key<ManifestInfo> key = useMergedManifest ? MERGED_MANIFEST_FINDER : MANIFEST_FINDER;
        ManifestInfo finder = (ManifestInfo)module.getUserData(key);
        if (finder == null) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) {
                throw new IllegalArgumentException("Manifest information can only be obtained on modules with the Android facet.");
            }
            finder = ManifestInfo.get(facet, useMergedManifest);
        }
        return finder;
    }

    public static ManifestInfo get(@NotNull AndroidFacet facet, boolean useMergedManifest) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/model/ManifestInfo", "get"));
        }
        Key<ManifestInfo> key = useMergedManifest ? MERGED_MANIFEST_FINDER : MANIFEST_FINDER;
        Module module = facet.getModule();
        ManifestInfo finder = (ManifestInfo)module.getUserData(key);
        if (finder == null) {
            finder = useMergedManifest ? new MergedManifestInfo(facet) : new PrimaryManifestInfo(module);
            module.putUserData(key, (Object)finder);
        }
        return finder;
    }

    public abstract void clear();

    @Nullable
    public abstract String getPackage();

    @NotNull
    public abstract Map<String, ActivityAttributes> getActivityAttributesMap();

    @Nullable
    public abstract ActivityAttributes getActivityAttributes(@NotNull String var1);

    @Nullable
    public abstract String getManifestTheme();

    @NotNull
    public abstract String getDefaultTheme(@Nullable IAndroidTarget var1, @Nullable ScreenSize var2, @Nullable Device var3);

    @Nullable
    public abstract String getApplicationIcon();

    @Nullable
    public abstract String getApplicationLabel();

    public abstract boolean isRtlSupported();

    @Nullable
    public abstract Boolean getApplicationDebuggable();

    @NotNull
    public abstract AndroidVersion getTargetSdkVersion();

    @NotNull
    public abstract AndroidVersion getMinSdkVersion();

    @NotNull
    public List<Activity> getActivities() {
        List<Activity> list = this.getApplicationComponents(new Function<Application, List<Activity>>(){

            public List<Activity> fun(Application application) {
                return application.getActivities();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/ManifestInfo", "getActivities"));
        }
        return list;
    }

    @NotNull
    public List<ActivityAlias> getActivityAliases() {
        List<ActivityAlias> list = this.getApplicationComponents(new Function<Application, List<ActivityAlias>>(){

            public List<ActivityAlias> fun(Application application) {
                return application.getActivityAliass();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/ManifestInfo", "getActivityAliases"));
        }
        return list;
    }

    @NotNull
    public List<Service> getServices() {
        List<Service> list = this.getApplicationComponents(new Function<Application, List<Service>>(){

            public List<Service> fun(Application application) {
                return application.getServices();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/ManifestInfo", "getServices"));
        }
        return list;
    }

    private <T> List<T> getApplicationComponents(final Function<Application, List<T>> accessor) {
        final List<Manifest> manifests = this.getManifests();
        if (manifests.isEmpty()) {
            Logger.getInstance(ManifestInfo.class).warn("List of manifests is empty, possibly needs a gradle sync.");
        }
        return (List)ApplicationManager.getApplication().runReadAction(new Computable<List<T>>(){

            public List<T> compute() {
                ArrayList components = Lists.newArrayList();
                for (Manifest m : manifests) {
                    Application application = m.getApplication();
                    if (application == null) continue;
                    components.addAll((Collection)accessor.fun((Object)application));
                }
                return components;
            }
        });
    }

    @NotNull
    public List<UsesFeature> getUsedFeatures() {
        final List<Manifest> manifests = this.getManifests();
        if (manifests.isEmpty()) {
            Logger.getInstance(ManifestInfo.class).warn("List of manifests is empty, possibly needs a gradle sync.");
        }
        List list = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<UsesFeature>>(){

            public List<UsesFeature> compute() {
                ArrayList usesFeatures = Lists.newArrayList();
                for (Manifest m : manifests) {
                    usesFeatures.addAll(m.getUsesFeatures());
                }
                return usesFeatures;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/ManifestInfo", "getUsedFeatures"));
        }
        return list;
    }

    @NotNull
    protected abstract List<Manifest> getManifests();

    public static class ActivityAttributes {
        @Nullable
        private final String myIcon;
        @Nullable
        private final String myLabel;
        @NotNull
        private final String myName;
        @Nullable
        private final String myParentActivity;
        @Nullable
        private final String myTheme;
        @Nullable
        private final String myUiOptions;

        public ActivityAttributes(@NotNull XmlTag activity, @Nullable String packageName) {
            if (activity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/android/tools/idea/model/ManifestInfo$ActivityAttributes", "<init>"));
            }
            String name = activity.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
            if (name == null || name.length() == 0) {
                throw new RuntimeException("Activity name cannot be empty.");
            }
            int index = name.indexOf(46);
            if (index <= 0 && packageName != null && !packageName.isEmpty()) {
                name = packageName + (index == -1 ? "." : "") + name;
            }
            this.myName = name;
            String value = activity.getAttributeValue("icon", "http://schemas.android.com/apk/res/android");
            this.myIcon = value != null && value.length() > 0 ? value : null;
            value = activity.getAttributeValue("label", "http://schemas.android.com/apk/res/android");
            this.myLabel = value != null && value.length() > 0 ? value : null;
            value = activity.getAttributeValue("parentActivityName", "http://schemas.android.com/apk/res/android");
            if (value == null || value.length() == 0) {
                XmlTag[] metaData;
                for (XmlTag data : metaData = activity.findSubTags("meta-data")) {
                    String metaDataName = data.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
                    if (!"android.support.PARENT_ACTIVITY".equals(metaDataName) || (value = data.getAttributeValue("value", "http://schemas.android.com/apk/res/android")) == null || (index = value.indexOf(46)) > 0 || packageName == null || packageName.isEmpty()) continue;
                    value = packageName + (index == -1 ? "." : "") + value;
                    break;
                }
            }
            this.myParentActivity = value != null && value.length() > 0 ? value : null;
            value = activity.getAttributeValue("theme", "http://schemas.android.com/apk/res/android");
            this.myTheme = value != null && value.length() > 0 ? value : null;
            value = activity.getAttributeValue("uiOptions", "http://schemas.android.com/apk/res/android");
            this.myUiOptions = value != null && value.length() > 0 ? value : null;
        }

        @Nullable
        public String getIcon() {
            return this.myIcon;
        }

        @Nullable
        public String getLabel() {
            return this.myLabel;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/model/ManifestInfo$ActivityAttributes", "getName"));
            }
            return string;
        }

        @Nullable
        public String getParentActivity() {
            return this.myParentActivity;
        }

        @Nullable
        public String getTheme() {
            return this.myTheme;
        }

        @Nullable
        public String getUiOptions() {
            return this.myUiOptions;
        }
    }
}

