/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public final class AndroidPackageUtils {
    private AndroidPackageUtils() {
    }

    @NotNull
    public static String getPackageForApplication(@NotNull AndroidFacet androidFacet) {
        if (androidFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidFacet", "com/android/tools/idea/npw/project/AndroidPackageUtils", "getPackageForApplication"));
        }
        AndroidModel androidModel = androidFacet.getAndroidModel();
        assert (androidModel != null);
        String string = androidModel.getApplicationId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/project/AndroidPackageUtils", "getPackageForApplication"));
        }
        return string;
    }

    @NotNull
    public static String getPackageForPath(@NotNull AndroidProjectPaths paths, @NotNull VirtualFile targetDirectory) {
        ProjectRootManager projectManager;
        String suggestedPackage;
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/android/tools/idea/npw/project/AndroidPackageUtils", "getPackageForPath"));
        }
        if (targetDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDirectory", "com/android/tools/idea/npw/project/AndroidPackageUtils", "getPackageForPath"));
        }
        Module module = paths.getModule();
        File srcDirectory = paths.getSrcDirectory();
        if (srcDirectory != null && (suggestedPackage = (projectManager = ProjectRootManager.getInstance((Project)module.getProject())).getFileIndex().getPackageNameByDirectory(targetDirectory)) != null && !suggestedPackage.isEmpty()) {
            String string = suggestedPackage;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/project/AndroidPackageUtils", "getPackageForPath"));
            }
            return string;
        }
        String string = AndroidPackageUtils.getPackageForApplication(paths.getAndroidFacet());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/project/AndroidPackageUtils", "getPackageForPath"));
        }
        return string;
    }

    @NotNull
    public static String getPackageForPath(@NotNull AndroidFacet androidFacet, @NotNull SourceProvider sourceProvider, @NotNull VirtualFile targetDirectory) {
        if (androidFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidFacet", "com/android/tools/idea/npw/project/AndroidPackageUtils", "getPackageForPath"));
        }
        if (sourceProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceProvider", "com/android/tools/idea/npw/project/AndroidPackageUtils", "getPackageForPath"));
        }
        if (targetDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDirectory", "com/android/tools/idea/npw/project/AndroidPackageUtils", "getPackageForPath"));
        }
        String string = AndroidPackageUtils.getPackageForPath(new AndroidProjectPaths(androidFacet, sourceProvider), targetDirectory);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/project/AndroidPackageUtils", "getPackageForPath"));
        }
        return string;
    }

    @NotNull
    public static String getPackageForPath(@NotNull AndroidFacet androidFacet, @NotNull List<SourceProvider> sourceProviders, @NotNull VirtualFile targetDirectory) {
        if (androidFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidFacet", "com/android/tools/idea/npw/project/AndroidPackageUtils", "getPackageForPath"));
        }
        if (sourceProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceProviders", "com/android/tools/idea/npw/project/AndroidPackageUtils", "getPackageForPath"));
        }
        if (targetDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDirectory", "com/android/tools/idea/npw/project/AndroidPackageUtils", "getPackageForPath"));
        }
        if (sourceProviders.size() > 0) {
            String string = AndroidPackageUtils.getPackageForPath(androidFacet, sourceProviders.get(0), targetDirectory);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/project/AndroidPackageUtils", "getPackageForPath"));
            }
            return string;
        }
        String string = AndroidPackageUtils.getPackageForApplication(androidFacet);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/project/AndroidPackageUtils", "getPackageForPath"));
        }
        return string;
    }
}

