/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.google.common.base.Objects;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class TemplateHandle {
    private final File myRootPath;
    private final Template myTemplate;
    private final TemplateMetadata myMetadata;

    public TemplateHandle(@NotNull File rootPath) {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "com/android/tools/idea/npw/template/TemplateHandle", "<init>"));
        }
        this.myRootPath = rootPath;
        this.myTemplate = Template.createFromPath(rootPath);
        this.myMetadata = TemplateManager.getInstance().getTemplateMetadata(rootPath);
    }

    @NotNull
    public File getRootPath() {
        File file = this.myRootPath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/TemplateHandle", "getRootPath"));
        }
        return file;
    }

    @NotNull
    public Template getTemplate() {
        Template template = this.myTemplate;
        if (template == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/TemplateHandle", "getTemplate"));
        }
        return template;
    }

    @NotNull
    public TemplateMetadata getMetadata() {
        TemplateMetadata templateMetadata = this.myMetadata;
        if (templateMetadata == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/TemplateHandle", "getMetadata"));
        }
        return templateMetadata;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myRootPath, this.myMetadata.getTitle()});
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TemplateHandle another = (TemplateHandle)obj;
        return Objects.equal((Object)this.myRootPath, (Object)another.myRootPath) && Objects.equal((Object)this.myMetadata.getTitle(), (Object)another.myMetadata.getTitle());
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("title", (Object)this.myMetadata.getTitle()).add("path", (Object)this.myRootPath.getAbsolutePath()).toString();
    }
}

