/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.databinding.DataBindingUtil;
import com.google.common.collect.Lists;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeSnapshot {
    @Nullable
    public String namespace;
    @Nullable
    public String prefix;
    @NotNull
    public String name;
    @Nullable
    public String value;

    AttributeSnapshot(@Nullable String namespace, @Nullable String prefix, @NotNull String name, @Nullable String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/rendering/AttributeSnapshot", "<init>"));
        }
        this.namespace = namespace;
        this.prefix = prefix == null || prefix.isEmpty() ? null : prefix;
        this.name = name;
        this.value = value;
    }

    @Nullable
    public static AttributeSnapshot createAttributeSnapshot(@NotNull XmlAttribute psiAttribute) {
        if (psiAttribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiAttribute", "com/android/tools/idea/rendering/AttributeSnapshot", "createAttributeSnapshot"));
        }
        String localName = psiAttribute.getLocalName();
        String namespace = psiAttribute.getNamespace();
        String prefix = psiAttribute.getNamespacePrefix();
        String value = psiAttribute.getValue();
        if (value != null && value.startsWith("@{") && (value = DataBindingUtil.getBindingExprDefault(psiAttribute)) == null) {
            return null;
        }
        return new AttributeSnapshot(namespace, prefix, localName, value);
    }

    @NotNull
    public static List<AttributeSnapshot> createAttributesForTag(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/rendering/AttributeSnapshot", "createAttributesForTag"));
        }
        XmlAttribute[] psiAttributes = tag.getAttributes();
        ArrayList attributes = Lists.newArrayListWithExpectedSize((int)psiAttributes.length);
        for (XmlAttribute psiAttribute : psiAttributes) {
            AttributeSnapshot attribute = AttributeSnapshot.createAttributeSnapshot(psiAttribute);
            if (attribute == null) continue;
            attributes.add(attribute);
        }
        ArrayList arrayList = attributes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/AttributeSnapshot", "createAttributesForTag"));
        }
        return arrayList;
    }

    public String toString() {
        return "AttributeSnapshot{" + this.name + "=\"" + this.value + "\"}";
    }
}

