/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.ClassConverter;
import com.android.tools.idea.rendering.InconvertibleClassError;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RenderClassLoader
extends ClassLoader {
    protected static final Logger LOG = Logger.getInstance(RenderClassLoader.class);
    protected UrlClassLoader myJarClassLoader;
    protected boolean myInsideJarClassLoader;

    public RenderClassLoader(@Nullable ClassLoader parent) {
        super(parent);
    }

    protected abstract List<URL> getExternalJars();

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.load(name);
    }

    @NotNull
    protected Class<?> load(String name) throws ClassNotFoundException {
        Class<?> clz = this.loadClassFromJar(name);
        if (clz != null) {
            Class<?> clazz = clz;
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderClassLoader", "load"));
            }
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    @Nullable
    protected Class<?> loadClassFromJar(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/rendering/RenderClassLoader", "loadClassFromJar"));
        }
        if (this.myJarClassLoader == null) {
            List<URL> externalJars = this.getExternalJars();
            this.myJarClassLoader = this.createClassLoader(externalJars);
        }
        try {
            this.myInsideJarClassLoader = true;
            String relative = name.replace('.', '/').concat(".class");
            InputStream is = this.myJarClassLoader.getResourceAsStream(relative);
            if (is != null) {
                byte[] data = ByteStreams.toByteArray((InputStream)is);
                is.close();
                if (!ClassConverter.isValidClassFile(data)) {
                    throw new ClassFormatError(name);
                }
                byte[] rewritten = this.convertClass(data);
                try {
                    Class<?> clazz = this.defineClassAndPackage(name, rewritten, 0, rewritten.length);
                    return clazz;
                }
                catch (UnsupportedClassVersionError inner) {
                    throw InconvertibleClassError.wrap(inner, name, data);
                }
            }
            Class<?> clazz = null;
            return clazz;
        }
        catch (IOException ex) {
            throw new Error("Failed to load class " + name, ex);
        }
        finally {
            this.myInsideJarClassLoader = false;
        }
    }

    protected UrlClassLoader createClassLoader(List<URL> externalJars) {
        return UrlClassLoader.build().parent((ClassLoader)this).urls(externalJars).noPreload().get();
    }

    @Nullable
    protected Class<?> loadClassFromClassPath(String fqcn, File classPathFolder) {
        File classFile = RenderClassLoader.findClassFile(classPathFolder, fqcn);
        if (classFile == null || !classFile.exists()) {
            return null;
        }
        return this.loadClassFile(fqcn, classFile);
    }

    @Nullable
    protected Class<?> loadClassFile(String fqcn, File classFile) {
        try {
            byte[] data = Files.toByteArray((File)classFile);
            return this.loadClass(fqcn, data);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    protected Class<?> loadClass(@NotNull String fqcn, @Nullable byte[] data) {
        if (fqcn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqcn", "com/android/tools/idea/rendering/RenderClassLoader", "loadClass"));
        }
        if (data == null) {
            return null;
        }
        if (!ClassConverter.isValidClassFile(data)) {
            throw new ClassFormatError(fqcn);
        }
        byte[] rewritten = this.convertClass(data);
        try {
            return this.defineClassAndPackage(fqcn, rewritten, 0, rewritten.length);
        }
        catch (UnsupportedClassVersionError inner) {
            throw InconvertibleClassError.wrap(inner, fqcn, data);
        }
    }

    @NotNull
    protected byte[] convertClass(@NotNull byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/rendering/RenderClassLoader", "convertClass"));
        }
        byte[] byArray = ClassConverter.rewriteClass(data);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderClassLoader", "convertClass"));
        }
        return byArray;
    }

    @Nullable
    private static File findClassFile(File parent, String className) {
        if (!parent.exists()) {
            return null;
        }
        File file = new File(parent, className.replace('.', File.separatorChar) + ".class");
        return file.exists() ? file : null;
    }

    @NotNull
    protected Class<?> defineClassAndPackage(@NotNull String name, @NotNull byte[] b, int offset, int len) {
        String packageName;
        Package pkg;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/rendering/RenderClassLoader", "defineClassAndPackage"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/android/tools/idea/rendering/RenderClassLoader", "defineClassAndPackage"));
        }
        int i = name.lastIndexOf(46);
        if (i > 0 && (pkg = this.getPackage(packageName = name.substring(0, i))) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        Class<?> clazz = this.defineClass(name, b, offset, len);
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderClassLoader", "defineClassAndPackage"));
        }
        return clazz;
    }
}

