/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.util.LaunchUtils;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmulatorConnectionListener {
    /*
     * WARNING - void declaration
     */
    public static ListenableFuture<IDevice> getDeviceForEmulator(@NotNull String avdName, @Nullable ProcessHandler emulatorProcessHandler, long timeout, @NotNull TimeUnit timeUnit) {
        void units;
        if (avdName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdName", "com/android/tools/idea/run/EmulatorConnectionListener", "getDeviceForEmulator"));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "units", "com/android/tools/idea/run/EmulatorConnectionListener", "getDeviceForEmulator"));
        }
        if (emulatorProcessHandler == null) {
            return Futures.immediateFailedFuture((Throwable)new RuntimeException("Emulator process for AVD " + avdName + " died."));
        }
        SettableFuture future = SettableFuture.create();
        WaitForEmulatorTask task = new WaitForEmulatorTask(future, avdName, emulatorProcessHandler, timeout, (TimeUnit)units);
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)task);
        return future;
    }

    private static final class WaitForEmulatorTask
    implements Runnable {
        private static final TimeUnit POLL_TIMEUNIT = TimeUnit.SECONDS;
        private final SettableFuture<IDevice> myDeviceFuture;
        private final String myAvdName;
        private final ProcessHandler myEmulatorProcessHandler;
        private final long myTimeout;

        /*
         * WARNING - void declaration
         */
        private WaitForEmulatorTask(@NotNull SettableFuture<IDevice> device, @NotNull String avdName, @NotNull ProcessHandler emulatorProcessHandler, long timeout, @NotNull TimeUnit timeUnit) {
            void units;
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/EmulatorConnectionListener$WaitForEmulatorTask", "<init>"));
            }
            if (avdName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdName", "com/android/tools/idea/run/EmulatorConnectionListener$WaitForEmulatorTask", "<init>"));
            }
            if (emulatorProcessHandler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emulatorProcessHandler", "com/android/tools/idea/run/EmulatorConnectionListener$WaitForEmulatorTask", "<init>"));
            }
            if (timeUnit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "units", "com/android/tools/idea/run/EmulatorConnectionListener$WaitForEmulatorTask", "<init>"));
            }
            this.myDeviceFuture = device;
            this.myAvdName = avdName;
            this.myEmulatorProcessHandler = emulatorProcessHandler;
            this.myTimeout = POLL_TIMEUNIT.convert(timeout, (TimeUnit)units);
        }

        @Override
        public void run() {
            for (long i = 0L; i < this.myTimeout; ++i) {
                if (this.myDeviceFuture.isCancelled()) {
                    return;
                }
                if (this.myEmulatorProcessHandler.isProcessTerminated() || this.myEmulatorProcessHandler.isProcessTerminating()) {
                    this.myDeviceFuture.setException((Throwable)new RuntimeException("The emulator process for AVD " + this.myAvdName + " was killed."));
                    return;
                }
                AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
                if (bridge == null || !bridge.isConnected()) {
                    this.myDeviceFuture.setException((Throwable)new RuntimeException("adb connection not available, or was terminated."));
                    return;
                }
                for (IDevice device : bridge.getDevices()) {
                    if (!device.isEmulator() || !StringUtil.equals((CharSequence)device.getAvdName(), (CharSequence)this.myAvdName) || !WaitForEmulatorTask.isEmulatorReady(device)) continue;
                    LaunchUtils.initiateDismissKeyguard(device);
                    this.myDeviceFuture.set((Object)device);
                    return;
                }
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)POLL_TIMEUNIT);
            }
            String msg = "Timed out after " + POLL_TIMEUNIT.toSeconds(this.myTimeout) + "seconds waiting for emulator to come online.";
            this.myDeviceFuture.setException((Throwable)new TimeoutException(msg));
            Logger.getInstance(EmulatorConnectionListener.class).warn(msg);
        }

        private static boolean isEmulatorReady(@NotNull IDevice device) {
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/EmulatorConnectionListener$WaitForEmulatorTask", "isEmulatorReady"));
            }
            if (!device.isOnline()) {
                return false;
            }
            String bootComplete = device.getProperty("dev.bootcomplete");
            if (bootComplete == null) {
                Logger.getInstance(EmulatorConnectionListener.class).warn("Emulator not ready yet, dev.bootcomplete = null");
                return false;
            }
            return device.getClients().length > 5 || device.getClient("android.process.acore") != null || device.getClient("com.google.android.wearable.app") != null;
        }
    }
}

