/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.build.OutputFile;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.Variant;
import com.android.ddmlib.IDevice;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.structure.editors.AndroidProjectSettingsService;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ValidationError;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class GradleApkProvider
implements ApkProvider {
    private static final Logger LOG = Logger.getInstance(GradleApkProvider.class);
    private static final String DEFAULT_TEST_PACKAGE_SUFFIX = ".test";
    @NotNull
    private final AndroidFacet myFacet;
    private final boolean myTest;

    public GradleApkProvider(@NotNull AndroidFacet facet, boolean test) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/GradleApkProvider", "<init>"));
        }
        this.myFacet = facet;
        this.myTest = test;
    }

    @Override
    @NotNull
    public Collection<ApkInfo> getApks(@NotNull IDevice device) throws ApkProvisionException {
        AndroidArtifact testArtifactInfo;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/GradleApkProvider", "getApks"));
        }
        AndroidGradleModel androidModel = AndroidGradleModel.get(this.myFacet);
        if (androidModel == null) {
            LOG.warn("Android model is null. Sync might have failed");
            List<ApkInfo> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/GradleApkProvider", "getApks"));
            }
            return list;
        }
        Variant selectedVariant = androidModel.getSelectedVariant();
        ArrayList apkList = Lists.newArrayList();
        if (!androidModel.getAndroidProject().isLibrary()) {
            File apk = GradleApkProvider.getApk(selectedVariant, device);
            apkList.add(new ApkInfo(apk, this.getPackageName()));
        }
        if (this.myTest && (testArtifactInfo = androidModel.getAndroidTestArtifactInSelectedVariant()) != null) {
            AndroidArtifactOutput output = GradleUtil.getOutput(testArtifactInfo);
            File testApk = output.getMainOutputFile().getOutputFile();
            String testPackageName = this.getTestPackageName();
            assert (testPackageName != null);
            apkList.add(new ApkInfo(testApk, testPackageName));
        }
        ArrayList arrayList = apkList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/GradleApkProvider", "getApks"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getPackageName() throws ApkProvisionException {
        String string = ApkProviderUtil.computePackageName(this.myFacet);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/GradleApkProvider", "getPackageName"));
        }
        return string;
    }

    @Override
    public String getTestPackageName() throws ApkProvisionException {
        AndroidGradleModel androidModel = AndroidGradleModel.get(this.myFacet);
        assert (androidModel != null);
        Variant selectedVariant = androidModel.getSelectedVariant();
        String testPackageName = selectedVariant.getMergedFlavor().getTestApplicationId();
        return testPackageName != null ? testPackageName : this.getPackageName() + DEFAULT_TEST_PACKAGE_SUFFIX;
    }

    @NotNull
    private static File getApk(@NotNull Variant variant, @NotNull IDevice device) throws ApkProvisionException {
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/run/GradleApkProvider", "getApk"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/GradleApkProvider", "getApk"));
        }
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        ArrayList outputs = Lists.newArrayList((Iterable)mainArtifact.getOutputs());
        if (outputs.isEmpty()) {
            throw new ApkProvisionException("No outputs for the main artifact of variant: " + variant.getDisplayName());
        }
        List abis = device.getAbis();
        int density = device.getDensity();
        Set variantAbiFilters = mainArtifact.getAbiFilters();
        List apkFiles = SplitOutputMatcher.computeBestOutput((List)outputs, (Collection)variantAbiFilters, (int)density, (Collection)abis);
        if (apkFiles.isEmpty()) {
            String message = AndroidBundle.message("deployment.failed.splitapk.nomatch", variant.getDisplayName(), outputs.size(), density, Joiner.on((String)", ").join((Iterable)abis));
            throw new ApkProvisionException(message);
        }
        File file = ((OutputFile)apkFiles.get(0)).getOutputFile();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/GradleApkProvider", "getApk"));
        }
        return file;
    }

    @Override
    @NotNull
    public List<ValidationError> validate() {
        AndroidGradleModel androidGradleModel = AndroidGradleModel.get(this.myFacet);
        assert (androidGradleModel != null);
        if (androidGradleModel.getMainArtifact().isSigned()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/GradleApkProvider", "validate"));
            }
            return immutableList;
        }
        AndroidArtifactOutput output = GradleUtil.getOutput(androidGradleModel.getMainArtifact());
        String message = AndroidBundle.message("run.error.apk.not.signed", output.getMainOutputFile().getOutputFile().getName(), androidGradleModel.getSelectedVariant().getDisplayName());
        Runnable quickFix = new Runnable(){

            @Override
            public void run() {
                Module module = GradleApkProvider.this.myFacet.getModule();
                ProjectSettingsService service = ProjectSettingsService.getInstance((Project)module.getProject());
                if (service instanceof AndroidProjectSettingsService) {
                    ((AndroidProjectSettingsService)service).openSigningConfiguration(module);
                } else {
                    service.openModuleSettings(module);
                }
            }
        };
        ImmutableList immutableList = ImmutableList.of((Object)ValidationError.fatal(message, quickFix));
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/GradleApkProvider", "validate"));
        }
        return immutableList;
    }
}

