/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.fd.client.InstantRunClient;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunStatsService;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkInstaller;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.InstalledApkCache;
import com.android.tools.idea.run.InstalledPatchCache;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.stats.UsageTracker;
import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class DeployApkTask
implements LaunchTask {
    private static final Logger LOG = Logger.getInstance(DeployApkTask.class);
    private final AndroidFacet myFacet;
    private final ApkProvider myApkProvider;
    private final LaunchOptions myLaunchOptions;
    private final boolean myInstantRunAware;
    private static int ourInstallationCount = 0;

    public DeployApkTask(@NotNull AndroidFacet facet, @NotNull LaunchOptions launchOptions, @NotNull ApkProvider apkProvider) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/tasks/DeployApkTask", "<init>"));
        }
        if (launchOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchOptions", "com/android/tools/idea/run/tasks/DeployApkTask", "<init>"));
        }
        if (apkProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apkProvider", "com/android/tools/idea/run/tasks/DeployApkTask", "<init>"));
        }
        this(facet, launchOptions, apkProvider, false);
    }

    public DeployApkTask(@NotNull AndroidFacet facet, @NotNull LaunchOptions launchOptions, @NotNull ApkProvider apkProvider, boolean instantRunAware) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/tasks/DeployApkTask", "<init>"));
        }
        if (launchOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchOptions", "com/android/tools/idea/run/tasks/DeployApkTask", "<init>"));
        }
        if (apkProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apkProvider", "com/android/tools/idea/run/tasks/DeployApkTask", "<init>"));
        }
        this.myFacet = facet;
        this.myLaunchOptions = launchOptions;
        this.myApkProvider = apkProvider;
        this.myInstantRunAware = instantRunAware;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Installing APK" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/tasks/DeployApkTask", "getDescription"));
        }
        return "Installing APK";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        Collection<ApkInfo> apks;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/tasks/DeployApkTask", "perform"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/tasks/DeployApkTask", "perform"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/tasks/DeployApkTask", "perform"));
        }
        try {
            apks = this.myApkProvider.getApks(device);
        }
        catch (ApkProvisionException e) {
            printer.stderr(e.getMessage());
            LOG.warn((Throwable)e);
            return false;
        }
        if (this.myInstantRunAware) {
            try {
                InstantRunManager.transferLocalIdToDeviceId(device, this.myFacet.getModule());
            }
            catch (Exception e) {
                printer.stderr(e.toString());
            }
        }
        ApkInstaller installer = new ApkInstaller(this.myFacet, this.myLaunchOptions, (InstalledApkCache)ServiceManager.getService(InstalledApkCache.class), printer);
        for (ApkInfo apk : apks) {
            if (!apk.getFile().exists()) {
                String message = "The APK file " + apk.getFile().getPath() + " does not exist on disk.";
                printer.stderr(message);
                LOG.error(message);
                return false;
            }
            String pkgName = apk.getApplicationId();
            if (!installer.uploadAndInstallApk(device, pkgName, apk.getFile(), launchStatus)) {
                return false;
            }
            if (this.myInstantRunAware) {
                DeployApkTask.cacheManifestInstallationData(device, this.myFacet, pkgName);
                continue;
            }
            try {
                InstantRunClient.transferBuildIdToDevice((IDevice)device, (String)"", (String)pkgName, null);
            }
            catch (Throwable throwable) {}
        }
        DeployApkTask.trackInstallation(device);
        InstantRunStatsService.get(this.myFacet.getModule().getProject()).notifyDeployType(this.myInstantRunAware ? InstantRunStatsService.DeployType.FULLAPK : InstantRunStatsService.DeployType.LEGACY);
        return true;
    }

    public static void cacheManifestInstallationData(@NotNull IDevice device, @NotNull AndroidFacet facet, @NotNull String pkgName) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/tasks/DeployApkTask", "cacheManifestInstallationData"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/tasks/DeployApkTask", "cacheManifestInstallationData"));
        }
        if (pkgName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkgName", "com/android/tools/idea/run/tasks/DeployApkTask", "cacheManifestInstallationData"));
        }
        InstalledPatchCache patchCache = (InstalledPatchCache)ServiceManager.getService(InstalledPatchCache.class);
        patchCache.setInstalledManifestTimestamp(device, pkgName, InstantRunManager.getManifestLastModified(facet));
        HashCode currentHash = InstalledPatchCache.computeManifestResources(facet);
        patchCache.setInstalledManifestResourcesHash(device, pkgName, currentHash);
    }

    private static void trackInstallation(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/tasks/DeployApkTask", "trackInstallation"));
        }
        if (!UsageTracker.getInstance().canTrack()) {
            return;
        }
        if ((ourInstallationCount = (ourInstallationCount + 1) % 20) != 0) {
            return;
        }
        UsageTracker.getInstance().trackEvent("deployment", "apkDeployed", null, null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.serialno.hashed", Hashing.md5().hashString((CharSequence)device.getSerialNumber(), Charsets.UTF_8).toString(), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.build.tags", device.getProperty("ro.build.tags"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.build.type", device.getProperty("ro.build.type"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.build.version.release", device.getProperty("ro.build.version.release"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.build.version.sdk", device.getProperty("ro.build.version.sdk"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.product.cpu.abi", device.getProperty("ro.product.cpu.abi"), null);
        String manufacturer = device.getProperty("ro.product.manufacturer");
        String model = device.getProperty("ro.product.model");
        String manufacturerModel = manufacturer + "-" + model;
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.product.manufacturer", manufacturer, null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.product.model", model, null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "deviceModel", manufacturerModel, null);
    }
}

