/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ShellCommandLauncher {
    /*
     * WARNING - void declaration
     */
    public static boolean execute(@NotNull String command, @NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer, long timeout, @NotNull TimeUnit timeUnit) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/android/tools/idea/run/tasks/ShellCommandLauncher", "execute"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/tasks/ShellCommandLauncher", "execute"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/tasks/ShellCommandLauncher", "execute"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/tasks/ShellCommandLauncher", "execute"));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeoutUnit", "com/android/tools/idea/run/tasks/ShellCommandLauncher", "execute"));
        }
        printer.stdout("$ adb shell " + command);
        AndroidLaunchReceiver receiver = new AndroidLaunchReceiver(launchStatus);
        try {
            void timeoutUnit;
            device.executeShellCommand(command, (IShellOutputReceiver)receiver, timeout, (TimeUnit)timeoutUnit);
        }
        catch (Exception e) {
            Logger logger = Logger.getInstance(ShellCommandLauncher.class);
            logger.warn("Unexpected exception while executing shell command: " + command);
            logger.warn((Throwable)e);
            launchStatus.terminateLaunch("Unexpected error while executing: " + command);
            return false;
        }
        String output = receiver.getOutput();
        if (output.toLowerCase(Locale.US).contains("error")) {
            launchStatus.terminateLaunch("Error while executing: " + command);
            printer.stderr(output);
            return false;
        }
        return true;
    }

    private static class AndroidLaunchReceiver
    extends CollectingOutputReceiver {
        private final LaunchStatus myLaunchStatus;

        public AndroidLaunchReceiver(@NotNull LaunchStatus state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/tasks/ShellCommandLauncher$AndroidLaunchReceiver", "<init>"));
            }
            this.myLaunchStatus = state;
        }

        public boolean isCancelled() {
            return this.myLaunchStatus.isLaunchTerminated();
        }
    }
}

