/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.utils.IReaderLogger;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public abstract class SdkLoggerIntegration
implements IReaderLogger {
    private static Pattern sLicenceText = Pattern.compile("^\\s*License id:\\s*([a-z0-9-]+).*\\s*");
    private static Pattern sProgress1Text = Pattern.compile("^\\s+\\((([0-9]+)%,\\s*[^)]*)\\)(.*)\\s*");
    private static Pattern sProgress2Text = Pattern.compile("^\\s+(.+)\\s+\\((([0-9]+)%)\\)\\s*");
    private static Pattern sDownloadingComponentText = Pattern.compile("^\\s+(Downloading .*)\\s*$");
    private BackgroundableProcessIndicator myIndicator;
    private String myCurrLicense;
    private String myLastLine;

    public void setIndicator(BackgroundableProcessIndicator indicator) {
        this.myIndicator = indicator;
    }

    public int readLine(@NotNull byte[] inputBuffer) throws IOException {
        if (inputBuffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputBuffer", "com/android/tools/idea/sdk/SdkLoggerIntegration", "readLine"));
        }
        if (this.myLastLine != null && this.myLastLine.contains("Do you accept the license")) {
            inputBuffer[0] = 121;
            inputBuffer[1] = 0;
            return 1;
        }
        inputBuffer[0] = 110;
        inputBuffer[1] = 0;
        return 1;
    }

    public void error(@Nullable Throwable t, @Nullable String msgFormat, Object ... args) {
        if (msgFormat == null && t != null) {
            if (this.myIndicator != null) {
                this.myIndicator.setText2(t.toString());
            }
            this.outputLine(t.toString());
        } else if (msgFormat != null) {
            if (this.myIndicator != null) {
                this.myIndicator.setText2(String.format(msgFormat, args));
            }
            this.outputLine(String.format(msgFormat, args));
        }
    }

    public void warning(@NotNull String msgFormat, Object ... args) {
        if (msgFormat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msgFormat", "com/android/tools/idea/sdk/SdkLoggerIntegration", "warning"));
        }
        if (this.myIndicator != null) {
            this.myIndicator.setText2(String.format(msgFormat, args));
        }
        this.outputLine(String.format(msgFormat, args));
    }

    public void info(@NotNull String msgFormat, Object ... args) {
        if (msgFormat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msgFormat", "com/android/tools/idea/sdk/SdkLoggerIntegration", "info"));
        }
        if (this.myIndicator != null) {
            this.myIndicator.setText2(String.format(msgFormat, args));
        }
        this.outputLine(String.format(msgFormat, args));
    }

    public void verbose(@NotNull String msgFormat, Object ... args) {
        if (msgFormat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msgFormat", "com/android/tools/idea/sdk/SdkLoggerIntegration", "verbose"));
        }
        this.outputLine(String.format(msgFormat, args));
    }

    private void outputLine(final @NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/sdk/SdkLoggerIntegration", "outputLine"));
        }
        this.myLastLine = line;
        try {
            Matcher m = sLicenceText.matcher(line);
            if (m.matches()) {
                this.myCurrLicense = m.group(1);
                return;
            }
            if (this.myCurrLicense != null) {
                if (line.contains("Do you accept the license") && line.contains(this.myCurrLicense)) {
                    this.myCurrLicense = null;
                }
                return;
            }
            if (line.contains("Fetching http") || line.contains("Fetching URL:") || line.contains("Validate XML") || line.contains("Parse XML") || line.contains("---------")) {
                return;
            }
            if (this.parseWithPattern(sProgress1Text, line, 3, 1, 2) || this.parseWithPattern(sProgress2Text, line, 1, 2, 3) || this.parseWithPattern(sDownloadingComponentText, line, 1, -1, -1)) {
                return;
            }
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    SdkLoggerIntegration.this.lineAdded(line);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean parseWithPattern(@NotNull Pattern pattern, @NotNull String line, int titleGroup, int progressTextGroup, int progressGroup) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/android/tools/idea/sdk/SdkLoggerIntegration", "parseWithPattern"));
        }
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/sdk/SdkLoggerIntegration", "parseWithPattern"));
        }
        int progInt = -1;
        Matcher m = pattern.matcher(line);
        if (m.matches()) {
            if (progressGroup >= 0) {
                try {
                    progInt = Integer.parseInt(m.group(progressGroup));
                }
                catch (NumberFormatException ignore) {
                    progInt = 0;
                }
            }
            final int fProgInt = progInt;
            final String fProgText2 = SdkLoggerIntegration.getGroupText(m, progressTextGroup);
            final String fProgText1 = SdkLoggerIntegration.getGroupText(m, titleGroup);
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (fProgText1 != null) {
                        SdkLoggerIntegration.this.setTitle(fProgText1);
                    }
                    if (fProgText2 != null) {
                        SdkLoggerIntegration.this.setDescription(fProgText2);
                    }
                    if (fProgInt >= 0) {
                        SdkLoggerIntegration.this.setProgress(fProgInt);
                    }
                }
            });
            return true;
        }
        return false;
    }

    @Nullable
    private static String getGroupText(Matcher m, int group) {
        return group >= 0 ? m.group(group) : null;
    }

    protected abstract void setProgress(int var1);

    protected abstract void setDescription(String var1);

    protected abstract void setTitle(String var1);

    protected abstract void lineAdded(String var1);
}

