/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote.internal.packages;

import com.android.repository.Revision;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.AndroidVersionHelper;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.local.LocalSysImgPkgInfo;
import com.android.sdklib.repositoryv2.IdDisplay;
import com.android.sdklib.repositoryv2.targets.SystemImage;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.RemotePackageParserUtils;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSource;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;

public class RemoteSystemImagePkgInfo
extends RemotePkgInfo {
    public RemoteSystemImagePkgInfo(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        PkgDesc.Builder descBuilder;
        int apiLevel = RemotePackageParserUtils.getXmlInt(packageNode, "api-level", 0);
        String codeName = RemotePackageParserUtils.getXmlString(packageNode, "codename");
        if (codeName.length() == 0) {
            codeName = null;
        }
        AndroidVersion version = new AndroidVersion(apiLevel, codeName);
        String abi = RemotePackageParserUtils.getXmlString(packageNode, "abi");
        String tagId = RemotePackageParserUtils.getXmlString(packageNode, "tag-id", SystemImage.DEFAULT_TAG.getId());
        String tagDisp = RemotePackageParserUtils.getOptionalXmlString(packageNode, "tag-display");
        if (tagDisp == null || tagDisp.isEmpty()) {
            tagDisp = LocalSysImgPkgInfo.tagIdToDisplay((String)tagId);
        }
        assert (tagId != null);
        IdDisplay tag = IdDisplay.create((String)tagId, (String)tagDisp);
        Node addonNode = RemotePackageParserUtils.findChildElement(packageNode, "add-on");
        IdDisplay vendor = null;
        if (addonNode == null) {
            descBuilder = PkgDesc.Builder.newSysImg((AndroidVersion)version, (IdDisplay)tag, (String)abi, (Revision)this.getRevision());
        } else {
            String vendorId = RemotePackageParserUtils.getXmlString(addonNode, "vendor-id");
            String vendorDisp = RemotePackageParserUtils.getXmlString(addonNode, "vendor-display", vendorId);
            assert (vendorId.length() > 0);
            assert (vendorDisp.length() > 0);
            vendor = IdDisplay.create((String)vendorId, (String)vendorDisp);
            descBuilder = PkgDesc.Builder.newAddonSysImg((AndroidVersion)version, (IdDisplay)vendor, (IdDisplay)tag, (String)abi, (Revision)this.getRevision());
        }
        descBuilder.setDescriptionShort(LocalSysImgPkgInfo.createShortDescription((String)this.getListDisplay(), (String)abi, (IdDisplay)vendor, (IdDisplay)tag, (AndroidVersion)version, (Revision)this.getRevision(), (boolean)this.isObsolete()));
        descBuilder.setDescriptionUrl(this.getDescUrl());
        descBuilder.setListDisplay(LocalSysImgPkgInfo.createListDescription((String)this.mListDisplay, (IdDisplay)tag, (String)LocalSysImgPkgInfo.getAbiDisplayNameInternal((String)abi), (boolean)this.isObsolete()));
        descBuilder.setIsObsolete(this.isObsolete());
        descBuilder.setLicense(this.getLicense());
        this.mPkgDesc = descBuilder.create();
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        AndroidVersionHelper.saveProperties((AndroidVersion)this.getAndroidVersion(), (Properties)props);
        props.setProperty("SystemImage.Abi", this.getAbi());
        props.setProperty("SystemImage.TagId", this.getTag().getId());
        props.setProperty("SystemImage.TagDisplay", this.getTag().getDisplay());
        IdDisplay addonVendor = this.getAddonVendor();
        if (addonVendor != null) {
            props.setProperty("Addon.VendorId", addonVendor.getId());
            props.setProperty("Addon.VendorDisplay", addonVendor.getDisplay());
        }
    }

    public IdDisplay getTag() {
        return this.getPkgDesc().getTag();
    }

    public String getAbi() {
        return this.getPkgDesc().getPath();
    }

    @NotNull
    public AndroidVersion getAndroidVersion() {
        AndroidVersion androidVersion = this.getPkgDesc().getAndroidVersion();
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/remote/internal/packages/RemoteSystemImagePkgInfo", "getAndroidVersion"));
        }
        return androidVersion;
    }

    public boolean isPlatform() {
        return this.getAddonVendor() == null;
    }

    public IdDisplay getAddonVendor() {
        return this.getPkgDesc().getVendor();
    }

    @Override
    public String installId() {
        StringBuilder sb = new StringBuilder("sys-img-");
        sb.append(this.getAbi()).append('-');
        if (!this.isPlatform()) {
            sb.append("addon-");
        }
        sb.append(SystemImage.DEFAULT_TAG.equals((Object)this.getTag()) ? "android" : this.getTag().getId());
        sb.append('-');
        if (!this.isPlatform()) {
            sb.append(this.getAddonVendor().getId()).append('-');
        }
        sb.append(this.getAndroidVersion().getApiString());
        String s = sb.toString();
        s = s.toLowerCase(Locale.US).replaceAll("[^a-z0-9_.-]+", "_").replaceAll("_+", "_");
        return s;
    }
}

