/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ObservableProperty;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.EmptyRunnable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public final class ServiceContext {
    private final Map<String, ObservableValue> myValues;
    private final Map<String, Runnable> myActions;
    private final Map<ObservableProperty, Object> myWatched;
    private final BoolValueProperty myInstalled;
    private final BoolValueProperty myModified;
    private final InvalidationListener myWatchedListener;
    @NotNull
    private final String myBuildSystemId;
    private Runnable myBeforeShown;
    private Callable<Boolean> myTestValidity;

    public ServiceContext(@NotNull String buildSystemId) {
        if (buildSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildSystemId", "com/android/tools/idea/structure/services/ServiceContext", "<init>"));
        }
        this.myValues = Maps.newHashMap();
        this.myActions = Maps.newHashMap();
        this.myWatched = new WeakHashMap<ObservableProperty, Object>();
        this.myInstalled = new BoolValueProperty();
        this.myModified = new BoolValueProperty();
        this.myWatchedListener = new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                if (sender == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/structure/services/ServiceContext$1", "onInvalidated"));
                }
                ServiceContext.this.myModified.set(true);
            }
        };
        this.myBeforeShown = EmptyRunnable.INSTANCE;
        this.myTestValidity = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return true;
            }
        };
        this.myBuildSystemId = buildSystemId;
    }

    @NotNull
    String getBuildSystemId() {
        String string = this.myBuildSystemId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServiceContext", "getBuildSystemId"));
        }
        return string;
    }

    public void setBeforeShownCallback(@NotNull Runnable beforeShown) {
        if (beforeShown == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeShown", "com/android/tools/idea/structure/services/ServiceContext", "setBeforeShownCallback"));
        }
        this.myBeforeShown = beforeShown;
    }

    public void setIsValidCallback(@NotNull Callable<Boolean> testValidity) {
        if (testValidity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testValidity", "com/android/tools/idea/structure/services/ServiceContext", "setIsValidCallback"));
        }
        this.myTestValidity = testValidity;
    }

    public void beginEditing() {
        this.myBeforeShown.run();
        if (this.myWatched.isEmpty()) {
            this.myModified.set(this.isValid());
        }
    }

    public void finishEditing() {
        if (!this.myModified.get().booleanValue()) {
            return;
        }
        this.myModified.set(this.isValid());
    }

    public void cancelEditing() {
        this.myModified.set(false);
    }

    public BoolValueProperty installed() {
        return this.myInstalled;
    }

    public ObservableBool modified() {
        return this.myModified;
    }

    public void snapshot() {
        for (ObservableProperty property : this.myWatched.keySet()) {
            this.myWatched.put(property, property.get());
        }
        this.myModified.set(false);
    }

    public void restore() {
        for (ObservableProperty property : this.myWatched.keySet()) {
            property.set(this.myWatched.get(property));
        }
        this.myModified.set(false);
    }

    public void putValue(@NotNull String key, @NotNull ObservableValue value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/structure/services/ServiceContext", "putValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/structure/services/ServiceContext", "putValue"));
        }
        this.myValues.put(key, value);
    }

    public void putWatchedValue(@NotNull String key, @NotNull ObservableProperty property) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/structure/services/ServiceContext", "putWatchedValue"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/structure/services/ServiceContext", "putWatchedValue"));
        }
        this.putValue(key, property);
        property.addWeakListener(this.myWatchedListener);
        this.myWatched.put(property, property.get());
    }

    public void putAction(@NotNull String key, @NotNull Runnable action) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/structure/services/ServiceContext", "putAction"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/structure/services/ServiceContext", "putAction"));
        }
        this.myActions.put(key, action);
    }

    @NotNull
    public ObservableValue getValue(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/structure/services/ServiceContext", "getValue"));
        }
        ObservableValue value = this.myValues.get(key);
        if (value == null) {
            throw new IllegalArgumentException(String.format("Service context: Value \"%1$s\" not found.", key));
        }
        ObservableValue observableValue = value;
        if (observableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServiceContext", "getValue"));
        }
        return observableValue;
    }

    @NotNull
    public Runnable getAction(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/structure/services/ServiceContext", "getAction"));
        }
        Runnable action = this.myActions.get(key);
        if (action == null) {
            throw new IllegalArgumentException(String.format("Service context: Action \"%1$s\" not found.", key));
        }
        Runnable runnable = action;
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServiceContext", "getAction"));
        }
        return runnable;
    }

    @NotNull
    public Map<String, Object> toValueMap() {
        HashMap valueMap = Maps.newHashMap();
        Splitter splitter = Splitter.on((char)'.');
        for (String key : this.myValues.keySet()) {
            ObservableValue value = this.getValue(key);
            Map currLevel = valueMap;
            Iterator keyParts = splitter.split((CharSequence)key).iterator();
            while (keyParts.hasNext()) {
                String keyPart = (String)keyParts.next();
                if (keyParts.hasNext()) {
                    if (currLevel.containsKey(keyPart)) {
                        currLevel = (Map)currLevel.get(keyPart);
                        continue;
                    }
                    HashMap nextLevel = Maps.newHashMap();
                    currLevel.put(keyPart, nextLevel);
                    currLevel = nextLevel;
                    continue;
                }
                currLevel.put(keyPart, value);
            }
        }
        HashMap hashMap = valueMap;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/ServiceContext", "toValueMap"));
        }
        return hashMap;
    }

    private boolean isValid() {
        try {
            return this.myTestValidity.call();
        }
        catch (Exception e) {
            return false;
        }
    }
}

