/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.config;

import com.android.prefs.AndroidLocation;
import com.android.tools.idea.npw.WizardUtils;
import com.android.tools.idea.welcome.config.JdkDetection;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallerData {
    public static final InstallerData EMPTY = new InstallerData(null, null, null, true, null, null);
    private static final String PATH_FIRST_RUN_PROPERTIES = FileUtil.join((String[])new String[]{"studio", "installer", "firstrun.data"});
    private static final String PROPERTY_SDK = "androidsdk.dir";
    private static final String PROPERTY_JDK = "jdk.dir";
    private static final String PROPERTY_SDK_REPO = "androidsdk.repo";
    private static final String PROPERTY_TIMESTAMP = "install.timestamp";
    private static final String PROPERTY_AVD = "create.avd";
    private static final String PROPERTY_VERSION = "studio.version";
    private static final Logger LOG = Logger.getInstance(InstallerData.class);
    @Nullable
    private final File myJavaDir;
    @Nullable
    private final File myAndroidSrc;
    @Nullable
    private final File myAndroidDest;
    private final boolean myCreateAvd;
    @Nullable
    private final String myTimestamp;
    @Nullable
    private final String myVersion;

    public InstallerData(@Nullable File javaDir, @Nullable File androidSrc, @Nullable File androidDest, boolean createAvd, @Nullable String timestamp, @Nullable String version) {
        this.myJavaDir = javaDir;
        this.myAndroidSrc = androidSrc;
        this.myAndroidDest = androidDest;
        this.myCreateAvd = createAvd;
        this.myTimestamp = timestamp;
        this.myVersion = version;
    }

    @Nullable
    private static InstallerData parse() {
        Map<String, String> properties = InstallerData.readProperties();
        if (properties == null) {
            return null;
        }
        String androidSdkPath = properties.get(PROPERTY_SDK);
        File androidDest = StringUtil.isEmptyOrSpaces((String)androidSdkPath) ? null : new File(androidSdkPath);
        return new InstallerData(InstallerData.getIfPathExists(properties, PROPERTY_JDK), InstallerData.getIfPathExists(properties, PROPERTY_SDK_REPO), androidDest, Boolean.valueOf(properties.containsKey(PROPERTY_AVD) ? properties.get(PROPERTY_AVD) : "true"), properties.get(PROPERTY_TIMESTAMP), properties.get(PROPERTY_VERSION));
    }

    @Nullable
    private static Map<String, String> readProperties() {
        try {
            File file = new File(AndroidLocation.getFolder(), PATH_FIRST_RUN_PROPERTIES);
            if (file.isFile()) {
                HashMap properties = Maps.newHashMap();
                List lines = Files.readLines((File)file, (Charset)Charsets.UTF_16LE);
                for (String line : lines) {
                    int keyValueSeparator = line.indexOf(61);
                    if (keyValueSeparator < 0) continue;
                    String key = line.substring(0, keyValueSeparator).trim();
                    String value = line.substring(keyValueSeparator + 1).trim();
                    if (key.isEmpty()) continue;
                    properties.put(key, value);
                }
                return properties;
            }
        }
        catch (AndroidLocation.AndroidLocationException e) {
            LOG.error((Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @Nullable
    private static File getIfPathExists(Map<String, String> properties, String propertyName) {
        String path = properties.get(propertyName);
        if (!StringUtil.isEmptyOrSpaces((String)path)) {
            File file = new File(path);
            return file.isDirectory() ? file : null;
        }
        return null;
    }

    public static synchronized void set(@Nullable InstallerData data) {
        Holder.INSTALLER_DATA = data;
    }

    public static boolean exists() {
        return Holder.INSTALLER_DATA != null;
    }

    @NotNull
    public static synchronized InstallerData get() {
        InstallerData data = Holder.INSTALLER_DATA;
        assert (data != null);
        InstallerData installerData = data;
        if (installerData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/config/InstallerData", "get"));
        }
        return installerData;
    }

    @Nullable
    public File getJavaDir() {
        return this.myJavaDir;
    }

    @Nullable
    public File getAndroidSrc() {
        return this.myAndroidSrc;
    }

    @Nullable
    public File getAndroidDest() {
        return this.myAndroidDest;
    }

    public boolean shouldCreateAvd() {
        return this.myCreateAvd;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add(PROPERTY_JDK, (Object)this.myJavaDir).add(PROPERTY_SDK_REPO, (Object)this.myAndroidSrc).add(PROPERTY_SDK, (Object)this.myAndroidDest).add(PROPERTY_AVD, this.myCreateAvd).add(PROPERTY_TIMESTAMP, (Object)this.myTimestamp).toString();
    }

    public boolean hasValidSdkLocation() {
        File location = this.getAndroidDest();
        if (location == null) {
            return false;
        }
        String path = location.getAbsolutePath();
        WizardUtils.ValidationResult validationResult = WizardUtils.validateLocation(path, "SDK location", false);
        return !validationResult.isError();
    }

    public boolean hasValidJdkLocation() {
        File javaDir = this.getJavaDir();
        return javaDir != null && JdkDetection.validateJdkLocation(javaDir) == null;
    }

    @Nullable
    public String getTimestamp() {
        return this.myTimestamp;
    }

    public boolean isCurrentVersion() {
        String buildStr = Integer.toString(ApplicationInfo.getInstance().getBuild().getBuildNumber());
        return buildStr.equals(this.myVersion);
    }

    static /* synthetic */ InstallerData access$100() {
        return InstallerData.parse();
    }

    private static class Holder {
        @Nullable
        private static InstallerData INSTALLER_DATA = InstallerData.access$100();

        private Holder() {
        }
    }
}

