/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.io.FileOp;
import com.android.sdklib.repositoryv2.AndroidSdkHandler;
import com.android.tools.idea.sdkv2.StudioLoggerProgressIndicator;
import com.android.tools.idea.welcome.SdkLocationUtils;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.wizard.WelcomeUIUtils;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InstallableComponent
extends ComponentTreeNode {
    protected final ScopedStateStore.Key<Boolean> myKey;
    protected final ScopedStateStore myStateStore;
    @NotNull
    private final String myName;
    private final long mySize;
    private Boolean myUserSelection;
    private boolean myIsOptional;
    private boolean myIsInstalled;
    protected final FileOp myFileOp;

    /*
     * WARNING - void declaration
     */
    public InstallableComponent(@NotNull ScopedStateStore stateStore, @NotNull String name, long size, @NotNull String description, @NotNull FileOp fileOp) {
        void fop;
        if (stateStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateStore", "com/android/tools/idea/welcome/install/InstallableComponent", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/welcome/install/InstallableComponent", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/welcome/install/InstallableComponent", "<init>"));
        }
        if (fileOp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fop", "com/android/tools/idea/welcome/install/InstallableComponent", "<init>"));
        }
        super(description);
        this.myIsOptional = true;
        this.myIsInstalled = false;
        this.myStateStore = stateStore;
        this.myName = name;
        this.mySize = size;
        this.myKey = stateStore.createKey("component.enabled." + System.identityHashCode(this), Boolean.class);
        this.myFileOp = fop;
    }

    @Override
    public String getLabel() {
        String sizeLabel = this.isInstalled() ? "installed" : WelcomeUIUtils.getSizeLabel(this.mySize);
        return String.format("%s \u2013 (%s)", this.myName, sizeLabel);
    }

    private boolean isInstalled() {
        return this.myIsInstalled;
    }

    @NotNull
    public abstract Collection<String> getRequiredSdkPackages(@Nullable Map<String, RemotePackage> var1);

    public abstract void configure(@NotNull InstallContext var1, @NotNull AndroidSdkHandler var2);

    protected boolean isSelectedByDefault(@Nullable AndroidSdkHandler sdkHandler) {
        return true;
    }

    @Override
    public boolean isOptional() {
        return this.myIsOptional;
    }

    protected boolean isOptionalForSdkLocation(@Nullable AndroidSdkHandler sdkHandler) {
        return true;
    }

    @Override
    public Collection<InstallableComponent> getChildrenToInstall() {
        if (!this.myStateStore.getNotNull(this.myKey, true).booleanValue()) {
            return Collections.emptySet();
        }
        return Collections.singleton(this);
    }

    @Override
    @NotNull
    public Collection<DynamicWizardStep> createSteps() {
        Set<DynamicWizardStep> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/InstallableComponent", "createSteps"));
        }
        return set;
    }

    @Override
    public void updateState(@NotNull AndroidSdkHandler sdkHandler) {
        if (sdkHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHandler", "com/android/tools/idea/welcome/install/InstallableComponent", "updateState"));
        }
        boolean nothingToInstall = !SdkLocationUtils.isWritable(this.myFileOp, sdkHandler.getLocation()) || this.getRequiredSdkPackages(null).isEmpty();
        boolean bl = this.myIsOptional = !nothingToInstall && this.isOptionalForSdkLocation(sdkHandler);
        boolean isSelected = !this.myIsOptional ? !nothingToInstall : (this.myUserSelection != null ? this.myUserSelection.booleanValue() : this.isSelectedByDefault(sdkHandler));
        this.myStateStore.put(this.myKey, isSelected);
        this.myIsInstalled = this.checkInstalledPackages(sdkHandler);
    }

    private boolean checkInstalledPackages(@Nullable AndroidSdkHandler sdkHandler) {
        if (sdkHandler != null) {
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(InstallableComponent.class);
            RepositoryPackages packages = sdkHandler.getSdkManager((ProgressIndicator)progress).getPackages();
            Map localPackages = packages.getLocalPackages();
            Collection<String> requiredSdkPackages = this.getRequiredSdkPackages(null);
            return localPackages.keySet().containsAll(requiredSdkPackages);
        }
        return false;
    }

    @Override
    public void toggle(boolean isSelected) {
        if (this.myIsOptional) {
            this.myUserSelection = isSelected;
            this.myStateStore.put(this.myKey, isSelected);
        }
    }

    @Override
    public Collection<ComponentTreeNode> getImmediateChildren() {
        return Collections.emptySet();
    }

    @Override
    public boolean isChecked() {
        return this.myStateStore.getNotNull(this.myKey, true);
    }

    public long getInstalledSize() {
        return this.myIsInstalled ? 0L : this.mySize;
    }

    @Override
    public boolean componentStateChanged(@NotNull Set<ScopedStateStore.Key> modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "com/android/tools/idea/welcome/install/InstallableComponent", "componentStateChanged"));
        }
        return modified.contains(this.myKey);
    }
}

