/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.template.TemplateWizard;
import com.google.common.base.Function;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class TemplateWizardState
implements Function<String, Object> {
    public static final String ACTIVITY_NAME_SUFFIX = "Activity";
    public static final String LAYOUT_NAME_PREFIX = "activity_";
    private static final Logger logger = Logger.getInstance(TemplateWizardState.class);
    public Template myTemplate;
    protected SourceProvider mySourceProvider;
    public final Map<String, Object> myParameters = new HashMap<String, Object>();
    public final Set<String> myHidden = new HashSet<String>();
    public final Set<String> myFinal = new HashSet<String>();
    public final Set<String> myModified = new HashSet<String>();

    public TemplateWizardState() {
        this.put("isNewProject", false);
        this.put("isGradle", true);
        this.put("isLibraryProject", false);
        this.put("srcDir", "src/main/java");
        this.put("resDir", "src/main/res");
        this.put("aidlDir", "src/main/aidl");
        this.put("manifestDir", "src/main");
        this.put("testDir", "src/androidTest");
    }

    public void populateDirectoryParameters() {
        File projectRoot = new File(this.getString("projectLocation"));
        File moduleRoot = new File(projectRoot, this.getString("projectName"));
        File mainFlavorSourceRoot = new File(moduleRoot, TemplateWizard.MAIN_FLAVOR_SOURCE_PATH);
        File testSourceRoot = new File(moduleRoot, TemplateWizard.TEST_SOURCE_PATH);
        if (!this.myParameters.containsKey("resOut") || this.myParameters.get("resOut") == null) {
            File resourceSourceRoot = new File(mainFlavorSourceRoot, "res");
            this.put("resOut", FileUtil.toSystemIndependentName((String)resourceSourceRoot.getPath()));
        }
        if (!this.myParameters.containsKey("aidlOut") || this.get("aidlOut") == null) {
            File aidlRoot = new File(mainFlavorSourceRoot, "aidl");
            this.put("aidlOut", FileUtil.toSystemIndependentName((String)aidlRoot.getPath()));
        }
        String javaPackageDir = this.getString("packageName").replace('.', File.separatorChar);
        if (!this.myParameters.containsKey("srcOut") || this.myParameters.get("srcOut") == null) {
            File javaSourcePackageRoot;
            File javaSourceRoot = new File(mainFlavorSourceRoot, "java");
            if (this.myParameters.containsKey("packageRoot")) {
                javaSourcePackageRoot = new File(this.getString("packageRoot"));
                String relativePath = FileUtil.getRelativePath((File)javaSourceRoot, (File)javaSourcePackageRoot);
                String javaPackage = relativePath != null ? FileUtil.toSystemIndependentName((String)relativePath).replace('/', '.') : null;
                this.put("packageName", javaPackage);
            } else {
                javaSourcePackageRoot = new File(javaSourceRoot, javaPackageDir);
            }
            this.put("srcOut", FileUtil.toSystemIndependentName((String)javaSourcePackageRoot.getPath()));
        }
        if (!this.myParameters.containsKey("manifestOut") || this.myParameters.get("manifestOut") == null) {
            this.put("manifestOut", FileUtil.toSystemIndependentName((String)mainFlavorSourceRoot.getPath()));
        }
        if (!this.myParameters.containsKey("testOut") || this.myParameters.get("testOut") == null) {
            String relativeTestOut = FileUtil.join((String[])new String[]{"java", javaPackageDir});
            File testOut = new File(testSourceRoot, relativeTestOut);
            this.put("testOut", FileUtil.toSystemIndependentName((String)testOut.getPath()));
        }
        this.put("topOut", FileUtil.toSystemIndependentName((String)projectRoot.getPath()));
        this.put("projectOut", FileUtil.toSystemIndependentName((String)moduleRoot.getPath()));
        String mavenUrl = System.getProperty("android.mavenRepoUrl");
        if (mavenUrl != null) {
            this.put("mavenUrl", mavenUrl);
        }
        this.populateRelativePackage(null);
    }

    public void populateRelativePackage(@Nullable Module module) {
        String pkg = (String)this.myParameters.get("packageName");
        if (pkg != null) {
            if (module != null) {
                String applicationId = ManifestInfo.get(module, false).getPackage();
                if (applicationId != null && pkg.startsWith(applicationId) && pkg.length() > applicationId.length() && pkg.charAt(applicationId.length()) == '.') {
                    pkg = pkg.substring(applicationId.length());
                }
            } else {
                pkg = "";
            }
            this.put("relativePackage", pkg);
        }
    }

    public boolean hasTemplate() {
        return this.myTemplate != null && this.myTemplate.getMetadata() != null;
    }

    @Nullable
    public Template getTemplate() {
        return this.myTemplate;
    }

    @Nullable
    public SourceProvider getSourceProvider() {
        return this.mySourceProvider;
    }

    public void setSourceProvider(@Nullable SourceProvider provider) {
        this.mySourceProvider = provider;
    }

    @Nullable
    public TemplateMetadata getTemplateMetadata() {
        if (this.myTemplate == null) {
            return null;
        }
        return this.myTemplate.getMetadata();
    }

    public Map<String, Object> getParameters() {
        return this.myParameters;
    }

    @Nullable
    public Object get(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/template/TemplateWizardState", "get"));
        }
        return this.myParameters.get(key);
    }

    public boolean getBoolean(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/template/TemplateWizardState", "getBoolean"));
        }
        return this.get(key, Boolean.class);
    }

    public int getInt(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/template/TemplateWizardState", "getInt"));
        }
        return this.get(key, Integer.class);
    }

    @NotNull
    public String getString(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/template/TemplateWizardState", "getString"));
        }
        String string = this.get(key, String.class);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/template/TemplateWizardState", "getString"));
        }
        return string;
    }

    @NotNull
    private <T> T get(@NotNull String key, @NotNull Class<T> valueType) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/template/TemplateWizardState", "get"));
        }
        if (valueType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueType", "com/android/tools/idea/wizard/template/TemplateWizardState", "get"));
        }
        Object val = this.get(key);
        assert (valueType.isInstance(val));
        T t = valueType.cast(val);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/template/TemplateWizardState", "get"));
        }
        return t;
    }

    public boolean hasAttr(String key) {
        return this.myParameters.containsKey(key);
    }

    public void put(@NotNull String key, @Nullable Object value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/wizard/template/TemplateWizardState", "put"));
        }
        this.myParameters.put(key, value);
    }

    public void setTemplateLocation(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/wizard/template/TemplateWizardState", "setTemplateLocation"));
        }
        if (this.myTemplate == null || !this.myTemplate.getRootPath().getAbsolutePath().equals(file.getAbsolutePath())) {
            if (this.myTemplate != null && this.myTemplate.getMetadata() != null) {
                for (Parameter param : this.myTemplate.getMetadata().getParameters()) {
                    if (this.myFinal.contains(param.id)) continue;
                    this.myParameters.remove(param.id);
                }
            }
            this.myTemplate = Template.createFromPath(file);
            this.setParameterDefaults();
        }
    }

    public void setParameterDefaults() {
        TemplateMetadata metadata = this.myTemplate.getMetadata();
        if (metadata == null) {
            logger.warn("Null metadata");
            return;
        }
        for (Parameter param : metadata.getParameters()) {
            if (this.myFinal.contains(param.id) || this.myParameters.containsKey(param.id) || param.initial == null) continue;
            assert (param.id != null);
            switch (param.type) {
                case BOOLEAN: {
                    this.put(param.id, Boolean.valueOf(param.initial));
                    break;
                }
                case ENUM: 
                case STRING: {
                    this.put(param.id, param.initial);
                    break;
                }
            }
        }
    }

    public Object apply(String input) {
        return this.get(input);
    }
}

