/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.relative;

import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.relative.ConstraintType;
import com.intellij.designer.model.RadComponent;
import com.intellij.psi.xml.XmlAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeletionHandler {
    private final List<RadComponent> myChildren;
    private final List<RadViewComponent> myDeleted;
    private final Set<String> myDeletedIds;
    private final Map<String, RadViewComponent> myNodeMap;

    public DeletionHandler(@NotNull List<RadViewComponent> deleted, @NotNull List<RadViewComponent> moved, @NotNull RadViewComponent layout) {
        String id;
        if (deleted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deleted", "com/intellij/android/designer/model/layout/relative/DeletionHandler", "<init>"));
        }
        if (moved == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moved", "com/intellij/android/designer/model/layout/relative/DeletionHandler", "<init>"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/android/designer/model/layout/relative/DeletionHandler", "<init>"));
        }
        this.myDeleted = deleted;
        this.myChildren = layout.getChildren();
        this.myNodeMap = Maps.newHashMapWithExpectedSize((int)this.myChildren.size());
        for (RadViewComponent view : RadViewComponent.getViewComponents(this.myChildren)) {
            id = view.getId();
            if (id == null) continue;
            this.myNodeMap.put(LintUtils.stripIdPrefix((String)id), view);
        }
        this.myDeletedIds = Sets.newHashSetWithExpectedSize((int)this.myDeleted.size());
        for (RadViewComponent node : this.myDeleted) {
            id = node.getId();
            if (id == null) continue;
            this.myDeletedIds.add(LintUtils.stripIdPrefix((String)id));
        }
        for (RadViewComponent node : moved) {
            id = node.getId();
            if (id == null) continue;
            this.myDeletedIds.remove(LintUtils.stripIdPrefix((String)id));
        }
    }

    @Nullable
    private static String getId(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/android/designer/model/layout/relative/DeletionHandler", "getId"));
        }
        if (attribute.getLocalName().startsWith("layout_") && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespace()) && !attribute.getLocalName().startsWith("layout_margin")) {
            String id = attribute.getValue();
            if (id == null) {
                return null;
            }
            if (id.startsWith("@+id/")) {
                return id.substring("@+id/".length());
            }
            if (id.startsWith("@id/")) {
                return id.substring("@id/".length());
            }
        }
        return null;
    }

    public void updateConstraints() {
        if (this.myChildren.size() == this.myDeleted.size()) {
            return;
        }
        for (RadViewComponent child : RadViewComponent.getViewComponents(this.myChildren)) {
            if (this.myDeleted.contains((Object)child)) continue;
            for (XmlAttribute attribute : child.getTag().getAttributes()) {
                ConstraintType type;
                String id = DeletionHandler.getId(attribute);
                if (id == null || !this.myDeletedIds.contains(id)) continue;
                String name = attribute.getLocalName();
                attribute.delete();
                RadViewComponent deleted = this.myNodeMap.get(id);
                if (deleted == null || (type = ConstraintType.fromAttribute(name)) == null) continue;
                this.transfer(deleted, child, type, 0);
            }
        }
    }

    private void transfer(RadViewComponent deleted, RadViewComponent target, ConstraintType targetType, int depth) {
        if (depth == 20) {
            return;
        }
        if (!this.myDeleted.contains((Object)deleted)) {
            return;
        }
        for (XmlAttribute attribute : deleted.getTag().getAttributes()) {
            ConstraintType transfer;
            String name = attribute.getLocalName();
            ConstraintType type = ConstraintType.fromAttribute(name);
            if (type == null || (transfer = DeletionHandler.getCompatibleConstraint(type, targetType)) == null) continue;
            String id = DeletionHandler.getId(attribute);
            if (id != null) {
                if (this.myDeletedIds.contains(id)) {
                    RadViewComponent nextDeleted = this.myNodeMap.get(id);
                    if (nextDeleted == null) continue;
                    this.transfer(nextDeleted, target, targetType, depth + 1);
                    continue;
                }
                target.getTag().setAttribute(transfer.name, "http://schemas.android.com/apk/res/android", attribute.getValue());
                continue;
            }
            target.getTag().setAttribute(name, "http://schemas.android.com/apk/res/android", attribute.getValue());
        }
    }

    @Nullable
    private static ConstraintType getCompatibleConstraint(@NotNull ConstraintType first, @NotNull ConstraintType second) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/android/designer/model/layout/relative/DeletionHandler", "getCompatibleConstraint"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/intellij/android/designer/model/layout/relative/DeletionHandler", "getCompatibleConstraint"));
        }
        if (first == second) {
            return first;
        }
        switch (second) {
            case ALIGN_LEFT: 
            case LAYOUT_RIGHT_OF: {
                switch (first) {
                    case LAYOUT_CENTER_HORIZONTAL: 
                    case LAYOUT_LEFT_OF: 
                    case ALIGN_LEFT: {
                        return first;
                    }
                    case LAYOUT_CENTER_IN_PARENT: {
                        return ConstraintType.LAYOUT_CENTER_HORIZONTAL;
                    }
                }
                return null;
            }
            case LAYOUT_LEFT_OF: 
            case ALIGN_RIGHT: {
                switch (first) {
                    case LAYOUT_CENTER_HORIZONTAL: 
                    case LAYOUT_LEFT_OF: 
                    case ALIGN_RIGHT: {
                        return first;
                    }
                    case LAYOUT_CENTER_IN_PARENT: {
                        return ConstraintType.LAYOUT_CENTER_HORIZONTAL;
                    }
                }
                return null;
            }
            case ALIGN_TOP: 
            case LAYOUT_BELOW: 
            case ALIGN_BASELINE: {
                switch (first) {
                    case LAYOUT_CENTER_VERTICAL: 
                    case ALIGN_TOP: 
                    case LAYOUT_BELOW: 
                    case ALIGN_BASELINE: {
                        return first;
                    }
                    case LAYOUT_CENTER_IN_PARENT: {
                        return ConstraintType.LAYOUT_CENTER_VERTICAL;
                    }
                }
                return null;
            }
            case ALIGN_BOTTOM: 
            case LAYOUT_ABOVE: {
                switch (first) {
                    case LAYOUT_CENTER_VERTICAL: 
                    case ALIGN_BASELINE: 
                    case ALIGN_BOTTOM: 
                    case LAYOUT_ABOVE: {
                        return first;
                    }
                    case LAYOUT_CENTER_IN_PARENT: {
                        return ConstraintType.LAYOUT_CENTER_VERTICAL;
                    }
                }
                return null;
            }
        }
        return null;
    }
}

