/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.ide.common.resources.ResourceUrl;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.project.AndroidProjectBuildNotifications;
import com.android.tools.idea.rendering.LayoutPullParserFactory;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.multi.RenderPreviewManager;
import com.android.tools.idea.rendering.multi.RenderPreviewMode;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.Alarm;
import com.intellij.util.containers.HashMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import icons.AndroidIcons;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.android.uipreview.AndroidLayoutPreviewToolWindowForm;
import org.jetbrains.android.uipreview.AndroidPreviewProgressIndicator;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLayoutPreviewToolWindowManager
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.uipreview.AndroidLayoutPreviewToolWindowManager");
    private final MergingUpdateQueue myToolWindowUpdateQueue;
    private final Object myRenderingQueueLock = new Object();
    private MergingUpdateQueue myRenderingQueue;
    private final Project myProject;
    private final FileEditorManager myFileEditorManager;
    private AndroidLayoutPreviewToolWindowForm myToolWindowForm;
    private ToolWindow myToolWindow;
    private boolean myToolWindowReady = false;
    private boolean myToolWindowDisposed = false;
    private AndroidPreviewProgressIndicator myCurrentIndicator;
    private static final Object RENDERING_LOCK = new Object();
    private static final Object PROGRESS_LOCK = new Object();
    private boolean mySeenEditor;
    private JComponent myPendingShowComponent;
    private HierarchyListener myHierarchyListener;
    private boolean myRenderImmediately;

    public AndroidLayoutPreviewToolWindowManager(Project project, FileEditorManager fileEditorManager) {
        this.myProject = project;
        this.myFileEditorManager = fileEditorManager;
        if (RenderService.NELE_ENABLED) {
            this.myToolWindowUpdateQueue = null;
            return;
        }
        this.myToolWindowUpdateQueue = new MergingUpdateQueue("android.layout.preview", 100, true, null, (Disposable)project);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyFileEditorManagerListener());
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyAndroidPlatformListener(project));
        this.initListeners(project);
    }

    protected void initListeners(Project project) {
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){
            boolean myIgnoreChildrenChanged;

            public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/android/uipreview/AndroidLayoutPreviewToolWindowManager$1", "beforeChildrenChange"));
                }
                this.myIgnoreChildrenChanged = false;
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/android/uipreview/AndroidLayoutPreviewToolWindowManager$1", "childrenChanged"));
                }
                if (AndroidLayoutPreviewToolWindowManager.this.isRelevant(event) && !this.myIgnoreChildrenChanged && event.getParent() != event.getChild()) {
                    AndroidLayoutPreviewToolWindowManager.this.update(event);
                }
            }

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/android/uipreview/AndroidLayoutPreviewToolWindowManager$1", "childAdded"));
                }
                this.myIgnoreChildrenChanged = true;
                if (AndroidLayoutPreviewToolWindowManager.this.isRelevant(event)) {
                    String text;
                    PsiElement child = event.getChild();
                    PsiElement parent = event.getParent();
                    if (child instanceof XmlAttribute && parent instanceof XmlTag) {
                        if (((XmlAttribute)child).getValueElement() == null) {
                            return;
                        }
                    } else if (parent instanceof XmlAttribute && child instanceof XmlAttributeValue) {
                        XmlAttributeValue attributeValue = (XmlAttributeValue)child;
                        if (attributeValue.getValue() == null || attributeValue.getValue().isEmpty()) {
                            return;
                        }
                    } else if (parent instanceof XmlAttributeValue && child instanceof XmlToken && event.getOldChild() == null && (text = child.getText()).startsWith("@") && !text.startsWith("@{")) {
                        if (text.equals("@") || text.equals("@android:")) {
                            return;
                        }
                        ResourceUrl url = ResourceUrl.parse((String)text);
                        if (url != null && url.name.isEmpty()) {
                            return;
                        }
                    }
                    AndroidLayoutPreviewToolWindowManager.this.update(event);
                }
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/android/uipreview/AndroidLayoutPreviewToolWindowManager$1", "childReplaced"));
                }
                this.myIgnoreChildrenChanged = true;
                if (AndroidLayoutPreviewToolWindowManager.this.isRelevant(event)) {
                    PsiElement child = event.getChild();
                    PsiElement parent = event.getParent();
                    if (parent instanceof XmlAttribute && child instanceof XmlToken) {
                        XmlAttributeValue valueElement = ((XmlAttribute)parent).getValueElement();
                        if (valueElement == null || valueElement.getValue() == null || valueElement.getValue().isEmpty()) {
                            return;
                        }
                    } else if (parent instanceof XmlAttributeValue && child instanceof XmlToken && event.getOldChild() != null) {
                        String newText = child.getText();
                        String prevText = event.getOldChild().getText();
                        if (newText.startsWith("@") && !newText.startsWith("@{")) {
                            ResourceUrl prevUrl = ResourceUrl.parse((String)prevText);
                            ResourceUrl newUrl = ResourceUrl.parse((String)newText);
                            if (prevUrl != null && prevUrl.name.isEmpty()) {
                                prevUrl = null;
                            }
                            if (newUrl != null && newUrl.name.isEmpty()) {
                                newUrl = null;
                            }
                            if (prevUrl == null && newUrl == null) {
                                return;
                            }
                        }
                    }
                    AndroidLayoutPreviewToolWindowManager.this.update(event);
                }
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/android/uipreview/AndroidLayoutPreviewToolWindowManager$1", "childRemoved"));
                }
                this.myIgnoreChildrenChanged = true;
                if (AndroidLayoutPreviewToolWindowManager.this.isRelevant(event)) {
                    XmlAttributeValue valueElement;
                    PsiElement child = event.getChild();
                    PsiElement parent = event.getParent();
                    if (parent instanceof XmlAttribute && child instanceof XmlToken && ((valueElement = ((XmlAttribute)parent).getValueElement()) == null || valueElement.getValue() == null || valueElement.getValue().isEmpty())) {
                        return;
                    }
                    AndroidLayoutPreviewToolWindowManager.this.update(event);
                }
            }
        }, (Disposable)project);
        AndroidProjectBuildNotifications.subscribe(project, new AndroidProjectBuildNotifications.AndroidProjectBuildListener(){

            @Override
            public void buildComplete(@NotNull AndroidProjectBuildNotifications.BuildContext context) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/uipreview/AndroidLayoutPreviewToolWindowManager$2", "buildComplete"));
                }
                if (AndroidLayoutPreviewToolWindowManager.this.myToolWindowForm != null && AndroidLayoutPreviewToolWindowManager.this.myToolWindowReady && !AndroidLayoutPreviewToolWindowManager.this.myToolWindowDisposed) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AndroidLayoutPreviewToolWindowManager.this.render();
                        }
                    });
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private MergingUpdateQueue getRenderingQueue() {
        Object object = this.myRenderingQueueLock;
        // MONITORENTER : object
        if (this.myRenderingQueue == null) {
            this.myRenderingQueue = new MergingUpdateQueue("android.layout.rendering", 800, true, null, (Disposable)this.myProject, null, Alarm.ThreadToUse.OWN_THREAD);
        }
        MergingUpdateQueue mergingUpdateQueue = this.myRenderingQueue;
        // MONITOREXIT : object
        if (mergingUpdateQueue != null) return mergingUpdateQueue;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/AndroidLayoutPreviewToolWindowManager", "getRenderingQueue"));
    }

    public boolean isRenderPending() {
        MergingUpdateQueue queue = this.getRenderingQueue();
        return !queue.isEmpty() && !queue.isFlushing() && !this.myToolWindowUpdateQueue.isEmpty() && !this.myToolWindowUpdateQueue.isFlushing();
    }

    private boolean isRelevant(PsiTreeChangeEvent event) {
        if (this.myToolWindowForm == null || !this.myToolWindowReady || this.myToolWindowDisposed) {
            return false;
        }
        PsiFile fileInPreview = this.myToolWindowForm.getFile();
        PsiFile file = event.getFile();
        if (fileInPreview == null || file == null || fileInPreview != file) {
            return false;
        }
        PsiElement child = event.getChild();
        PsiElement parent = event.getParent();
        return !(child instanceof PsiWhiteSpace) && !(child instanceof PsiErrorElement) && !(child instanceof XmlComment) && !(parent instanceof XmlComment);
    }

    protected void update(PsiTreeChangeEvent event) {
        if (this.isRelevant(event)) {
            this.getRenderingQueue().cancelAllUpdates();
            this.render();
        }
    }

    public void projectOpened() {
        if (RenderService.NELE_ENABLED) {
            return;
        }
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(new Runnable(){

            @Override
            public void run() {
                AndroidLayoutPreviewToolWindowManager.this.myToolWindowReady = true;
                AndroidLayoutPreviewToolWindowManager.this.processFileEditorChange(AndroidLayoutPreviewToolWindowManager.this.getActiveLayoutXmlEditor());
            }
        });
    }

    protected boolean isUseInteractiveSelector() {
        return true;
    }

    protected String getToolWindowId() {
        return AndroidBundle.message("android.layout.preview.tool.window.title", new Object[0]);
    }

    protected boolean isRenderAutomatically() {
        return true;
    }

    protected boolean isForceHideOnStart() {
        return false;
    }

    protected ToolWindow getToolWindow() {
        return this.myToolWindow;
    }

    @Nullable
    protected AnAction getCustomRefreshRenderAction() {
        return null;
    }

    protected void initToolWindow() {
        this.myToolWindowForm = new AndroidLayoutPreviewToolWindowForm(this, this.getCustomRefreshRenderAction());
        final String toolWindowId = this.getToolWindowId();
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(toolWindowId, false, ToolWindowAnchor.RIGHT, (Disposable)this.myProject, true);
        this.myToolWindow.setIcon(AndroidIcons.AndroidPreview);
        ((ToolWindowManagerEx)ToolWindowManager.getInstance((Project)this.myProject)).addToolWindowManagerListener((ToolWindowManagerListener)new ToolWindowManagerAdapter(){
            private boolean myVisible = false;

            public void stateChanged() {
                if (AndroidLayoutPreviewToolWindowManager.this.myProject.isDisposed()) {
                    return;
                }
                ToolWindow window = ToolWindowManager.getInstance((Project)AndroidLayoutPreviewToolWindowManager.this.myProject).getToolWindow(toolWindowId);
                if (window != null && window.isAvailable()) {
                    boolean visible = window.isVisible();
                    AndroidEditorSettings.getInstance().getGlobalState().setVisible(visible);
                    if (visible && !this.myVisible && AndroidLayoutPreviewToolWindowManager.this.isRenderAutomatically()) {
                        AndroidLayoutPreviewToolWindowManager.this.render();
                    }
                    this.myVisible = visible;
                }
            }
        });
        JPanel contentPanel = this.myToolWindowForm.getContentPanel();
        ContentManager contentManager = this.myToolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent((JComponent)contentPanel, null, false);
        content.setDisposer((Disposable)this.myToolWindowForm);
        content.setCloseable(false);
        content.setPreferredFocusableComponent((JComponent)contentPanel);
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
        this.myToolWindow.setAvailable(false, null);
        this.myToolWindowForm.setUseInteractiveSelector(this.isUseInteractiveSelector());
    }

    public void projectClosed() {
        if (this.myToolWindowForm != null) {
            Disposer.dispose((Disposable)this.myToolWindowForm);
            this.myToolWindowForm = null;
            this.myToolWindow = null;
            this.myToolWindowDisposed = true;
        }
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("AndroidLayoutPreviewToolWindowManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/AndroidLayoutPreviewToolWindowManager", "getComponentName"));
        }
        return "AndroidLayoutPreviewToolWindowManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private void processFileEditorChange(final @Nullable TextEditor newEditor) {
        if (this.myPendingShowComponent != null) {
            this.myPendingShowComponent.removeHierarchyListener(this.myHierarchyListener);
            this.myPendingShowComponent = null;
        }
        this.myToolWindowUpdateQueue.cancelAllUpdates();
        this.myToolWindowUpdateQueue.queue(new Update("update"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean requestedRender;
                boolean toRender;
                Editor activeEditor;
                if (!AndroidLayoutPreviewToolWindowManager.this.myToolWindowReady || AndroidLayoutPreviewToolWindowManager.this.myToolWindowDisposed) {
                    return;
                }
                boolean renderImmediately = AndroidLayoutPreviewToolWindowManager.this.myRenderImmediately;
                AndroidLayoutPreviewToolWindowManager.this.myRenderImmediately = false;
                Editor editor = activeEditor = newEditor != null ? newEditor.getEditor() : null;
                if (AndroidLayoutPreviewToolWindowManager.this.myToolWindow == null) {
                    if (activeEditor == null) {
                        return;
                    }
                    if (!activeEditor.getComponent().isShowing()) {
                        if (!AndroidLayoutPreviewToolWindowManager.this.mySeenEditor) {
                            AndroidLayoutPreviewToolWindowManager.this.myPendingShowComponent = activeEditor.getComponent();
                            if (AndroidLayoutPreviewToolWindowManager.this.myHierarchyListener == null) {
                                AndroidLayoutPreviewToolWindowManager.this.myHierarchyListener = new HierarchyListener(){

                                    @Override
                                    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                                        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && hierarchyEvent.getComponent() == AndroidLayoutPreviewToolWindowManager.this.myPendingShowComponent && AndroidLayoutPreviewToolWindowManager.this.myPendingShowComponent.isShowing()) {
                                            AndroidLayoutPreviewToolWindowManager.this.myPendingShowComponent.removeHierarchyListener(AndroidLayoutPreviewToolWindowManager.this.myHierarchyListener);
                                            AndroidLayoutPreviewToolWindowManager.this.mySeenEditor = true;
                                            AndroidLayoutPreviewToolWindowManager.this.myPendingShowComponent = null;
                                            AndroidLayoutPreviewToolWindowManager.this.processFileEditorChange(AndroidLayoutPreviewToolWindowManager.this.getActiveLayoutXmlEditor());
                                        }
                                    }
                                };
                            }
                            AndroidLayoutPreviewToolWindowManager.this.myPendingShowComponent.addHierarchyListener(AndroidLayoutPreviewToolWindowManager.this.myHierarchyListener);
                        }
                        return;
                    }
                    AndroidLayoutPreviewToolWindowManager.this.mySeenEditor = true;
                    AndroidLayoutPreviewToolWindowManager.this.initToolWindow();
                }
                AndroidEditorSettings settings = AndroidEditorSettings.getInstance();
                boolean hideForNonLayoutFiles = settings.getGlobalState().isHideForNonLayoutFiles();
                if (activeEditor == null) {
                    AndroidLayoutPreviewToolWindowManager.this.myToolWindowForm.setFile(null);
                    AndroidLayoutPreviewToolWindowManager.this.myToolWindow.setAvailable(!hideForNonLayoutFiles, null);
                    return;
                }
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)AndroidLayoutPreviewToolWindowManager.this.myProject).getPsiFile(activeEditor.getDocument());
                if (psiFile == null) {
                    AndroidLayoutPreviewToolWindowManager.this.myToolWindowForm.setFile(null);
                    AndroidLayoutPreviewToolWindowManager.this.myToolWindow.setAvailable(!hideForNonLayoutFiles, null);
                    return;
                }
                boolean bl = toRender = AndroidLayoutPreviewToolWindowManager.this.myToolWindowForm.getFile() != psiFile;
                if (toRender && !AndroidLayoutPreviewToolWindowManager.this.myToolWindowForm.setFile(psiFile)) {
                    return;
                }
                AndroidLayoutPreviewToolWindowManager.this.myToolWindow.setAvailable(true, null);
                boolean visible = AndroidEditorSettings.getInstance().getGlobalState().isVisible();
                if (visible) {
                    RenderResult renderResult;
                    if (!AndroidLayoutPreviewToolWindowManager.this.myToolWindow.isVisible() && (renderResult = AndroidLayoutPreviewToolWindowManager.this.myToolWindowForm.getRenderResult()) != null && renderResult.getFile() != psiFile) {
                        AndroidLayoutPreviewToolWindowManager.this.myToolWindowForm.setRenderResult(RenderResult.createBlank(psiFile, null), null);
                    }
                    AndroidLayoutPreviewToolWindowManager.this.myToolWindow.show(null);
                }
                if (toRender && (requestedRender = AndroidLayoutPreviewToolWindowManager.this.render())) {
                    if (renderImmediately) {
                        AndroidLayoutPreviewToolWindowManager.this.getRenderingQueue().sendFlush();
                    }
                    AndroidLayoutPreviewToolWindowForm toolWindowForm = AndroidLayoutPreviewToolWindowManager.this.myToolWindowForm;
                    Object object = PROGRESS_LOCK;
                    synchronized (object) {
                        if (AndroidLayoutPreviewToolWindowManager.this.myCurrentIndicator == null) {
                            AndroidLayoutPreviewToolWindowManager.this.myCurrentIndicator = new AndroidPreviewProgressIndicator(toolWindowForm, 0);
                            AndroidLayoutPreviewToolWindowManager.this.myCurrentIndicator.start();
                        }
                    }
                }
            }
        });
    }

    public static void renderIfApplicable(final @Nullable Project project) {
        if (project != null) {
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AndroidLayoutPreviewToolWindowManager.renderIfApplicable(project);
                    }
                });
                return;
            }
            AndroidLayoutPreviewToolWindowManager preview = AndroidLayoutPreviewToolWindowManager.getInstance(project);
            if (preview != null) {
                preview.render();
            }
        }
    }

    public boolean render() {
        if (this.myToolWindow == null || !this.myToolWindow.isVisible()) {
            return false;
        }
        PsiFile psiFile = this.myToolWindowForm.getFile();
        if (psiFile == null) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)psiFile);
        if (facet == null) {
            return false;
        }
        return this.render(psiFile, facet, false);
    }

    protected boolean render(final PsiFile psiFile, final AndroidFacet facet, boolean forceFullRender) {
        this.getRenderingQueue().queue(new Update("render"){

            public void run() {
                ProgressManager.getInstance().runProcess(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        DumbService.getInstance((Project)AndroidLayoutPreviewToolWindowManager.this.myProject).waitForSmartMode();
                        try {
                            AndroidLayoutPreviewToolWindowManager.this.doRender(facet, psiFile);
                        }
                        catch (Throwable e) {
                            LOG.error(e);
                        }
                        Object object = PROGRESS_LOCK;
                        synchronized (object) {
                            if (AndroidLayoutPreviewToolWindowManager.this.myCurrentIndicator != null) {
                                AndroidLayoutPreviewToolWindowManager.this.myCurrentIndicator.stop();
                                AndroidLayoutPreviewToolWindowManager.this.myCurrentIndicator = null;
                            }
                        }
                    }
                }, (ProgressIndicator)new AndroidPreviewProgressIndicator(AndroidLayoutPreviewToolWindowManager.this.myToolWindowForm, 100));
            }

            public boolean canEat(Update update) {
                return true;
            }
        });
        return true;
    }

    public void flush() {
        this.getRenderingQueue().sendFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRender(@NotNull AndroidFacet facet, @NotNull PsiFile psiFile) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/uipreview/AndroidLayoutPreviewToolWindowManager", "doRender"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/android/uipreview/AndroidLayoutPreviewToolWindowManager", "doRender"));
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        AndroidLayoutPreviewToolWindowForm toolWindowForm = this.myToolWindowForm;
        if (toolWindowForm == null) {
            return;
        }
        VirtualFile layoutXmlFile = psiFile.getVirtualFile();
        String loggerName = layoutXmlFile != null ? layoutXmlFile.getName() : psiFile.getName();
        Module module = facet.getModule();
        Configuration configuration = toolWindowForm.getConfiguration();
        if (configuration == null) {
            return;
        }
        LayoutPullParserFactory.saveFileIfNecessary(psiFile);
        RenderResult result = null;
        Object object = RENDERING_LOCK;
        synchronized (object) {
            RenderService renderService = RenderService.get(facet);
            RenderLogger logger = renderService.createLogger();
            RenderTask task = renderService.createTask(psiFile, configuration, logger, toolWindowForm);
            if (task != null) {
                task.useDesignMode(psiFile);
                result = task.render();
                task.dispose();
            }
            if (result == null) {
                result = RenderResult.createBlank(psiFile, logger);
            }
        }
        if (!this.getRenderingQueue().isEmpty()) {
            return;
        }
        final RenderResult renderResult = result;
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                RenderPreviewManager previewManager;
                if (!AndroidLayoutPreviewToolWindowManager.this.myToolWindowReady || AndroidLayoutPreviewToolWindowManager.this.myToolWindowDisposed) {
                    return;
                }
                TextEditor editor = AndroidLayoutPreviewToolWindowManager.this.getActiveLayoutXmlEditor();
                AndroidLayoutPreviewToolWindowManager.this.myToolWindowForm.setRenderResult(renderResult, editor);
                AndroidLayoutPreviewToolWindowManager.this.myToolWindowForm.updatePreviewPanel();
                if (RenderPreviewMode.getCurrent() != RenderPreviewMode.NONE && (previewManager = AndroidLayoutPreviewToolWindowManager.this.myToolWindowForm.getPreviewPanel().getPreviewManager(AndroidLayoutPreviewToolWindowManager.this.myToolWindowForm, true)) != null) {
                    previewManager.renderPreviews();
                }
            }
        });
    }

    @Nullable
    private TextEditor getActiveLayoutXmlEditor() {
        Editor selectedEditor = this.myFileEditorManager.getSelectedTextEditor();
        if (selectedEditor != null) {
            for (FileEditor fileEditor : this.myFileEditorManager.getSelectedEditors()) {
                TextEditor textEditor;
                if (!(fileEditor instanceof TextEditor) || !this.isApplicableEditor(textEditor = (TextEditor)fileEditor) || textEditor.getEditor() != selectedEditor) continue;
                return (TextEditor)fileEditor;
            }
        }
        return null;
    }

    protected boolean isApplicableEditor(TextEditor textEditor) {
        Document document = textEditor.getEditor().getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        return AndroidLayoutPreviewToolWindowManager.isInResourceFolder(psiFile);
    }

    private static boolean isInResourceFolder(@Nullable PsiFile psiFile) {
        if (psiFile instanceof XmlFile && AndroidFacet.getInstance((PsiElement)psiFile) != null) {
            return RenderService.canRender(psiFile);
        }
        return false;
    }

    public static AndroidLayoutPreviewToolWindowManager getInstance(Project project) {
        return (AndroidLayoutPreviewToolWindowManager)project.getComponent(AndroidLayoutPreviewToolWindowManager.class);
    }

    public void notifyFileShown(@NotNull TextEditor editor, boolean renderImmediately) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/android/uipreview/AndroidLayoutPreviewToolWindowManager", "notifyFileShown"));
        }
        if (renderImmediately) {
            this.myRenderImmediately = true;
        }
        this.processFileEditorChange(editor);
        if (renderImmediately) {
            this.myToolWindowUpdateQueue.sendFlush();
        }
    }

    public AndroidLayoutPreviewToolWindowForm getToolWindowForm() {
        return this.myToolWindowForm;
    }

    private class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/android/uipreview/AndroidLayoutPreviewToolWindowManager$MyFileEditorManagerListener", "fileOpened"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/uipreview/AndroidLayoutPreviewToolWindowManager$MyFileEditorManagerListener", "fileOpened"));
            }
            AndroidLayoutPreviewToolWindowManager.this.processFileEditorChange(AndroidLayoutPreviewToolWindowManager.this.getActiveLayoutXmlEditor());
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/android/uipreview/AndroidLayoutPreviewToolWindowManager$MyFileEditorManagerListener", "fileClosed"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/uipreview/AndroidLayoutPreviewToolWindowManager$MyFileEditorManagerListener", "fileClosed"));
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    AndroidLayoutPreviewToolWindowManager.this.processFileEditorChange(AndroidLayoutPreviewToolWindowManager.this.getActiveLayoutXmlEditor());
                }
            }, AndroidLayoutPreviewToolWindowManager.this.myProject.getDisposed());
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            TextEditor textEditor;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/android/uipreview/AndroidLayoutPreviewToolWindowManager$MyFileEditorManagerListener", "selectionChanged"));
            }
            FileEditor newEditor = event.getNewEditor();
            TextEditor layoutXmlEditor = null;
            if (newEditor instanceof TextEditor && AndroidLayoutPreviewToolWindowManager.this.isApplicableEditor(textEditor = (TextEditor)newEditor)) {
                layoutXmlEditor = textEditor;
            }
            AndroidLayoutPreviewToolWindowManager.this.processFileEditorChange(layoutXmlEditor);
        }
    }

    private class MyAndroidPlatformListener
    extends ModuleRootAdapter {
        private final Map<Module, Sdk> myModule2Sdk;
        private final Project myProject;

        private MyAndroidPlatformListener(Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/uipreview/AndroidLayoutPreviewToolWindowManager$MyAndroidPlatformListener", "<init>"));
            }
            this.myModule2Sdk = new HashMap();
            this.myProject = project;
            this.updateMap();
        }

        public void rootsChanged(ModuleRootEvent event) {
            Module module;
            if (AndroidLayoutPreviewToolWindowManager.this.myToolWindowForm == null || !AndroidLayoutPreviewToolWindowManager.this.myToolWindowReady || AndroidLayoutPreviewToolWindowManager.this.myToolWindowDisposed) {
                return;
            }
            PsiFile file = AndroidLayoutPreviewToolWindowManager.this.myToolWindowForm.getFile();
            if (file != null && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) != null) {
                Sdk prevSdk = this.myModule2Sdk.get(module);
                Sdk newSdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (newSdk != null && (newSdk.getSdkType() instanceof AndroidSdkType || prevSdk != null && prevSdk.getSdkType() instanceof AndroidSdkType) && !newSdk.equals(prevSdk)) {
                    AndroidLayoutPreviewToolWindowManager.this.render();
                }
            }
            this.updateMap();
        }

        private void updateMap() {
            this.myModule2Sdk.clear();
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                this.myModule2Sdk.put(module, ModuleRootManager.getInstance((Module)module).getSdk());
            }
        }
    }
}

