/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.utils.Path;

public class MavenRunnerParameters
implements Cloneable {
    private boolean isPomExecution;
    private Path myWorkingDirPath;
    private final List<String> myGoals;
    private boolean myResolveToWorkspace;
    private final Map<String, Boolean> myProfilesMap;
    private final Collection<String> myEnabledProfilesForXmlSerializer;

    public MavenRunnerParameters() {
        this(true, "", null, null, null);
    }

    public MavenRunnerParameters(boolean isPomExecution, @NotNull String workingDirPath, @Nullable List<String> goals, @Nullable Collection<String> explicitEnabledProfiles) {
        if (workingDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDirPath", "org/jetbrains/idea/maven/execution/MavenRunnerParameters", "<init>"));
        }
        this(isPomExecution, workingDirPath, goals, explicitEnabledProfiles, null);
    }

    public MavenRunnerParameters(boolean isPomExecution, @NotNull String workingDirPath, @Nullable List<String> goals, @NotNull MavenExplicitProfiles explicitProfiles) {
        if (workingDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDirPath", "org/jetbrains/idea/maven/execution/MavenRunnerParameters", "<init>"));
        }
        if (explicitProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitProfiles", "org/jetbrains/idea/maven/execution/MavenRunnerParameters", "<init>"));
        }
        this(isPomExecution, workingDirPath, goals, explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles());
    }

    public MavenRunnerParameters(boolean isPomExecution, @NotNull String workingDirPath, @Nullable List<String> goals, @Nullable Collection<String> explicitEnabledProfiles, @Nullable Collection<String> explicitDisabledProfiles) {
        if (workingDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDirPath", "org/jetbrains/idea/maven/execution/MavenRunnerParameters", "<init>"));
        }
        this.myGoals = new ArrayList<String>();
        this.myProfilesMap = new LinkedHashMap<String, Boolean>();
        this.myEnabledProfilesForXmlSerializer = new TreeSet<String>();
        this.isPomExecution = isPomExecution;
        this.setWorkingDirPath(workingDirPath);
        this.setGoals(goals);
        if (explicitEnabledProfiles != null) {
            for (String profile : explicitEnabledProfiles) {
                this.myProfilesMap.put(profile, Boolean.TRUE);
            }
        }
        if (explicitDisabledProfiles != null) {
            for (String profile : explicitDisabledProfiles) {
                this.myProfilesMap.put(profile, Boolean.FALSE);
            }
        }
    }

    public MavenRunnerParameters(String workingDirPath, boolean isPomExecution, @Nullable List<String> goals, @NotNull Map<String, Boolean> profilesMap) {
        if (profilesMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profilesMap", "org/jetbrains/idea/maven/execution/MavenRunnerParameters", "<init>"));
        }
        this.myGoals = new ArrayList<String>();
        this.myProfilesMap = new LinkedHashMap<String, Boolean>();
        this.myEnabledProfilesForXmlSerializer = new TreeSet<String>();
        this.isPomExecution = isPomExecution;
        this.setWorkingDirPath(workingDirPath);
        this.setGoals(goals);
        this.setProfilesMap(profilesMap);
    }

    public MavenRunnerParameters(MavenRunnerParameters that) {
        this(that.getWorkingDirPath(), that.isPomExecution, that.myGoals, that.myProfilesMap);
        this.myResolveToWorkspace = that.myResolveToWorkspace;
    }

    public boolean isPomExecution() {
        return this.isPomExecution;
    }

    @NotNull
    public String getWorkingDirPath() {
        String string = this.myWorkingDirPath.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenRunnerParameters", "getWorkingDirPath"));
        }
        return string;
    }

    public void setWorkingDirPath(@NotNull String workingDirPath) {
        if (workingDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDirPath", "org/jetbrains/idea/maven/execution/MavenRunnerParameters", "setWorkingDirPath"));
        }
        this.myWorkingDirPath = new Path(workingDirPath);
    }

    @NotNull
    public File getWorkingDirFile() {
        File file = new File(this.myWorkingDirPath.getPath());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenRunnerParameters", "getWorkingDirFile"));
        }
        return file;
    }

    public List<String> getGoals() {
        return this.myGoals;
    }

    public void setGoals(@Nullable List<String> goals) {
        if (this.myGoals == goals) {
            return;
        }
        this.myGoals.clear();
        if (goals != null) {
            this.myGoals.addAll(goals);
        }
    }

    @Deprecated
    @OptionTag(value="profiles")
    public Collection<String> getEnabledProfilesForXmlSerializer() {
        return this.myEnabledProfilesForXmlSerializer;
    }

    @Deprecated
    public void setEnabledProfilesForXmlSerializer(@Nullable Collection<String> enabledProfilesForXmlSerializer) {
        if (enabledProfilesForXmlSerializer != null) {
            if (this.myEnabledProfilesForXmlSerializer == enabledProfilesForXmlSerializer) {
                return;
            }
            this.myEnabledProfilesForXmlSerializer.retainAll(enabledProfilesForXmlSerializer);
            this.myEnabledProfilesForXmlSerializer.addAll(enabledProfilesForXmlSerializer);
        }
    }

    public void fixAfterLoadingFromOldFormat() {
        for (String profile : this.myEnabledProfilesForXmlSerializer) {
            this.myProfilesMap.put(profile, true);
        }
        this.myEnabledProfilesForXmlSerializer.clear();
        File workingDir = this.getWorkingDirFile();
        if ("pom.xml".equals(workingDir.getName())) {
            this.setWorkingDirPath(workingDir.getParent());
        }
    }

    @OptionTag(value="profilesMap")
    @MapAnnotation(sortBeforeSave=false)
    public Map<String, Boolean> getProfilesMap() {
        return this.myProfilesMap;
    }

    public void setProfilesMap(@NotNull Map<String, Boolean> profilesMap) {
        if (profilesMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profilesMap", "org/jetbrains/idea/maven/execution/MavenRunnerParameters", "setProfilesMap"));
        }
        if (this.myProfilesMap == profilesMap) {
            return;
        }
        this.myProfilesMap.clear();
        for (Map.Entry<String, Boolean> entry : profilesMap.entrySet()) {
            if (entry.getValue() == null) continue;
            this.myProfilesMap.put(entry.getKey(), entry.getValue());
        }
    }

    @Transient
    public Collection<String> getProfiles() {
        return Maps.filterValues(this.myProfilesMap, (Predicate)Predicates.equalTo((Object)true)).keySet();
    }

    public void setProfiles(@Nullable Collection<String> profiles) {
        if (profiles != null) {
            for (String profile : profiles) {
                this.myProfilesMap.put(profile, true);
            }
        }
    }

    public boolean isResolveToWorkspace() {
        return this.myResolveToWorkspace;
    }

    public void setResolveToWorkspace(boolean resolveToWorkspace) {
        this.myResolveToWorkspace = resolveToWorkspace;
    }

    public MavenRunnerParameters clone() {
        return new MavenRunnerParameters(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenRunnerParameters that = (MavenRunnerParameters)o;
        if (this.isPomExecution != that.isPomExecution) {
            return false;
        }
        if (this.myResolveToWorkspace != that.myResolveToWorkspace) {
            return false;
        }
        if (!this.myGoals.equals(that.myGoals)) {
            return false;
        }
        if (this.myWorkingDirPath != null ? !this.myWorkingDirPath.equals(that.myWorkingDirPath) : that.myWorkingDirPath != null) {
            return false;
        }
        return this.myProfilesMap.equals(that.myProfilesMap);
    }

    public int hashCode() {
        int result = this.isPomExecution ? 1 : 0;
        result = 31 * result + (this.myWorkingDirPath != null ? this.myWorkingDirPath.hashCode() : 0);
        result = 31 * result + this.myGoals.hashCode();
        result = 31 * result + this.myProfilesMap.hashCode();
        return result;
    }
}

