/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenEnvironmentForm
implements PanelWithAnchor {
    private JPanel panel;
    private LabeledComponent<ComponentWithBrowseButton<TextFieldWithHistory>> mavenHomeComponent;
    private TextFieldWithHistory mavenHomeField;
    private LabeledComponent<JBLabel> mavenVersionLabelComponent;
    private LabeledComponent<TextFieldWithBrowseButton> settingsFileComponent;
    private LabeledComponent<TextFieldWithBrowseButton> localRepositoryComponent;
    private JCheckBox settingsOverrideCheckBox;
    private JCheckBox localRepositoryOverrideCheckBox;
    private JComponent anchor;
    private final PathOverrider userSettingsFileOverrider;
    private final PathOverrider localRepositoryOverrider;
    private boolean isUpdating = false;
    private final Alarm myUpdateAlarm;

    public MavenEnvironmentForm() {
        this.$$$setupUI$$$();
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        DocumentAdapter listener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (MavenEnvironmentForm.this.isUpdating) {
                        return;
                    }
                    if (!MavenEnvironmentForm.this.panel.isShowing()) {
                        return;
                    }
                    MavenEnvironmentForm.this.myUpdateAlarm.cancelAllRequests();
                    MavenEnvironmentForm.this.myUpdateAlarm.addRequest(() -> {
                        MavenEnvironmentForm.this.isUpdating = true;
                        MavenEnvironmentForm.this.userSettingsFileOverrider.updateDefault();
                        MavenEnvironmentForm.this.localRepositoryOverrider.updateDefault();
                        MavenEnvironmentForm.this.isUpdating = false;
                    }, 100);
                });
            }
        };
        this.userSettingsFileOverrider = new PathOverrider(this.settingsFileComponent, this.settingsOverrideCheckBox, (DocumentListener)listener, new PathProvider(){

            @Override
            @Nullable
            protected File getFile() {
                return MavenUtil.resolveUserSettingsFile("");
            }
        });
        this.localRepositoryOverrider = new PathOverrider(this.localRepositoryComponent, this.localRepositoryOverrideCheckBox, (DocumentListener)listener, new PathProvider(){

            @Override
            @Nullable
            protected File getFile() {
                return MavenUtil.resolveLocalRepository("", FileUtil.toSystemIndependentName((String)MavenEnvironmentForm.this.mavenHomeField.getText().trim()), ((TextFieldWithBrowseButton)MavenEnvironmentForm.this.settingsFileComponent.getComponent()).getText());
            }
        });
        this.mavenHomeField.addDocumentListener((DocumentListener)listener);
        this.setAnchor((JComponent)this.mavenHomeComponent.getLabel());
    }

    private void createUIComponents() {
        this.mavenHomeField = new TextFieldWithHistory();
        this.mavenHomeField.setHistorySize(-1);
        ArrayList<String> foundMavenHomes = new ArrayList<String>();
        foundMavenHomes.add("Bundled (Maven 2)");
        foundMavenHomes.add("Bundled (Maven 3)");
        File mavenHomeDirectory = MavenUtil.resolveMavenHomeDirectory(null);
        if (mavenHomeDirectory != null) {
            foundMavenHomes.add(FileUtil.toSystemIndependentName((String)mavenHomeDirectory.getPath()));
        }
        this.mavenHomeField.setHistory(foundMavenHomes);
        this.mavenHomeComponent = LabeledComponent.create((JComponent)new ComponentWithBrowseButton((JComponent)this.mavenHomeField, null), (String)"Maven &amp;home directory");
        JBLabel versionLabel = new JBLabel();
        versionLabel.setOpaque(true);
        versionLabel.setVerticalAlignment(1);
        versionLabel.setVerticalTextPosition(1);
        this.mavenVersionLabelComponent = LabeledComponent.create((JComponent)versionLabel, (String)"");
    }

    public boolean isModified(MavenGeneralSettings data) {
        MavenGeneralSettings formData = new MavenGeneralSettings();
        this.setData(formData);
        return !formData.equals(data);
    }

    public void setData(MavenGeneralSettings data) {
        data.setMavenHome(FileUtil.toSystemIndependentName((String)this.mavenHomeField.getText().trim()));
        data.setUserSettingsFile(this.userSettingsFileOverrider.getResult());
        data.setLocalRepository(this.localRepositoryOverrider.getResult());
    }

    public void getData(MavenGeneralSettings data) {
        String resolvedMavenHome = MavenEnvironmentForm.resolveMavenHome(data.getMavenHome());
        String mavenHome = (String)ObjectUtils.chooseNotNull((Object)resolvedMavenHome, (Object)data.getMavenHome());
        this.mavenHomeField.setText(mavenHome != null ? FileUtil.toSystemIndependentName((String)mavenHome) : null);
        this.mavenHomeField.addCurrentTextToHistory();
        this.updateMavenVersionLabel();
        this.userSettingsFileOverrider.reset(data.getUserSettingsFile());
        this.localRepositoryOverrider.reset(data.getLocalRepository());
    }

    @Nullable
    private static String resolveMavenHome(@Nullable String mavenHome) {
        if (mavenHome != null && (StringUtil.equals((CharSequence)"Bundled (Maven 2)", (CharSequence)mavenHome) || StringUtil.equals((CharSequence)"Bundled (Maven 3)", (CharSequence)mavenHome))) {
            return mavenHome;
        }
        File mavenHomeDirectory = MavenUtil.resolveMavenHomeDirectory(mavenHome);
        return mavenHomeDirectory != null ? mavenHomeDirectory.getPath() : null;
    }

    private void updateMavenVersionLabel() {
        String version = MavenServerManager.getInstance().getMavenVersion(this.getMavenHome());
        String versionText = version == null ? "Invalid Maven home directory" : String.format("(Version: %s)", version);
        ((JBLabel)this.mavenVersionLabelComponent.getComponent()).setText(versionText);
    }

    @Nullable
    public String getMavenHome() {
        String mavenHome = FileUtil.toSystemIndependentName((String)this.mavenHomeField.getText().trim());
        File mavenHomeFile = MavenServerManager.getMavenHomeFile(mavenHome);
        return mavenHomeFile != null ? mavenHomeFile.getPath() : null;
    }

    public JComponent createComponent() {
        ((ComponentWithBrowseButton)this.mavenHomeComponent.getComponent()).addBrowseFolderListener(ProjectBundle.message("maven.select.maven.home.directory", new Object[0]), "", null, BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR, TextComponentAccessor.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
        this.mavenHomeField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                MavenEnvironmentForm.this.updateMavenVersionLabel();
            }
        });
        ((TextFieldWithBrowseButton)this.settingsFileComponent.getComponent()).addBrowseFolderListener(ProjectBundle.message("maven.select.maven.settings.file", new Object[0]), "", null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        ((TextFieldWithBrowseButton)this.localRepositoryComponent.getComponent()).addBrowseFolderListener(ProjectBundle.message("maven.select.local.repository", new Object[0]), "", null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        return this.panel;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.mavenHomeComponent.setAnchor(anchor);
        this.mavenVersionLabelComponent.setAnchor(anchor);
        this.settingsFileComponent.setAnchor(anchor);
        this.localRepositoryComponent.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        LabeledComponent labeledComponent;
        JCheckBox jCheckBox2;
        LabeledComponent labeledComponent2;
        JPanel jPanel;
        this.createUIComponents();
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.settingsFileComponent = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setText("User &settings file");
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        jPanel.add((Component)labeledComponent2, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.settingsOverrideCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Override");
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.localRepositoryComponent = labeledComponent = new LabeledComponent();
        labeledComponent.setText("Local &repository");
        labeledComponent.setLabelLocation("West");
        labeledComponent.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        jPanel.add((Component)labeledComponent, new GridConstraints(3, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.localRepositoryOverrideCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Override");
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        LabeledComponent<ComponentWithBrowseButton<TextFieldWithHistory>> labeledComponent3 = this.mavenHomeComponent;
        labeledComponent3.setText("Maven &home directory");
        labeledComponent3.setLabelLocation("West");
        jPanel.add((Component)labeledComponent3, new GridConstraints(0, 0, 1, 2, 0, 1, 7, 3, null, null, null));
        LabeledComponent<JBLabel> labeledComponent4 = this.mavenVersionLabelComponent;
        labeledComponent4.setText("");
        labeledComponent4.setLabelLocation("West");
        jPanel.add((Component)labeledComponent4, new GridConstraints(1, 0, 1, 1, 9, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private static class PathOverrider {
        private final TextFieldWithBrowseButton component;
        private final JCheckBox checkBox;
        private final PathProvider pathProvider;
        private Boolean isOverridden;
        private String overrideText;

        public PathOverrider(LabeledComponent<TextFieldWithBrowseButton> component, JCheckBox checkBox, DocumentListener docListener, PathProvider pathProvider) {
            this.component = (TextFieldWithBrowseButton)component.getComponent();
            this.component.getTextField().getDocument().addDocumentListener(docListener);
            this.checkBox = checkBox;
            this.pathProvider = pathProvider;
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.update();
                }
            });
        }

        private void update() {
            boolean override = this.checkBox.isSelected();
            if (Comparing.equal((Object)this.isOverridden, (Object)override)) {
                return;
            }
            this.isOverridden = override;
            this.component.setEditable(override);
            this.component.setEnabled(override && this.checkBox.isEnabled());
            if (override) {
                if (this.overrideText != null) {
                    this.component.setText(this.overrideText);
                }
            } else {
                if (!StringUtil.isEmptyOrSpaces((String)this.component.getText())) {
                    this.overrideText = this.component.getText();
                }
                this.component.setText(this.pathProvider.getPath());
            }
        }

        private void updateDefault() {
            if (!this.checkBox.isSelected()) {
                this.component.setText(this.pathProvider.getPath());
            }
        }

        public void reset(String text) {
            this.isOverridden = null;
            this.checkBox.setSelected(!StringUtil.isEmptyOrSpaces((String)text));
            this.overrideText = StringUtil.isEmptyOrSpaces((String)text) ? null : text;
            this.update();
        }

        public String getResult() {
            return this.checkBox.isSelected() ? this.component.getText().trim() : "";
        }
    }

    private static abstract class PathProvider {
        private PathProvider() {
        }

        public String getPath() {
            File file = this.getFile();
            return file == null ? "" : file.getPath();
        }

        @Nullable
        protected abstract File getFile();
    }
}

