/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.refactoring;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.RenameRefactoring;
import com.intellij.refactoring.openapi.impl.JavaRenameRefactoringImpl;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxComponentIdReferenceProvider;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxFieldIdReferenceProvider;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxPropertyReference;
import org.jetbrains.plugins.javaFX.refactoring.JavaFxPropertyElement;
import org.jetbrains.plugins.javaFX.refactoring.JavaFxRenameAttributeProcessor;

public class JavaFxPropertyRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        PsiReference reference = JavaFxPropertyRenameHandler.getKnownReference(JavaFxPropertyRenameHandler.getReferences(dataContext));
        return reference != null;
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler", "invoke"));
        }
        JavaFxPropertyRenameHandler.performInvoke(project, editor, dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler", "invoke"));
        }
        JavaFxPropertyRenameHandler.performInvoke(project, null, dataContext);
    }

    private static void performInvoke(@NotNull Project project, @Nullable Editor editor, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler", "performInvoke"));
        }
        PsiReference[] references = JavaFxPropertyRenameHandler.getReferences(dataContext);
        PsiReference reference = JavaFxPropertyRenameHandler.getKnownReference(references);
        if (reference == null) {
            return;
        }
        if (reference instanceof JavaFxComponentIdReferenceProvider.JavaFxIdReferenceBase && ((JavaFxComponentIdReferenceProvider.JavaFxIdReferenceBase)reference).isBuiltIn()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Cannot rename built-in property", (String)"Cannot rename", null);
            return;
        }
        if (reference instanceof JavaFxPropertyReference && reference.resolve() != null) {
            JavaFxPropertyReference propertyReference = (JavaFxPropertyReference)reference;
            Map<PsiElement, String> elementsToRename = JavaFxPropertyRenameHandler.getElementsToRename(propertyReference, "a");
            if (!JavaFxPropertyRenameHandler.canRename(project, editor, elementsToRename.keySet())) {
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                String newName = (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext);
                assert (newName != null) : "Rename property";
                JavaFxPropertyRenameHandler.doRename(propertyReference, newName, false, false);
                return;
            }
            PsiElement psiElement = JavaFxPropertyElement.fromReference(propertyReference);
            if (psiElement != null) {
                new PropertyRenameDialog(propertyReference, psiElement, project, editor).show();
            }
        }
        if (reference instanceof JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef) {
            THashSet elementsToRename = new THashSet();
            JavaFxRenameAttributeProcessor.visitReferencedElements(references, (NullableConsumer<PsiElement>)((NullableConsumer)arg_0 -> JavaFxPropertyRenameHandler.lambda$performInvoke$0((Set)elementsToRename, arg_0)));
            if (!JavaFxPropertyRenameHandler.canRename(project, editor, (Collection<PsiElement>)elementsToRename)) {
                return;
            }
            XmlAttributeValue fxIdElement = ((JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef)reference).getXmlAttributeValue();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                String newName = (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext);
                assert (newName != null) : "Rename property";
                new RenameDialog(project, (PsiElement)fxIdElement, null, editor).performRename(newName);
            } else {
                new RenameDialog(project, (PsiElement)fxIdElement, null, editor).show();
            }
        }
    }

    private static boolean canRename(@NotNull Project project, @Nullable Editor editor, @NotNull Collection<PsiElement> elements) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler", "canRename"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler", "canRename"));
        }
        return elements.stream().allMatch(element -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler", "lambda$canRename$1"));
            }
            return PsiElementRenameHandler.canRename((Project)project, (Editor)editor, (PsiElement)element);
        });
    }

    private static void doRename(JavaFxPropertyReference reference, String newName, boolean searchInComments, boolean isPreview) {
        PsiElement psiElement = JavaFxPropertyElement.fromReference(reference);
        if (psiElement == null) {
            return;
        }
        JavaRenameRefactoringImpl rename = new JavaRenameRefactoringImpl(psiElement.getProject(), psiElement, newName, searchInComments, false);
        rename.setPreviewUsages(isPreview);
        Map<PsiElement, String> elementsToRename = JavaFxPropertyRenameHandler.getElementsToRename(reference, newName);
        elementsToRename.forEach((arg_0, arg_1) -> ((RenameRefactoring)rename).addElement(arg_0, arg_1));
        rename.run();
    }

    @Nullable
    private static PsiReference getKnownReference(PsiReference[] references) {
        return (PsiReference)ContainerUtil.find((Object[])references, JavaFxPropertyRenameHandler::isKnown);
    }

    @NotNull
    private static PsiReference[] getReferences(DataContext dataContext) {
        Project project;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null && editor != null && ApplicationManager.getApplication().isUnitTestMode() && (project = editor.getProject()) != null) {
            file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        if (editor != null && file instanceof XmlFile && JavaFxFileTypeFactory.isFxml(file)) {
            int offset = editor.getCaretModel().getOffset();
            PsiReference reference = file.findReferenceAt(offset);
            if (reference instanceof PsiMultiReference) {
                PsiReference[] psiReferenceArray = ((PsiMultiReference)reference).getReferences();
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler", "getReferences"));
                }
                return psiReferenceArray;
            }
            if (JavaFxPropertyRenameHandler.isKnown(reference)) {
                PsiReference[] psiReferenceArray = new PsiReference[]{reference};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler", "getReferences"));
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler", "getReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean isKnown(PsiReference reference) {
        if (reference instanceof JavaFxPropertyReference || reference instanceof JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef) {
            return true;
        }
        if (reference instanceof JavaFxComponentIdReferenceProvider.JavaFxIdReferenceBase) {
            return ((JavaFxComponentIdReferenceProvider.JavaFxIdReferenceBase)reference).isBuiltIn();
        }
        return false;
    }

    @NotNull
    private static Map<PsiElement, String> getElementsToRename(@NotNull JavaFxPropertyReference reference, @NotNull String newPropertyName) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler", "getElementsToRename"));
        }
        if (newPropertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newPropertyName", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler", "getElementsToRename"));
        }
        THashMap rename = new THashMap();
        JavaFxPropertyRenameHandler.putIfKeyNotNull(rename, reference.getGetter(), PropertyUtil.suggestGetterName((String)newPropertyName, (PsiType)reference.getType()));
        JavaFxPropertyRenameHandler.putIfKeyNotNull(rename, reference.getField(), newPropertyName);
        JavaFxPropertyRenameHandler.putIfKeyNotNull(rename, reference.getSetter(), PropertyUtil.suggestSetterName((String)newPropertyName));
        JavaFxPropertyRenameHandler.putIfKeyNotNull(rename, reference.getObservableGetter(), newPropertyName + "Property");
        JavaFxPropertyRenameHandler.putIfKeyNotNull(rename, reference.getStaticSetter(), PropertyUtil.suggestSetterName((String)newPropertyName));
        THashMap tHashMap = rename;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler", "getElementsToRename"));
        }
        return tHashMap;
    }

    private static <K, V> void putIfKeyNotNull(@NotNull Map<K, V> map, @Nullable K key, @NotNull V value) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler", "putIfKeyNotNull"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler", "putIfKeyNotNull"));
        }
        if (key != null) {
            map.put(key, value);
        }
    }

    private static /* synthetic */ void lambda$performInvoke$0(Set elementsToRename, PsiElement psiElement) {
        if (psiElement != null) {
            elementsToRename.add(psiElement);
        }
    }

    private static class PropertyRenameDialog
    extends RenameDialog {
        private final JavaFxPropertyReference myPropertyReference;

        protected PropertyRenameDialog(@NotNull JavaFxPropertyReference propertyReference, @NotNull PsiElement psiElement, @NotNull Project project, Editor editor) {
            if (propertyReference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyReference", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler$PropertyRenameDialog", "<init>"));
            }
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler$PropertyRenameDialog", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler$PropertyRenameDialog", "<init>"));
            }
            super(project, psiElement, null, editor);
            this.myPropertyReference = propertyReference;
        }

        protected void doAction() {
            String newName = this.getNewName();
            boolean searchInComments = this.isSearchInComments();
            JavaFxPropertyRenameHandler.doRename(this.myPropertyReference, newName, searchInComments, this.isPreviewUsages());
            this.close(0);
        }
    }
}

