/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.SuiteRunner;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.internal.IConfiguration;
import org.testng.internal.Invoker;
import org.testng.internal.PropertiesFile;
import org.testng.remote.adapter.DefaultMastertAdapter;
import org.testng.remote.adapter.IMasterAdapter;
import org.testng.remote.adapter.RemoteResultListener;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuiteDispatcher {
    public static final String MASTER_STRATEGY = "testng.master.strategy";
    public static final String VERBOSE = "testng.verbose";
    public static final String MASTER_ADPATER = "testng.master.adpter";
    public static final String STRATEGY_TEST = "test";
    public static final String STRATEGY_SUITE = "suite";
    private final int m_verbose;
    private final boolean m_isStrategyTest;
    private final IMasterAdapter m_masterAdpter;

    public SuiteDispatcher(String propertiesFile) throws TestNGException {
        try {
            PropertiesFile file = new PropertiesFile(propertiesFile);
            Properties properties = file.getProperties();
            this.m_verbose = Integer.parseInt(properties.getProperty(VERBOSE, "1"));
            String strategy = properties.getProperty(MASTER_STRATEGY, STRATEGY_SUITE);
            this.m_isStrategyTest = STRATEGY_TEST.equalsIgnoreCase(strategy);
            String adapter = properties.getProperty(MASTER_ADPATER);
            if (adapter == null) {
                this.m_masterAdpter = new DefaultMastertAdapter();
            } else {
                Class<?> clazz = Class.forName(adapter);
                this.m_masterAdpter = (IMasterAdapter)clazz.newInstance();
            }
            this.m_masterAdpter.init(properties);
        }
        catch (Exception e) {
            throw new TestNGException("Fail to initialize master mode", e);
        }
    }

    public List<ISuite> dispatch(IConfiguration configuration, List<XmlSuite> suites, String outputDir, List<ITestListener> testListeners) {
        List<ISuite> result = Lists.newArrayList();
        try {
            for (XmlSuite xmlSuite : suites) {
                xmlSuite.setVerbose(this.m_verbose);
                SuiteRunner suiteRunner = new SuiteRunner(configuration, xmlSuite, outputDir);
                RemoteResultListener listener = new RemoteResultListener(suiteRunner);
                if (this.m_isStrategyTest) {
                    for (XmlTest test : xmlSuite.getTests()) {
                        XmlSuite tmpSuite = new XmlSuite();
                        tmpSuite.setXmlPackages(xmlSuite.getXmlPackages());
                        tmpSuite.setJUnit(xmlSuite.isJUnit());
                        tmpSuite.setSkipFailedInvocationCounts(xmlSuite.skipFailedInvocationCounts());
                        tmpSuite.setName("Temporary suite for " + test.getName());
                        tmpSuite.setParallel(xmlSuite.getParallel());
                        tmpSuite.setParentModule(xmlSuite.getParentModule());
                        tmpSuite.setParameters(xmlSuite.getParameters());
                        tmpSuite.setThreadCount(xmlSuite.getThreadCount());
                        tmpSuite.setDataProviderThreadCount(xmlSuite.getDataProviderThreadCount());
                        tmpSuite.setVerbose(xmlSuite.getVerbose());
                        tmpSuite.setObjectFactory(xmlSuite.getObjectFactory());
                        XmlTest tmpTest = new XmlTest(tmpSuite);
                        tmpTest.setBeanShellExpression(test.getExpression());
                        tmpTest.setXmlClasses(test.getXmlClasses());
                        tmpTest.setExcludedGroups(test.getExcludedGroups());
                        tmpTest.setIncludedGroups(test.getIncludedGroups());
                        tmpTest.setJUnit(test.isJUnit());
                        tmpTest.setMethodSelectors(test.getMethodSelectors());
                        tmpTest.setName(test.getName());
                        tmpTest.setParallel(test.getParallel());
                        tmpTest.setParameters(test.getLocalParameters());
                        tmpTest.setVerbose(test.getVerbose());
                        tmpTest.setXmlClasses(test.getXmlClasses());
                        tmpTest.setXmlPackages(test.getXmlPackages());
                        this.m_masterAdpter.runSuitesRemotely(tmpSuite, listener);
                    }
                } else {
                    this.m_masterAdpter.runSuitesRemotely(xmlSuite, listener);
                }
                result.add(suiteRunner);
            }
            this.m_masterAdpter.awaitTermination(100000L);
            for (ISuite iSuite : result) {
                for (ISuiteResult suiteResult : iSuite.getResults().values()) {
                    Collection[] allTests;
                    for (Collection all : allTests = new Collection[]{suiteResult.getTestContext().getPassedTests().getAllResults(), suiteResult.getTestContext().getFailedTests().getAllResults(), suiteResult.getTestContext().getSkippedTests().getAllResults(), suiteResult.getTestContext().getFailedButWithinSuccessPercentageTests().getAllResults()}) {
                        for (ITestResult tr : all) {
                            Invoker.runTestListeners(tr, testListeners);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

