/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser.treeinsert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import opennlp.tools.parser.AbstractContextGenerator;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.treeinsert.Parser;

public class CheckContextGenerator
extends AbstractContextGenerator {
    private Parse[] leftNodes;

    public CheckContextGenerator(Set<String> punctSet) {
        this.punctSet = punctSet;
        this.leftNodes = new Parse[2];
    }

    public String[] getContext(Object arg0) {
        return null;
    }

    public String[] getContext(Parse parent, Parse[] constituents, int index, boolean trimFrontier) {
        List<Parse> rf;
        ArrayList<String> features = new ArrayList<String>(100);
        features.add("default");
        Parse[] children = Parser.collapsePunctuation(parent.getChildren(), this.punctSet);
        Parse pstart = children[0];
        Parse pend = children[children.length - 1];
        String type = parent.getType();
        this.checkcons(pstart, "begin", type, features);
        this.checkcons(pend, "last", type, features);
        String production = "p=" + this.production(parent, false);
        String punctProduction = "pp=" + this.production(parent, true);
        features.add(production);
        features.add(punctProduction);
        Parse p1 = null;
        Parse p2 = null;
        Parse p_1 = null;
        Parse p_2 = null;
        Collection<Parse> p1s = constituents[index].getNextPunctuationSet();
        Collection<Parse> p2s = null;
        Collection<Parse> p_1s = constituents[index].getPreviousPunctuationSet();
        Collection<Parse> p_2s = null;
        if (index == 0) {
            rf = Collections.emptyList();
        } else {
            rf = Parser.getRightFrontier(constituents[0], this.punctSet);
            if (trimFrontier) {
                int pi = rf.indexOf(parent);
                if (pi == -1) {
                    throw new RuntimeException("Parent not found in right frontier:" + parent + " rf=" + rf);
                }
                for (int ri = 0; ri <= pi; ++ri) {
                    rf.remove(0);
                }
            }
        }
        this.getFrontierNodes(rf, this.leftNodes);
        p_1 = this.leftNodes[0];
        p_2 = this.leftNodes[1];
        int ps = constituents.length;
        if (p_1 != null) {
            p_2s = p_1.getPreviousPunctuationSet();
        }
        if (index + 1 < ps) {
            p1 = constituents[index + 1];
            p2s = p1.getNextPunctuationSet();
        }
        if (index + 2 < ps) {
            p2 = constituents[index + 2];
        }
        this.surround(p_1, -1, type, p_1s, features);
        this.surround(p_2, -2, type, p_2s, features);
        this.surround(p1, 1, type, p1s, features);
        this.surround(p2, 2, type, p2s, features);
        return features.toArray(new String[features.size()]);
    }
}

