/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.util.ChangeListener;
import org.gradle.util.DiffUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractNamedFileSnapshotTaskStateChanges
implements TaskStateChanges {
    private Map<String, FileCollectionSnapshot> fileSnapshotsBeforeExecution;
    private final String taskName;
    private final String title;
    protected final SortedSet<? extends TaskFilePropertySpec> fileProperties;
    private final FileCollectionSnapshotter snapshotter;
    protected final TaskExecution previous;
    protected final TaskExecution current;

    protected AbstractNamedFileSnapshotTaskStateChanges(String taskName, TaskExecution previous, TaskExecution current, FileCollectionSnapshotter snapshotter, String title, SortedSet<? extends TaskFilePropertySpec> fileProperties) {
        this.taskName = taskName;
        this.previous = previous;
        this.current = current;
        this.snapshotter = snapshotter;
        this.title = title;
        this.fileProperties = fileProperties;
        this.fileSnapshotsBeforeExecution = AbstractNamedFileSnapshotTaskStateChanges.buildSnapshots(taskName, snapshotter, title, fileProperties);
    }

    protected String getTaskName() {
        return this.taskName;
    }

    protected String getTitle() {
        return this.title;
    }

    protected SortedSet<? extends TaskFilePropertySpec> getFileProperties() {
        return this.fileProperties;
    }

    protected abstract Map<String, FileCollectionSnapshot> getPrevious();

    protected abstract void saveCurrent();

    protected FileCollectionSnapshotter getSnapshotter() {
        return this.snapshotter;
    }

    protected Map<String, FileCollectionSnapshot> getCurrent() {
        return this.fileSnapshotsBeforeExecution;
    }

    protected static Map<String, FileCollectionSnapshot> buildSnapshots(String taskName, FileCollectionSnapshotter snapshotter, String title, SortedSet<? extends TaskFilePropertySpec> fileProperties) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TaskFilePropertySpec taskFilePropertySpec : fileProperties) {
            FileCollectionSnapshot result;
            try {
                result = snapshotter.snapshot(taskFilePropertySpec);
            }
            catch (UncheckedIOException e) {
                throw new UncheckedIOException(String.format("Failed to capture snapshot of %s files for task '%s' property '%s' during up-to-date check.", title.toLowerCase(), taskName, taskFilePropertySpec.getPropertyName()), (Throwable)e);
            }
            builder.put((Object)taskFilePropertySpec.getPropertyName(), (Object)result);
        }
        return builder.build();
    }

    @Override
    public Iterator<TaskStateChange> iterator() {
        if (this.getPrevious() == null) {
            return Iterators.singletonIterator((Object)new DescriptiveChange(this.title + " file history is not available.", new Object[0]));
        }
        final LinkedList propertyChanges = Lists.newLinkedList();
        DiffUtil.diff(this.getCurrent().keySet(), this.getPrevious().keySet(), new ChangeListener<String>(){

            @Override
            public void added(String element) {
                propertyChanges.add(new DescriptiveChange("%s property '%s' has been added for task '%s'", AbstractNamedFileSnapshotTaskStateChanges.this.title, element, AbstractNamedFileSnapshotTaskStateChanges.this.taskName));
            }

            @Override
            public void removed(String element) {
                propertyChanges.add(new DescriptiveChange("%s property '%s' has been removed for task '%s'", AbstractNamedFileSnapshotTaskStateChanges.this.title, element, AbstractNamedFileSnapshotTaskStateChanges.this.taskName));
            }

            @Override
            public void changed(String element) {
                throw new AssertionError();
            }
        });
        if (!propertyChanges.isEmpty()) {
            return propertyChanges.iterator();
        }
        return Iterators.concat(Iterables.transform(this.getCurrent().entrySet(), (Function)new Function<Map.Entry<String, FileCollectionSnapshot>, Iterator<TaskStateChange>>(){

            public Iterator<TaskStateChange> apply(Map.Entry<String, FileCollectionSnapshot> entry) {
                String propertyName = entry.getKey();
                FileCollectionSnapshot currentSnapshot = entry.getValue();
                FileCollectionSnapshot previousSnapshot = AbstractNamedFileSnapshotTaskStateChanges.this.getPrevious().get(propertyName);
                String propertyTitle = AbstractNamedFileSnapshotTaskStateChanges.this.title + " property '" + propertyName + "'";
                return currentSnapshot.iterateContentChangesSince(previousSnapshot, propertyTitle);
            }
        }).iterator());
    }

    @Override
    public void snapshotAfterTask() {
        this.saveCurrent();
    }
}

