/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.cache.config;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.internal.tasks.cache.LocalDirectoryTaskOutputCache;
import org.gradle.api.internal.tasks.cache.TaskOutputCache;
import org.gradle.api.internal.tasks.cache.TaskOutputCacheFactory;
import org.gradle.api.internal.tasks.cache.config.TaskCachingInternal;

public class DefaultTaskCaching
implements TaskCachingInternal {
    private static final TaskOutputCacheFactory DEFAULT_LOCAL_TASK_CACHE_FACTORY = new TaskOutputCacheFactory(){

        public TaskOutputCache createCache(StartParameter startParameter) {
            String cacheDirectoryPath = System.getProperty("org.gradle.cache.tasks.directory");
            File cacheDirectory = cacheDirectoryPath != null ? new File(cacheDirectoryPath) : new File(startParameter.getGradleUserHomeDir(), "task-cache");
            return new LocalDirectoryTaskOutputCache(cacheDirectory);
        }
    };
    private TaskOutputCacheFactory factory = DEFAULT_LOCAL_TASK_CACHE_FACTORY;

    public void useLocalCache() {
        this.factory = DEFAULT_LOCAL_TASK_CACHE_FACTORY;
    }

    public void useLocalCache(final File directory) {
        this.factory = new TaskOutputCacheFactory(){

            public TaskOutputCache createCache(StartParameter startParameter) {
                return new LocalDirectoryTaskOutputCache(directory);
            }
        };
    }

    public void useCacheFactory(TaskOutputCacheFactory factory) {
        this.factory = factory;
    }

    public TaskOutputCacheFactory getCacheFactory() {
        return this.factory;
    }
}

