/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.extensions.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaInstance;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaPicoContainer;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.EPAvailabilityListenerExtension;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointAvailabilityListener;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointListener;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.LogProvider;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.UndefinedPluginDescriptor;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.com.intellij.util.pico.ConstructorInjectionComponentAdapter;
import org.jetbrains.kotlin.com.intellij.util.pico.DefaultPicoContainer;
import org.jetbrains.kotlin.gnu.trove.THashMap;
import org.jetbrains.kotlin.org.jdom.Attribute;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.Namespace;
import org.jetbrains.kotlin.org.picocontainer.PicoContainer;

public class ExtensionsAreaImpl
implements ExtensionsArea {
    private final LogProvider myLogger;
    private static final Map<String, String> ourDefaultEPs = new THashMap<String, String>();
    private final AreaPicoContainer myPicoContainer;
    private final Throwable myCreationTrace;
    private final Map<String, ExtensionPointImpl> myExtensionPoints;
    private final Map<String, Throwable> myEPTraces;
    private final MultiMap<String, ExtensionPointAvailabilityListener> myAvailabilityListeners;
    private final List<Runnable> mySuspendedListenerActions;
    private boolean myAvailabilityNotificationsActive;
    private final AreaInstance myAreaInstance;
    private final String myAreaClass;

    public ExtensionsAreaImpl(String areaClass, AreaInstance areaInstance, PicoContainer parentPicoContainer, @NotNull LogProvider logger) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "<init>"));
        }
        this.myExtensionPoints = ContainerUtil.newConcurrentMap();
        this.myEPTraces = null;
        this.myAvailabilityListeners = MultiMap.createSmart();
        this.mySuspendedListenerActions = new ArrayList<Runnable>();
        this.myAvailabilityNotificationsActive = true;
        this.myCreationTrace = null;
        this.myAreaClass = areaClass;
        this.myAreaInstance = areaInstance;
        this.myPicoContainer = new DefaultPicoContainer(parentPicoContainer);
        this.myLogger = logger;
        this.initialize();
    }

    public final void notifyAreaReplaced() {
        for (ExtensionPointImpl point : this.myExtensionPoints.values()) {
            point.notifyAreaReplaced(this);
        }
    }

    @Override
    @NotNull
    public AreaPicoContainer getPicoContainer() {
        AreaPicoContainer areaPicoContainer = this.myPicoContainer;
        if (areaPicoContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "getPicoContainer"));
        }
        return areaPicoContainer;
    }

    @Override
    public String getAreaClass() {
        return this.myAreaClass;
    }

    @Override
    public void registerExtensionPoint(@NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionPointElement) {
        ExtensionPoint.Kind kind;
        String className2;
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        if (extensionPointElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointElement", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        assert (pluginDescriptor.getPluginId() != null);
        String pluginId = pluginDescriptor.getPluginId().getIdString();
        String epName = extensionPointElement.getAttributeValue("qualifiedName");
        if (epName == null) {
            String name = extensionPointElement.getAttributeValue("name");
            if (name == null) {
                throw new RuntimeException("'name' attribute not specified for extension point in '" + pluginId + "' plugin");
            }
            epName = pluginId + '.' + name;
        }
        String beanClassName = extensionPointElement.getAttributeValue("beanClass");
        String interfaceClassName = extensionPointElement.getAttributeValue("interface");
        if (beanClassName == null && interfaceClassName == null) {
            throw new RuntimeException("Neither 'beanClass' nor 'interface' attribute is specified for extension point '" + epName + "' in '" + pluginId + "' plugin");
        }
        if (beanClassName != null && interfaceClassName != null) {
            throw new RuntimeException("Both 'beanClass' and 'interface' attributes are specified for extension point '" + epName + "' in '" + pluginId + "' plugin");
        }
        if (interfaceClassName != null) {
            className2 = interfaceClassName;
            kind = ExtensionPoint.Kind.INTERFACE;
        } else {
            className2 = beanClassName;
            kind = ExtensionPoint.Kind.BEAN_CLASS;
        }
        this.registerExtensionPoint(epName, className2, pluginDescriptor, kind);
    }

    @Override
    public void registerExtension(@NotNull PluginDescriptor pluginDescriptor, @NotNull Element extensionElement) {
        ExtensionComponentAdapter adapter;
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtension"));
        }
        if (extensionElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionElement", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtension"));
        }
        PluginId pluginId = pluginDescriptor.getPluginId();
        String epName = ExtensionsAreaImpl.extractEPName(extensionElement);
        ExtensionPoint extensionPoint = this.getExtensionPoint(epName);
        if (((ExtensionPointImpl)extensionPoint).getKind() == ExtensionPoint.Kind.INTERFACE) {
            String implClass = extensionElement.getAttributeValue("implementation");
            if (implClass == null) {
                throw new RuntimeException("'implementation' attribute not specified for '" + epName + "' extension in '" + pluginId.getIdString() + "' plugin");
            }
            adapter = new ExtensionComponentAdapter(implClass, extensionElement, this.myPicoContainer, pluginDescriptor, ExtensionsAreaImpl.shouldDeserializeInstance(extensionElement));
        } else {
            adapter = new ExtensionComponentAdapter(((ExtensionPointImpl)extensionPoint).getClassName(), extensionElement, this.myPicoContainer, pluginDescriptor, true);
        }
        this.myPicoContainer.registerComponent(adapter);
        ((ExtensionPointImpl)extensionPoint).registerExtensionAdapter(adapter);
    }

    private static boolean shouldDeserializeInstance(Element extensionElement) {
        if (!extensionElement.getContent().isEmpty()) {
            return true;
        }
        for (Attribute attribute : extensionElement.getAttributes()) {
            String name = attribute.getName();
            if ("implementation".equals(name) || "id".equals(name) || "order".equals(name)) continue;
            return true;
        }
        return false;
    }

    public static String extractEPName(Element extensionElement) {
        String epName = extensionElement.getAttributeValue("point");
        if (epName == null) {
            String ns;
            Element parentElement = extensionElement.getParentElement();
            String string = ns = parentElement != null ? parentElement.getAttributeValue("defaultExtensionNs") : null;
            if (ns != null) {
                epName = ns + '.' + extensionElement.getName();
            } else {
                Namespace namespace = extensionElement.getNamespace();
                epName = namespace.getURI() + '.' + extensionElement.getName();
            }
        }
        return epName;
    }

    private void initialize() {
        for (Map.Entry<String, String> entry : ourDefaultEPs.entrySet()) {
            String epName = entry.getKey();
            this.registerExtensionPoint(epName, entry.getValue());
        }
        ((ExtensionPointImpl)this.getExtensionPoint("org.jetbrains.kotlin.com.intellij.openapi.extensions.epAvailabilityListener")).addExtensionPointListener(new ExtensionPointListener(){

            public void extensionRemoved(@NotNull Object extension, PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl$1", "extensionRemoved"));
                }
                EPAvailabilityListenerExtension epListenerExtension = (EPAvailabilityListenerExtension)extension;
                Collection listeners = ExtensionsAreaImpl.this.myAvailabilityListeners.get(epListenerExtension.getExtensionPointName());
                Iterator iterator2 = listeners.iterator();
                while (iterator2.hasNext()) {
                    ExtensionPointAvailabilityListener listener = (ExtensionPointAvailabilityListener)iterator2.next();
                    if (!listener.getClass().getName().equals(epListenerExtension.getListenerClass())) continue;
                    iterator2.remove();
                    return;
                }
                ExtensionsAreaImpl.this.myLogger.warn("Failed to find EP availability listener: " + epListenerExtension.getListenerClass());
            }

            public void extensionAdded(@NotNull Object extension, PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl$1", "extensionAdded"));
                }
                EPAvailabilityListenerExtension epListenerExtension = (EPAvailabilityListenerExtension)extension;
                try {
                    String epName = epListenerExtension.getExtensionPointName();
                    ExtensionPointAvailabilityListener listener = (ExtensionPointAvailabilityListener)ExtensionsAreaImpl.this.instantiate(epListenerExtension.loadListenerClass());
                    ExtensionsAreaImpl.this.addAvailabilityListener(epName, listener);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private Object instantiate(Class clazz) {
        ConstructorInjectionComponentAdapter adapter = new ConstructorInjectionComponentAdapter(Integer.toString(System.identityHashCode(new Object())), clazz);
        return adapter.getComponentInstance(this.getPicoContainer());
    }

    public void addAvailabilityListener(@NotNull String extensionPointName, @NotNull ExtensionPointAvailabilityListener listener) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "addAvailabilityListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "addAvailabilityListener"));
        }
        this.myAvailabilityListeners.putValue(extensionPointName, listener);
        if (this.hasExtensionPoint(extensionPointName)) {
            this.notifyAvailableListener(listener, this.myExtensionPoints.get(extensionPointName));
        }
    }

    public void registerExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        if (extensionPointBeanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointBeanClass", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, ExtensionPoint.Kind.INTERFACE);
    }

    @Override
    public void registerExtensionPoint(@NotNull @NonNls String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        if (extensionPointBeanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointBeanClass", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, new UndefinedPluginDescriptor(), kind);
    }

    private void registerExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull PluginDescriptor descriptor2, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        if (extensionPointBeanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointBeanClass", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        if (this.hasExtensionPoint(extensionPointName)) {
            throw new RuntimeException("Duplicate registration for EP: " + extensionPointName);
        }
        this.registerExtensionPoint(new ExtensionPointImpl(extensionPointName, extensionPointBeanClass, kind, this, this.myAreaInstance, this.myLogger, descriptor2));
    }

    public void registerExtensionPoint(@NotNull ExtensionPointImpl extensionPoint) {
        if (extensionPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPoint", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "registerExtensionPoint"));
        }
        String name = extensionPoint.getName();
        this.myExtensionPoints.put(name, extensionPoint);
        this.notifyEPRegistered(extensionPoint);
    }

    private void notifyEPRegistered(ExtensionPoint extensionPoint) {
        Collection<ExtensionPointAvailabilityListener> listeners = this.myAvailabilityListeners.get(extensionPoint.getName());
        for (ExtensionPointAvailabilityListener listener : listeners) {
            this.notifyAvailableListener(listener, extensionPoint);
        }
    }

    private void notifyAvailableListener(final ExtensionPointAvailabilityListener listener, final ExtensionPoint extensionPoint) {
        this.queueNotificationAction(new Runnable(){

            @Override
            public void run() {
                listener.extensionPointRegistered(extensionPoint);
            }
        });
    }

    private void queueNotificationAction(Runnable action) {
        if (this.myAvailabilityNotificationsActive) {
            action.run();
        } else {
            this.mySuspendedListenerActions.add(action);
        }
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "getExtensionPoint"));
        }
        ExtensionPointImpl extensionPoint = this.myExtensionPoints.get(extensionPointName);
        if (extensionPoint == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in area " + this.myAreaInstance);
        }
        ExtensionPointImpl extensionPointImpl = extensionPoint;
        if (extensionPointImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "getExtensionPoint"));
        }
        return extensionPointImpl;
    }

    @Override
    @NotNull
    public <T> ExtensionPoint<T> getExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "getExtensionPoint"));
        }
        ExtensionPoint extensionPoint = this.getExtensionPoint(extensionPointName.getName());
        if (extensionPoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "getExtensionPoint"));
        }
        return extensionPoint;
    }

    @Override
    @NotNull
    public ExtensionPoint[] getExtensionPoints() {
        ExtensionPoint[] extensionPointArray = this.myExtensionPoints.values().toArray(new ExtensionPoint[this.myExtensionPoints.size()]);
        if (extensionPointArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "getExtensionPoints"));
        }
        return extensionPointArray;
    }

    @Override
    public boolean hasExtensionPoint(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl", "hasExtensionPoint"));
        }
        return this.myExtensionPoints.containsKey(extensionPointName);
    }

    public String toString() {
        return (this.myAreaClass == null ? "Root" : this.myAreaClass) + " Area";
    }

    static {
        ourDefaultEPs.put("org.jetbrains.kotlin.com.intellij.openapi.extensions.epAvailabilityListener", EPAvailabilityListenerExtension.class.getName());
    }
}

