/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kotlin.jvm.functions.Function4;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.header.ReadKotlinClassHeaderAnnotationVisitor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public abstract class FileBasedKotlinClass
implements KotlinJvmBinaryClass {
    private final ClassId classId;
    private final int classVersion;
    private final KotlinClassHeader classHeader;
    private final InnerClassesInfo innerClasses;

    protected FileBasedKotlinClass(@NotNull ClassId classId, int classVersion, @NotNull KotlinClassHeader classHeader, @NotNull InnerClassesInfo innerClasses2) {
        if (classId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "<init>"));
        }
        if (classHeader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classHeader", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "<init>"));
        }
        if (innerClasses2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClasses", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "<init>"));
        }
        this.classId = classId;
        this.classVersion = classVersion;
        this.classHeader = classHeader;
        this.innerClasses = innerClasses2;
    }

    @NotNull
    protected abstract byte[] getFileContents();

    @Nullable
    public static <T extends FileBasedKotlinClass> T create(@NotNull byte[] fileContents, @NotNull Function4<ClassId, Integer, KotlinClassHeader, InnerClassesInfo, T> factory) {
        if (fileContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContents", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "create"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "create"));
        }
        final ReadKotlinClassHeaderAnnotationVisitor readHeaderVisitor = new ReadKotlinClassHeaderAnnotationVisitor();
        final Ref classNameRef = Ref.create();
        final Ref classVersion = Ref.create();
        final InnerClassesInfo innerClasses2 = new InnerClassesInfo();
        new ClassReader(fileContents).accept(new ClassVisitor(327680){

            @Override
            public void visit(int version, int access, @NotNull String name, String signature2, String superName, String[] interfaces) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$1", "visit"));
                }
                classNameRef.set(name);
                classVersion.set(version);
            }

            @Override
            public void visitInnerClass(@NotNull String name, String outerName, String innerName, int access) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$1", "visitInnerClass"));
                }
                innerClasses2.add(name, outerName, innerName);
            }

            @Override
            public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$1", "visitAnnotation"));
                }
                return FileBasedKotlinClass.convertAnnotationVisitor(readHeaderVisitor, desc, innerClasses2);
            }

            @Override
            public void visitEnd() {
                readHeaderVisitor.visitEnd();
            }
        }, 7);
        String className2 = (String)classNameRef.get();
        if (className2 == null) {
            return null;
        }
        KotlinClassHeader header = readHeaderVisitor.createHeader();
        if (header == null) {
            return null;
        }
        ClassId id = FileBasedKotlinClass.resolveNameByInternalName(className2, innerClasses2);
        return (T)((FileBasedKotlinClass)factory.invoke(id, (Integer)classVersion.get(), header, innerClasses2));
    }

    @Override
    @NotNull
    public ClassId getClassId() {
        ClassId classId = this.classId;
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "getClassId"));
        }
        return classId;
    }

    public int getClassVersion() {
        return this.classVersion;
    }

    @Override
    @NotNull
    public KotlinClassHeader getClassHeader() {
        KotlinClassHeader kotlinClassHeader = this.classHeader;
        if (kotlinClassHeader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "getClassHeader"));
        }
        return kotlinClassHeader;
    }

    @Override
    public void loadClassAnnotations(final @NotNull KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor) {
        if (annotationVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationVisitor", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "loadClassAnnotations"));
        }
        new ClassReader(this.getFileContents()).accept(new ClassVisitor(327680){

            @Override
            public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$2", "visitAnnotation"));
                }
                return FileBasedKotlinClass.convertAnnotationVisitor(annotationVisitor, desc, FileBasedKotlinClass.this.innerClasses);
            }

            @Override
            public void visitEnd() {
                annotationVisitor.visitEnd();
            }
        }, 7);
    }

    @Nullable
    private static AnnotationVisitor convertAnnotationVisitor(@NotNull KotlinJvmBinaryClass.AnnotationVisitor visitor2, @NotNull String desc, @NotNull InnerClassesInfo innerClasses2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "convertAnnotationVisitor"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "convertAnnotationVisitor"));
        }
        if (innerClasses2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClasses", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "convertAnnotationVisitor"));
        }
        KotlinJvmBinaryClass.AnnotationArgumentVisitor v = visitor2.visitAnnotation(FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses2), SourceElement.NO_SOURCE);
        return v == null ? null : FileBasedKotlinClass.convertAnnotationVisitor(v, innerClasses2);
    }

    @NotNull
    private static AnnotationVisitor convertAnnotationVisitor(final @NotNull KotlinJvmBinaryClass.AnnotationArgumentVisitor v, final @NotNull InnerClassesInfo innerClasses2) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "convertAnnotationVisitor"));
        }
        if (innerClasses2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClasses", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "convertAnnotationVisitor"));
        }
        AnnotationVisitor annotationVisitor = new AnnotationVisitor(327680){

            @Override
            public void visit(String name, @NotNull Object value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$3", "visit"));
                }
                v.visit(name == null ? null : Name.identifier(name), value);
            }

            @Override
            public AnnotationVisitor visitArray(String name) {
                final KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor arv = v.visitArray(Name.identifier(name));
                return arv == null ? null : new AnnotationVisitor(327680){

                    @Override
                    public void visit(String name, @NotNull Object value) {
                        if (value == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$3$1", "visit"));
                        }
                        arv.visit(value);
                    }

                    @Override
                    public void visitEnum(String name, @NotNull String desc, @NotNull String value) {
                        if (desc == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$3$1", "visitEnum"));
                        }
                        if (value == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$3$1", "visitEnum"));
                        }
                        arv.visitEnum(FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses2), Name.identifier(value));
                    }

                    @Override
                    public void visitEnd() {
                        arv.visitEnd();
                    }
                };
            }

            @Override
            public AnnotationVisitor visitAnnotation(String name, @NotNull String desc) {
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$3", "visitAnnotation"));
                }
                KotlinJvmBinaryClass.AnnotationArgumentVisitor arv = v.visitAnnotation(Name.identifier(name), FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses2));
                return arv == null ? null : FileBasedKotlinClass.convertAnnotationVisitor(arv, innerClasses2);
            }

            @Override
            public void visitEnum(String name, @NotNull String desc, @NotNull String value) {
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$3", "visitEnum"));
                }
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$3", "visitEnum"));
                }
                v.visitEnum(Name.identifier(name), FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses2), Name.identifier(value));
            }

            @Override
            public void visitEnd() {
                v.visitEnd();
            }
        };
        if (annotationVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "convertAnnotationVisitor"));
        }
        return annotationVisitor;
    }

    @Override
    public void visitMembers(final @NotNull KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        if (memberVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberVisitor", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "visitMembers"));
        }
        new ClassReader(this.getFileContents()).accept(new ClassVisitor(327680){

            @Override
            public FieldVisitor visitField(int access, @NotNull String name, @NotNull String desc, String signature2, Object value) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$4", "visitField"));
                }
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$4", "visitField"));
                }
                final KotlinJvmBinaryClass.AnnotationVisitor v = memberVisitor.visitField(Name.identifier(name), desc, value);
                if (v == null) {
                    return null;
                }
                return new FieldVisitor(327680){

                    @Override
                    public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                        if (desc == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$4$1", "visitAnnotation"));
                        }
                        return FileBasedKotlinClass.convertAnnotationVisitor(v, desc, FileBasedKotlinClass.this.innerClasses);
                    }

                    @Override
                    public void visitEnd() {
                        v.visitEnd();
                    }
                };
            }

            @Override
            public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, String signature2, String[] exceptions) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$4", "visitMethod"));
                }
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$4", "visitMethod"));
                }
                final KotlinJvmBinaryClass.MethodAnnotationVisitor v = memberVisitor.visitMethod(Name.identifier(name), desc);
                if (v == null) {
                    return null;
                }
                return new MethodVisitor(327680){

                    @Override
                    public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                        if (desc == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$4$2", "visitAnnotation"));
                        }
                        return FileBasedKotlinClass.convertAnnotationVisitor(v, desc, FileBasedKotlinClass.this.innerClasses);
                    }

                    @Override
                    public AnnotationVisitor visitParameterAnnotation(int parameter, @NotNull String desc, boolean visible) {
                        if (desc == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$4$2", "visitParameterAnnotation"));
                        }
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor av = v.visitParameterAnnotation(parameter, FileBasedKotlinClass.resolveNameByDesc(desc, FileBasedKotlinClass.this.innerClasses), SourceElement.NO_SOURCE);
                        return av == null ? null : FileBasedKotlinClass.convertAnnotationVisitor(av, FileBasedKotlinClass.this.innerClasses);
                    }

                    @Override
                    public void visitEnd() {
                        v.visitEnd();
                    }
                };
            }
        }, 7);
    }

    @NotNull
    private static ClassId resolveNameByDesc(@NotNull String desc, @NotNull InnerClassesInfo innerClasses2) {
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "resolveNameByDesc"));
        }
        if (innerClasses2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClasses", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "resolveNameByDesc"));
        }
        assert (desc.startsWith("L") && desc.endsWith(";")) : "Not a JVM descriptor: " + desc;
        String name = desc.substring(1, desc.length() - 1);
        ClassId classId = FileBasedKotlinClass.resolveNameByInternalName(name, innerClasses2);
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "resolveNameByDesc"));
        }
        return classId;
    }

    @NotNull
    private static ClassId resolveNameByInternalName(@NotNull String name, @NotNull InnerClassesInfo innerClasses2) {
        OuterAndInnerName outer;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "resolveNameByInternalName"));
        }
        if (innerClasses2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClasses", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "resolveNameByInternalName"));
        }
        if (!name.contains("$")) {
            ClassId classId = ClassId.topLevel(new FqName(name.replace('/', '.')));
            if (classId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "resolveNameByInternalName"));
            }
            return classId;
        }
        ArrayList<String> classes2 = new ArrayList<String>(1);
        boolean local = false;
        while ((outer = innerClasses2.get(name)) != null) {
            if (outer.outerInternalName == null) {
                local = true;
                break;
            }
            classes2.add(outer.innerSimpleName);
            name = outer.outerInternalName;
        }
        FqName outermostClassFqName = new FqName(name.replace('/', '.'));
        classes2.add(outermostClassFqName.shortName().asString());
        Collections.reverse(classes2);
        FqName packageFqName = outermostClassFqName.parent();
        FqName relativeClassName = FqName.fromSegments(classes2);
        ClassId classId = new ClassId(packageFqName, relativeClassName, local);
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass", "resolveNameByInternalName"));
        }
        return classId;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    public static class InnerClassesInfo {
        private Map<String, OuterAndInnerName> map = null;

        public void add(@NotNull String name, @Nullable String outerName, @Nullable String innerName) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$InnerClassesInfo", "add"));
            }
            if (this.map == null) {
                this.map = new HashMap<String, OuterAndInnerName>();
            }
            this.map.put(name, new OuterAndInnerName(outerName, innerName));
        }

        @Nullable
        public OuterAndInnerName get(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$InnerClassesInfo", "get"));
            }
            return this.map == null ? null : this.map.get(name);
        }
    }

    public static class OuterAndInnerName {
        public final String outerInternalName;
        public final String innerSimpleName;

        private OuterAndInnerName(@Nullable String outerInternalName, @Nullable String innerSimpleName) {
            this.outerInternalName = outerInternalName;
            this.innerSimpleName = innerSimpleName;
        }
    }
}

