/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.exceptions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;

public class DisablingBacktracesNode
extends RubyNode {
    @Node.Child
    private RubyNode child;
    private static final ThreadLocal<Boolean> BACTRACES_DISABLED = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public DisablingBacktracesNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
        super(context, sourceSection);
        this.child = child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(VirtualFrame frame) {
        boolean backtracesPreviouslyDisabled = DisablingBacktracesNode.getBacktracesDisabled();
        try {
            this.setBacktracesDisabled(true);
            Object object = this.child.execute(frame);
            return object;
        }
        finally {
            this.setBacktracesDisabled(backtracesPreviouslyDisabled);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static Boolean getBacktracesDisabled() {
        return BACTRACES_DISABLED.get();
    }

    @CompilerDirectives.TruffleBoundary
    private void setBacktracesDisabled(boolean value) {
        BACTRACES_DISABLED.set(value);
    }

    public static boolean areBacktracesDisabled() {
        return DisablingBacktracesNode.getBacktracesDisabled();
    }
}

