/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import jnr.ffi.CallingConvention;
import jnr.ffi.LibraryOption;
import jnr.ffi.mapper.CompositeFunctionMapper;
import jnr.ffi.mapper.CompositeTypeMapper;
import jnr.ffi.mapper.DataConverter;
import jnr.ffi.mapper.FromNativeConverter;
import jnr.ffi.mapper.FunctionMapper;
import jnr.ffi.mapper.SignatureTypeMapper;
import jnr.ffi.mapper.SignatureTypeMapperAdapter;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.mapper.TypeMapper;
import jnr.ffi.provider.FFIProvider;
import jnr.ffi.provider.LoadedLibrary;

public abstract class LibraryLoader<T> {
    private final List<String> searchPaths = new ArrayList<String>();
    private final List<String> libraryNames = new ArrayList<String>();
    private final List<SignatureTypeMapper> typeMappers = new ArrayList<SignatureTypeMapper>();
    private final List<FunctionMapper> functionMappers = new ArrayList<FunctionMapper>();
    private final Map<LibraryOption, Object> optionMap = new EnumMap<LibraryOption, Object>(LibraryOption.class);
    private final TypeMapper.Builder typeMapperBuilder = new TypeMapper.Builder();
    private final FunctionMapper.Builder functionMapperBuilder = new FunctionMapper.Builder();
    private final Class<T> interfaceClass;
    private boolean failImmediately = false;

    public static <T> LibraryLoader<T> create(Class<T> interfaceClass) {
        return FFIProvider.getSystemProvider().createLibraryLoader(interfaceClass);
    }

    protected LibraryLoader(Class<T> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public LibraryLoader<T> library(String libraryName) {
        this.libraryNames.add(libraryName);
        return this;
    }

    public LibraryLoader<T> search(String path) {
        this.searchPaths.add(path);
        return this;
    }

    public LibraryLoader<T> option(LibraryOption option, Object value) {
        switch (option) {
            case TypeMapper: {
                if (value instanceof SignatureTypeMapper) {
                    this.mapper((SignatureTypeMapper)value);
                    break;
                }
                if (value instanceof TypeMapper) {
                    this.mapper((TypeMapper)value);
                    break;
                }
                if (value == null) break;
                throw new IllegalArgumentException("invalid TypeMapper: " + value.getClass());
            }
            case FunctionMapper: {
                this.mapper((FunctionMapper)value);
                break;
            }
            default: {
                this.optionMap.put(option, value);
            }
        }
        return this;
    }

    public LibraryLoader<T> mapper(TypeMapper typeMapper) {
        this.typeMappers.add(new SignatureTypeMapperAdapter(typeMapper));
        return this;
    }

    public LibraryLoader<T> mapper(SignatureTypeMapper typeMapper) {
        this.typeMappers.add(typeMapper);
        return this;
    }

    public <J> LibraryLoader<T> map(Class<? extends J> javaType, ToNativeConverter<? extends J, ?> toNativeConverter) {
        this.typeMapperBuilder.map(javaType, toNativeConverter);
        return this;
    }

    public <J> LibraryLoader<T> map(Class<? extends J> javaType, FromNativeConverter<? extends J, ?> fromNativeConverter) {
        this.typeMapperBuilder.map(javaType, fromNativeConverter);
        return this;
    }

    public <J> LibraryLoader<T> map(Class<? extends J> javaType, DataConverter<? extends J, ?> dataConverter) {
        this.typeMapperBuilder.map(javaType, dataConverter);
        return this;
    }

    public LibraryLoader<T> mapper(FunctionMapper functionMapper) {
        this.functionMappers.add(functionMapper);
        return this;
    }

    public LibraryLoader<T> map(String javaName, String nativeFunction) {
        this.functionMapperBuilder.map(javaName, nativeFunction);
        return this;
    }

    public LibraryLoader<T> convention(CallingConvention convention) {
        this.optionMap.put(LibraryOption.CallingConvention, (Object)convention);
        return this;
    }

    public final LibraryLoader<T> stdcall() {
        return this.convention(CallingConvention.STDCALL);
    }

    public final LibraryLoader<T> failImmediately() {
        this.failImmediately = true;
        return this;
    }

    public T load(String libraryName) {
        return this.library(libraryName).load();
    }

    public T load() {
        if (this.libraryNames.isEmpty()) {
            throw new UnsatisfiedLinkError("no library names specified");
        }
        this.typeMappers.add(0, new SignatureTypeMapperAdapter(this.typeMapperBuilder.build()));
        this.optionMap.put(LibraryOption.TypeMapper, this.typeMappers.size() > 1 ? new CompositeTypeMapper(this.typeMappers) : this.typeMappers.get(0));
        this.functionMappers.add(0, this.functionMapperBuilder.build());
        this.optionMap.put(LibraryOption.FunctionMapper, this.functionMappers.size() > 1 ? new CompositeFunctionMapper(this.functionMappers) : this.functionMappers.get(0));
        try {
            return this.loadLibrary(this.interfaceClass, Collections.unmodifiableList(this.libraryNames), this.getSearchPaths(), Collections.unmodifiableMap(this.optionMap));
        }
        catch (LinkageError error) {
            if (this.failImmediately) {
                throw error;
            }
            return this.createErrorProxy(error);
        }
        catch (Exception ex) {
            RuntimeException re;
            RuntimeException runtimeException = re = ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
            if (this.failImmediately) {
                throw re;
            }
            return this.createErrorProxy(re);
        }
    }

    private T createErrorProxy(final Throwable ex) {
        return this.interfaceClass.cast(Proxy.newProxyInstance(this.interfaceClass.getClassLoader(), new Class[]{this.interfaceClass, LoadedLibrary.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                throw ex;
            }
        }));
    }

    private Collection<String> getSearchPaths() {
        ArrayList<String> paths = new ArrayList<String>(this.searchPaths);
        paths.addAll(StaticDataHolder.USER_LIBRARY_PATH);
        return Collections.unmodifiableList(paths);
    }

    protected abstract T loadLibrary(Class<T> var1, Collection<String> var2, Collection<String> var3, Map<LibraryOption, Object> var4);

    private static List<String> getPropertyPaths(String propName) {
        String value = System.getProperty(propName);
        if (value != null) {
            String[] paths = value.split(File.pathSeparator);
            return new ArrayList<String>(Arrays.asList(paths));
        }
        return Collections.emptyList();
    }

    private static final class StaticDataHolder {
        private static final List<String> USER_LIBRARY_PATH;

        private StaticDataHolder() {
        }

        static {
            ArrayList paths = new ArrayList();
            try {
                paths.addAll(LibraryLoader.getPropertyPaths("jnr.ffi.library.path"));
                paths.addAll(LibraryLoader.getPropertyPaths("jaffl.library.path"));
                paths.addAll(LibraryLoader.getPropertyPaths("jna.library.path"));
                paths.addAll(LibraryLoader.getPropertyPaths("java.library.path"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            USER_LIBRARY_PATH = Collections.unmodifiableList(new ArrayList(paths));
        }
    }
}

