#ifndef _EFL_NETWORK_EO_LEGACY_H_
#define _EFL_NETWORK_EO_LEGACY_H_

#ifndef _EFL_NETWORK_EO_CLASS_TYPE
#define _EFL_NETWORK_EO_CLASS_TYPE

typedef Eo Efl_Network;

#endif

#ifndef _EFL_NETWORK_EO_TYPES
#define _EFL_NETWORK_EO_TYPES

/** Types for an ecore_con client/server object.  A correct way to set this
 * type is with an ECORE_CON_$TYPE, optionally OR'ed with an ECORE_CON_$USE if
 * encryption is desired, and LOAD_CERT if the previously loaded certificate
 * should be used.
 *
 * @ingroup Ecore_Con
 */
typedef enum
{
  ECORE_CON_LOCAL_USER = 0, /** Socket in "~/.ecore" */
  ECORE_CON_LOCAL_SYSTEM = 1, /** Socket in /tmp */
  ECORE_CON_LOCAL_ABSTRACT = 2, /** Abstract socket */
  ECORE_CON_REMOTE_TCP = 3, /** Remote server using TCP */
  ECORE_CON_REMOTE_MCAST = 4, /** Remote multicast server */
  ECORE_CON_REMOTE_UDP = 5, /** Remote server using UDP */
  ECORE_CON_REMOTE_BROADCAST = 6, /** Remote broadcast using UDP */
  ECORE_CON_REMOTE_NODELAY = 7, /** Remote connection sending packets
                                 * immediately */
  ECORE_CON_REMOTE_CORK = 8, /** Remote connection sending data in large chunks
                              * Note: Only available on Linux
                              *
                              * @since 1.2 */
  ECORE_CON_USE_SSL2 = 16 /* 1 << 4 */, /** Use SSL2: UNSUPPORTED. */
  ECORE_CON_USE_SSL3 = 32 /* 1 << 5 */, /** Use SSL3: UNSUPPORTED. */
  ECORE_CON_USE_TLS = 64 /* 1 << 6 */, /** Use TLS */
  ECORE_CON_USE_MIXED = 96 /* Ecore.Con.Type.use_tls | Ecore.Con.Type.use_ssl3 */, /** Use both TLS and SSL3 */
  ECORE_CON_LOAD_CERT = 128 /* 1 << 7 */, /** Attempt to use the loaded
                                           * certificate */
  ECORE_CON_NO_PROXY = 256 /* 1 << 8 */, /** Disable all types of proxy on the
                                          * server Note: Only functional for
                                          * clients
                                          *
                                          * @since 1.2 */
  ECORE_CON_SOCKET_ACTIVATE = 512 /* 1 << 9 */
} Ecore_Con_Type;

typedef struct _Ecore_Con_Event_Data_Received
{
  void *data; /** The data that got sent. */
  int size; /** The length of the data sent. */
} Ecore_Con_Event_Data_Received;


#endif
/** Abstract base class for all EFL.Network classes
 *
 * @ingroup Efl_Network
 */

/**
 * @brief Do an asynchronous DNS lookup.
 *
 * This function performs a DNS lookup on the hostname specified by name, then
 * calls done_cb with the result and the data given as parameter. The result
 * will be given to the done_cb as follows:
 *
 * canonname - the canonical name of the address, ip - the resolved ip address,
 * addr - a pointer to the socket address, addrlen - the length of the socket
 * address, in bytes, data - the data pointer given as parameter.
 *
 * @param[in] name IP address or server name to translate.
 * @param[in] done_cb Callback to notify when done.
 * @param[in] data User data to be given to done_cb.
 *
 * @return true if the request did not fail to be set up, false otherwise.
 *
 * @ingroup Efl_Network
 */
EAPI Eina_Bool ecore_con_lookup(const char *name, Ecore_Con_Dns_Cb done_cb, const void *data) EINA_ARG_NONNULL(2);

#endif
