/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.gradient;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.RadialGradientPaint;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.render.gradient.Function;
import org.apache.fop.render.gradient.Pattern;
import org.apache.fop.render.gradient.Shading;
import org.apache.xmlgraphics.java2d.color.ColorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GradientMaker {
    private GradientMaker() {
    }

    public static Pattern makeLinearGradient(LinearGradientPaint gp, AffineTransform baseTransform, AffineTransform transform) {
        Point2D startPoint = gp.getStartPoint();
        Point2D endPoint = gp.getEndPoint();
        ArrayList<Double> coords = new ArrayList<Double>(4);
        coords.add(startPoint.getX());
        coords.add(startPoint.getY());
        coords.add(endPoint.getX());
        coords.add(endPoint.getY());
        return GradientMaker.makeGradient((MultipleGradientPaint)gp, coords, baseTransform, transform);
    }

    public static Pattern makeRadialGradient(RadialGradientPaint gradient, AffineTransform baseTransform, AffineTransform transform) {
        double dy;
        double radius = gradient.getRadius();
        Point2D center = gradient.getCenterPoint();
        Point2D focus = gradient.getFocusPoint();
        double dx = focus.getX() - center.getX();
        double d = Math.sqrt(dx * dx + (dy = focus.getY() - center.getY()) * dy);
        if (d > radius) {
            double scale = radius * 0.9999 / d;
            dx *= scale;
            dy *= scale;
        }
        ArrayList<Double> coords = new ArrayList<Double>(6);
        coords.add(center.getX() + dx);
        coords.add(center.getY() + dy);
        coords.add(0.0);
        coords.add(center.getX());
        coords.add(center.getY());
        coords.add(radius);
        return GradientMaker.makeGradient((MultipleGradientPaint)gradient, coords, baseTransform, transform);
    }

    private static Pattern makeGradient(MultipleGradientPaint gradient, List<Double> coords, AffineTransform baseTransform, AffineTransform transform) {
        List<Double> matrix = GradientMaker.makeTransform(gradient, baseTransform, transform);
        List<Float> bounds = GradientMaker.makeBounds(gradient);
        List<Function> functions = GradientMaker.makeFunctions(gradient);
        PDFDeviceColorSpace colorSpace = new PDFDeviceColorSpace(2);
        Function function = new Function(null, null, functions, bounds, null);
        int shadingType = gradient instanceof LinearGradientPaint ? 2 : 3;
        Shading shading = new Shading(shadingType, colorSpace, coords, function);
        return new Pattern(2, shading, matrix);
    }

    private static List<Double> makeTransform(MultipleGradientPaint gradient, AffineTransform baseTransform, AffineTransform transform) {
        AffineTransform gradientTransform = new AffineTransform(baseTransform);
        gradientTransform.concatenate(transform);
        gradientTransform.concatenate(gradient.getTransform());
        ArrayList<Double> matrix = new ArrayList<Double>(6);
        double[] m = new double[6];
        gradientTransform.getMatrix(m);
        for (double d : m) {
            matrix.add(d);
        }
        return matrix;
    }

    private static Color getsRGBColor(Color c) {
        return c.getColorSpace().isCS_sRGB() ? c : ColorUtil.toSRGBColor((Color)c);
    }

    private static List<Float> makeBounds(MultipleGradientPaint gradient) {
        float[] fractions = gradient.getFractions();
        ArrayList<Float> bounds = new ArrayList<Float>(fractions.length);
        for (float offset : fractions) {
            if (!(0.0f < offset) || !(offset < 1.0f)) continue;
            bounds.add(Float.valueOf(offset));
        }
        return bounds;
    }

    private static List<Function> makeFunctions(MultipleGradientPaint gradient) {
        List<Color> colors = GradientMaker.makeColors(gradient);
        ArrayList<Function> functions = new ArrayList<Function>();
        int lastPosition = colors.size() - 1;
        for (int currentPosition = 0; currentPosition < lastPosition; ++currentPosition) {
            Color currentColor = colors.get(currentPosition);
            Color nextColor = colors.get(currentPosition + 1);
            float[] c0 = currentColor.getColorComponents(null);
            float[] c1 = nextColor.getColorComponents(null);
            Function function = new Function(null, null, c0, c1, 1.0);
            functions.add(function);
        }
        return functions;
    }

    private static List<Color> makeColors(MultipleGradientPaint gradient) {
        Color[] svgColors = gradient.getColors();
        ArrayList<Color> gradientColors = new ArrayList<Color>(svgColors.length + 2);
        float[] fractions = gradient.getFractions();
        if (fractions[0] > 0.0f) {
            gradientColors.add(GradientMaker.getsRGBColor(svgColors[0]));
        }
        for (Color c : svgColors) {
            gradientColors.add(GradientMaker.getsRGBColor(c));
        }
        if (fractions[fractions.length - 1] < 1.0f) {
            gradientColors.add(GradientMaker.getsRGBColor(svgColors[svgColors.length - 1]));
        }
        return gradientColors;
    }

    static void outputDoubles(StringBuilder out, DoubleFormatter doubleFormatter, List<? extends Number> numbers) {
        out.append("[ ");
        for (Number number : numbers) {
            out.append(doubleFormatter.formatDouble(number.doubleValue()));
            out.append(" ");
        }
        out.append("]");
    }

    public static interface DoubleFormatter {
        public String formatDouble(double var1);
    }
}

