/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.LicenseString;
import common.MidiEventComparator;
import common.MidiTrackEvent;
import common.Util;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.sound.midi.Instrument;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;

public class Midi
implements LicenseString {
    private Sequencer sequencer;
    protected Sequence sequence;
    Synthesizer synthesizer;
    Instrument[] instruments;
    int channel = 0;
    ShortMessage msg;
    int tick;
    int count;
    static MidiDevice.Info[] allMidiDevices = null;
    int currentDeviceIndex;
    Transmitter transmitter;
    MidiDevice currentDevice;
    private List eventList;
    Receiver currentReceiver;
    Track track;
    double ppq;
    double tempo;
    boolean deviceAlreadyOpened;
    boolean playing;
    public int DELTA = 1;
    public final int VELOCITY_ON = 100;
    public final int VELOCITY_OFF = 0;
    private static final boolean testing = false;
    private static int[] midiCommandsStatus = new int[]{254, 208, 251, 176, 247, 241, 128, 144, 224, 160, 192, 242, 243, 250, 252, 255, 248, 246};
    private static String[] midiCommandsStatusStrings = new String[]{"ACTIVE_SENSING", "CHANNEL_PRESSURE", "CONTINUE", "CONTROL_CHANGE", "END_OF_EXCLUSIVE", "MIDI_TIME_CODE", "NOTE_OFF", "NOTE_ON", "PITCH_BEND", "POLY_PRESSURE", "PROGRAM_CHANGE", "SONG_POSITION_POINTER", "SONG_SELECT", "START", "STOP", "SYSTEM_RESET", "TIMING_CLOCK", "TUNE_REQUEST"};
    private String errorMsg = null;
    private String doesNotHaveAnyReceivers;

    public String getLicenseString() {
        return "This file is covered by the GNU GENERAL PUBLIC LICENSE, Version 2, June 1991";
    }

    public Midi(String msgDoesNotHaveAnyReceivers) {
        this.doesNotHaveAnyReceivers = msgDoesNotHaveAnyReceivers;
        this.playing = false;
        this.tick = 0;
        this.currentDevice = null;
        this.currentDeviceIndex = -1;
        this.currentReceiver = null;
        this.ppq = 0.0;
        this.eventList = null;
        this.transmitter = null;
        this.getMidiDevices();
    }

    public int getCurrentDeviceIndex() {
        return this.currentDeviceIndex;
    }

    public MidiDevice getCurrentDevice() {
        return this.currentDevice;
    }

    public boolean isValidDeviceIndex(int i) {
        boolean resp = false;
        if (allMidiDevices != null) {
            resp = i >= 0 && i < allMidiDevices.length;
        }
        return resp;
    }

    public boolean setCurrentDevice(int i, String msgDoesNotHaveAnyReceivers) {
        boolean resp = false;
        if (this.isValidDeviceIndex(i)) {
            try {
                String deviceName = allMidiDevices[i].getName();
                MidiDevice testDevice = MidiSystem.getMidiDevice(allMidiDevices[i]);
                int numReceivers = testDevice.getMaxReceivers();
                if (numReceivers != 0) {
                    this.currentDevice = testDevice;
                    this.currentDeviceIndex = i;
                    this.currentReceiver = this.currentDevice.getReceiver();
                    resp = true;
                } else {
                    this.errorMsg = "Midi Device:" + deviceName + " ";
                    this.errorMsg = msgDoesNotHaveAnyReceivers != null ? String.valueOf(this.errorMsg) + msgDoesNotHaveAnyReceivers : String.valueOf(this.errorMsg) + "does not have any receivers, try with a different one";
                    this.errorMsg = String.valueOf(this.errorMsg) + ": 0 -" + allMidiDevices.length;
                }
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
            }
        }
        return resp;
    }

    public int getNumberOfMidiDevices() {
        if (allMidiDevices == null) {
            allMidiDevices = MidiSystem.getMidiDeviceInfo();
        }
        return allMidiDevices.length;
    }

    public MidiDevice.Info[] getMidiDevices() {
        if (allMidiDevices == null) {
            allMidiDevices = MidiSystem.getMidiDeviceInfo();
        }
        return allMidiDevices;
    }

    public boolean play() {
        boolean success = false;
        success = this.standardPlay();
        return success;
    }

    private boolean openSequencer() {
        boolean success = false;
        try {
            if (this.sequencer == null) {
                this.sequencer = MidiSystem.getSequencer();
            }
            if (this.sequencer == null) {
                System.err.println("getSequencer() failed!");
                success = false;
            } else if (!this.sequencer.isOpen()) {
                this.sequencer.open();
                success = true;
            }
        }
        catch (MidiUnavailableException MUE) {
            MUE.printStackTrace();
        }
        return success;
    }

    public void prepareToPlay() {
        this.openSequencer();
        this.openSynthesizer();
        if (this.transmitter == null) {
            try {
                this.transmitter = this.sequencer.getTransmitter();
                this.transmitter.setReceiver(this.synthesizer.getReceiver());
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean standardPlay() {
        boolean success = true;
        try {
            this.prepareToPlay();
            this.sequencer.setSequence(this.sequence);
            this.sequencer.start();
            this.playing = true;
            while (this.sequencer.isRunning()) {
            }
            this.playing = false;
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            success = false;
        }
        return success;
    }

    private boolean developmentPlay() {
        boolean success = false;
        if (this.currentDevice == null) {
            this.setCurrentDevice(0, this.doesNotHaveAnyReceivers);
        }
        if (this.currentReceiver != null) {
            if (this.ppq == 0.0) {
                this.ppq = 16.0;
            }
            this.deviceAlreadyOpened = this.currentDevice.isOpen();
            if (!this.deviceAlreadyOpened) {
                try {
                    this.currentDevice.open();
                }
                catch (MidiUnavailableException e1) {
                    e1.printStackTrace();
                }
            }
            this.playing = true;
            this.tempo = 120.0;
            double millisecondsPerPulse = 60000.0 / (this.tempo * this.ppq);
            Iterator it = this.eventList.iterator();
            long startTime = System.currentTimeMillis();
            while (this.playing && it.hasNext()) {
                MidiEvent e = (MidiEvent)it.next();
                long eventClick = e.getTick();
                long eventOffset = (long)((double)eventClick * millisecondsPerPulse);
                long currentTime = System.currentTimeMillis() - startTime;
                if (currentTime < eventOffset) {
                    try {
                        Thread.sleep(eventOffset - currentTime);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                try {
                    this.currentReceiver.send(e.getMessage(), -1L);
                }
                catch (IllegalStateException ISE) {
                    Util.showDialogOk(null, "IllegalStateException", ISE.getLocalizedMessage());
                    this.playing = false;
                }
            }
            success = true;
            this.stop();
        } else {
            System.err.println("current Devices is null");
        }
        return success;
    }

    public void stop() {
        if (this.sequencer != null && this.sequencer.isRunning()) {
            this.sequencer.stop();
        }
    }

    private boolean openSynthesizer() {
        boolean success = false;
        try {
            if (this.synthesizer == null) {
                this.synthesizer = MidiSystem.getSynthesizer();
            }
            if (this.synthesizer == null) {
                System.err.println("getSynthesizer() failed!");
                success = false;
            } else if (!this.synthesizer.isOpen()) {
                this.synthesizer.open();
            }
        }
        catch (MidiUnavailableException MUE) {
            MUE.printStackTrace();
        }
        return success;
    }

    private boolean loadInstruments() {
        boolean success = false;
        this.openSynthesizer();
        Soundbank sb = this.synthesizer.getDefaultSoundbank();
        if (sb != null) {
            this.instruments = this.synthesizer.getDefaultSoundbank().getInstruments();
            success = this.synthesizer.loadInstrument(this.instruments[23]);
            if (!success) {
                System.err.println("loadInstrument() failed!");
                return success;
            }
        }
        this.synthesizer.close();
        return success;
    }

    public String[] getInstrumentStrings() {
        String[] res = null;
        if (this.instruments == null) {
            this.loadInstruments();
        }
        if (this.instruments != null) {
            int max = this.instruments.length;
            res = new String[max];
            int i = 0;
            while (i < this.instruments.length) {
                String aux = this.instruments[i].toString();
                int pos = aux.indexOf("Instrument");
                res[i] = new String(aux.substring(pos + "Instrument".length()));
                ++i;
            }
        }
        return res;
    }

    public boolean setSequencePPQ(int value) {
        boolean success = false;
        if (value > 0) {
            try {
                this.sequence = new Sequence(0.0f, 16, 1);
                success = true;
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        }
        return success;
    }

    public boolean setInstrument(int instrumentNumber) {
        boolean success = true;
        this.tick = 0;
        if (this.sequence == null) {
            System.err.println("Sequence is null, make sure you call setSequencePPQ or loadMID");
        } else {
            try {
                this.msg = new ShortMessage();
                this.channel = instrumentNumber / 128;
                int inst = instrumentNumber % 128;
                this.msg.setMessage(192, this.channel, inst, 0);
                MidiEvent event = new MidiEvent(this.msg, 0L);
                this.track = this.sequence.createTrack();
                this.track.add(event);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
                success = false;
            }
        }
        return success;
    }

    public boolean addNote(int note) {
        boolean success = true;
        try {
            this.msg = new ShortMessage();
            this.msg.setMessage(144, this.channel, note, 100);
            MidiEvent event = new MidiEvent(this.msg, this.tick);
            this.track.add(event);
            this.msg = new ShortMessage();
            this.msg.setMessage(128, this.channel, note, 0);
            event = new MidiEvent(this.msg, this.tick + this.DELTA);
            this.track.add(event);
            this.tick += this.DELTA;
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            success = false;
        }
        return success;
    }

    public boolean loadMID(String song) {
        boolean success = false;
        try {
            File myMidiFile = new File(song);
            MidiFileFormat mff = MidiSystem.getMidiFileFormat(myMidiFile);
            this.ppq = mff.getResolution();
            this.sequence = MidiSystem.getSequence(myMidiFile);
            this.prepare();
            success = true;
        }
        catch (IOException IOE) {
            IOE.printStackTrace();
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
        return success;
    }

    public boolean selectFirstAvailableMidiDevice() {
        int j = 0;
        boolean success = false;
        while (!success && j < this.getNumberOfMidiDevices()) {
            success = this.setCurrentDevice(j, this.doesNotHaveAnyReceivers);
            ++j;
        }
        return success;
    }

    public int nextDeviceIndex(int i) {
        int j = i + 1;
        if (j >= this.getNumberOfMidiDevices()) {
            j = 0;
        }
        return j;
    }

    public boolean selectNextAvailableMidiDevice() {
        int orig = this.currentDeviceIndex;
        int j = this.nextDeviceIndex(this.currentDeviceIndex);
        boolean success = false;
        while (!success && j != orig) {
            success = this.setCurrentDevice(j, this.doesNotHaveAnyReceivers);
            if (success) continue;
            j = this.nextDeviceIndex(j);
        }
        return success;
    }

    public String getCurrentDeviceName() {
        return this.getCurrentDevice().getDeviceInfo().getName();
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String deviceMessage(String midiDevice, String isNowPreferredMidi) {
        String res = midiDevice != null ? midiDevice : "Midi Device";
        res = String.valueOf(res) + ":" + this.getCurrentDeviceName() + " ";
        res = isNowPreferredMidi != null ? String.valueOf(res) + isNowPreferredMidi : String.valueOf(res) + "is now the preferred device";
        return res;
    }

    private void prepare() {
        Track[] tracks = this.sequence.getTracks();
        int sizeNeeded = 0;
        int t = 0;
        while (t < tracks.length) {
            sizeNeeded += tracks[t].size();
            ++t;
        }
        this.eventList = new ArrayList(sizeNeeded);
        t = 0;
        while (t < tracks.length) {
            Track trackAux = tracks[t];
            int size = trackAux.size();
            int j = 0;
            while (j < size) {
                MidiEvent e = trackAux.get(j);
                this.eventList.add(e);
                ++j;
            }
            ++t;
        }
        Collections.sort(this.eventList, new MidiEventComparator());
    }

    private static String CommandStatusToString(int value) {
        String res = "UNKNOWN (" + value + ")";
        boolean match = false;
        int i = 0;
        while (!match && i < midiCommandsStatus.length) {
            boolean bl = match = value == midiCommandsStatus[i];
            if (match) {
                res = String.valueOf(midiCommandsStatusStrings[i]) + "(" + value + ")";
            }
            ++i;
        }
        return res;
    }

    public static int convert(byte b) {
        return b & 0xFF;
    }

    private static int midiMessageLength(int status) {
        switch (status & 0xF0) {
            case 192: 
            case 208: {
                return 2;
            }
            case 240: {
                if (status == 243) {
                    return 2;
                }
                if (status < 246) break;
                return 1;
            }
        }
        return 3;
    }

    private static String MidiMessageToString(MidiMessage MM) {
        byte[] msg;
        int length;
        int status = MM.getStatus();
        if (MM instanceof ShortMessage) {
            ShortMessage sm = (ShortMessage)MM;
            length = Midi.midiMessageLength(status);
            msg = new byte[3];
            msg[0] = (byte)status;
            if (length > 1) {
                msg[1] = (byte)sm.getData1();
            }
            if (length > 2) {
                msg[2] = (byte)sm.getData2();
            }
        } else {
            msg = MM.getMessage();
            length = MM.getLength();
        }
        String res = "";
        if (status == 255) {
            res = String.valueOf(res) + "Meta message = {";
            int i = 0;
            while (i < length) {
                res = String.valueOf(res) + Midi.convert(msg[i]);
                if (i < length - 1) {
                    res = String.valueOf(res) + ",";
                }
                ++i;
            }
            res = String.valueOf(res) + " }";
        } else if (length == 1) {
            res = String.valueOf(res) + "System Real-Time message = { ";
            res = String.valueOf(res) + Midi.CommandStatusToString(status);
            res = String.valueOf(res) + " }";
        } else if (length == 2 || length == 3) {
            res = String.valueOf(res) + "Channel Message = { ";
            int cmd = status & 0xF0;
            res = String.valueOf(res) + "Command: " + Midi.CommandStatusToString(cmd);
            int chn = status & 0xF;
            res = String.valueOf(res) + ", Channel: " + chn;
            int data1 = Midi.convert(msg[1]);
            int data2 = -1;
            if (length == 3) {
                data2 = Midi.convert(msg[2]);
            }
            if (cmd == 144 || cmd == 128) {
                res = String.valueOf(res) + ", Note: " + data1;
                res = String.valueOf(res) + ", Velocity: " + data2;
            } else {
                res = String.valueOf(res) + ", Data1: " + data1;
                if (length == 3) {
                    res = String.valueOf(res) + ", Data2: " + data2;
                }
            }
            res = String.valueOf(res) + " }";
        } else {
            res = String.valueOf(res) + "Meta message = {";
            int i = 0;
            while (i < length) {
                res = String.valueOf(res) + Midi.convert(msg[i]);
                if (i < length - 1) {
                    res = String.valueOf(res) + ",";
                }
                ++i;
            }
            res = String.valueOf(res) + " }";
        }
        return res;
    }

    public static String MidiEventToString(MidiEvent ME) {
        String res = "";
        res = String.valueOf(res) + "Tick: " + ME.getTick();
        MidiMessage MM = ME.getMessage();
        res = String.valueOf(res) + ", " + Midi.MidiMessageToString(MM);
        return res;
    }

    public Vector SequenceToMidiTrackEvents() {
        Vector<MidiTrackEvent> V = new Vector<MidiTrackEvent>(0, 1);
        Track[] tracks = this.sequence.getTracks();
        int maxEvents = 0;
        int t = 0;
        while (t < tracks.length) {
            maxEvents = Math.max(maxEvents, tracks[t].size());
            ++t;
        }
        int e = 0;
        while (e < maxEvents) {
            t = 0;
            while (t < tracks.length) {
                if (e < tracks[t].size()) {
                    MidiEvent ME = tracks[t].get(e);
                    MidiTrackEvent MTE = new MidiTrackEvent(t, e, ME);
                    V.add(MTE);
                }
                ++t;
            }
            ++e;
        }
        return V;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    class timerListener
    implements ActionListener {
        long eventClick;
        MidiEvent ME;
        boolean processed = true;
        long currentTime = 0L;
        Iterator it;
        long eventTime;
        double millisecondsPerPulse;
        int delay;

        public timerListener(List eventList, double MSPP, int Delay) {
            this.it = eventList.iterator();
            this.millisecondsPerPulse = MSPP;
            this.delay = Delay;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.it.hasNext()) {
                if (this.processed) {
                    this.ME = (MidiEvent)this.it.next();
                    this.eventClick = this.ME.getTick();
                    this.eventTime = (long)((double)this.eventClick * this.millisecondsPerPulse);
                }
                if (this.eventTime <= this.currentTime) {
                    Midi.this.currentReceiver.send(this.ME.getMessage(), -1L);
                    this.processed = true;
                } else {
                    this.processed = false;
                }
                this.currentTime += (long)this.delay;
            }
        }
    }
}

