/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPEventProducer;
import org.apache.fop.afp.fonts.AbstractOutlineFont;
import org.apache.fop.afp.fonts.CharacterSet;

public class DoubleByteFont
extends AbstractOutlineFont {
    private static final Log log = LogFactory.getLog(DoubleByteFont.class);
    private final Set<Integer> charsProcessed = new HashSet<Integer>();
    private static final Set<Character.UnicodeBlock> IDEOGRAPHIC = new HashSet<Character.UnicodeBlock>();

    public DoubleByteFont(String name, boolean embeddable, CharacterSet charSet, AFPEventProducer eventProducer) {
        super(name, embeddable, charSet, eventProducer);
    }

    public int getWidth(int character, int size) {
        int charWidth;
        try {
            charWidth = this.charSet.getWidth(DoubleByteFont.toUnicodeCodepoint(character), size);
        }
        catch (IllegalArgumentException e) {
            if (!this.charsProcessed.contains(character)) {
                this.charsProcessed.add(character);
                this.getAFPEventProducer().charactersetMissingMetrics(this, (char)character, this.charSet.getName().trim());
            }
            charWidth = -1;
        }
        if (charWidth == -1) {
            charWidth = this.getDefaultCharacterWidth(character) * size;
        }
        return charWidth;
    }

    private int getDefaultCharacterWidth(int character) {
        int nominalCharIncrement = this.charSet.getNominalCharIncrement();
        if (nominalCharIncrement > 0) {
            return nominalCharIncrement;
        }
        return this.inferCharWidth(character);
    }

    public Rectangle getBoundingBox(int character, int size) {
        Rectangle characterBox = this.getBoundingBoxOrNull(character, size);
        if (characterBox == null) {
            characterBox = this.getDefaultCharacterBox(character, size);
        }
        return characterBox;
    }

    private Rectangle getBoundingBoxOrNull(int character, int size) {
        Rectangle characterBox;
        block2: {
            characterBox = null;
            try {
                characterBox = this.charSet.getCharacterBox(DoubleByteFont.toUnicodeCodepoint(character), size);
            }
            catch (IllegalArgumentException e) {
                if (this.charsProcessed.contains(character)) break block2;
                this.charsProcessed.add(character);
                this.getAFPEventProducer().charactersetMissingMetrics(this, (char)character, this.charSet.getName().trim());
            }
        }
        return characterBox;
    }

    private Rectangle getDefaultCharacterBox(int character, int size) {
        return this.getBoundingBoxOrNull(45, size);
    }

    private int inferCharWidth(int character) {
        boolean isIdeographic = false;
        Character.UnicodeBlock charBlock = Character.UnicodeBlock.of((char)character);
        isIdeographic = charBlock == null ? false : IDEOGRAPHIC.contains(charBlock);
        if (isIdeographic) {
            return this.charSet.getEmSpaceIncrement();
        }
        return this.charSet.getSpaceIncrement();
    }

    static {
        IDEOGRAPHIC.add(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS);
        IDEOGRAPHIC.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS);
        IDEOGRAPHIC.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A);
    }
}

