/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.LinkAdapter;
import freemind.modes.MindMapLink;
import freemind.modes.MindMapNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Vector;
import java.util.logging.Logger;

public class MindMapLinkRegistry {
    protected HashMap mSourceToLinks = new HashMap();
    protected HashMap mTargetToId;
    protected HashMap mIdToTarget;
    protected HashMap mIdToLinks;
    protected HashMap mIdToLink;
    protected HashSet mLocallyLinkedIds;
    protected static Logger logger = null;

    public MindMapLinkRegistry() {
        if (logger == null) {
            logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
        this.mTargetToId = new HashMap();
        this.mIdToTarget = new HashMap();
        this.mIdToLinks = new HashMap();
        this.mIdToLink = new HashMap();
        this.mLocallyLinkedIds = new HashSet();
    }

    public String generateUniqueID(String proposedID) {
        return Tools.generateID(proposedID, this.mIdToLinks, "ID_");
    }

    public String generateUniqueLinkId(String proposedID) {
        return Tools.generateID(proposedID, this.mIdToLink, "Arrow_ID_");
    }

    public String registerLinkTarget(MindMapNode pTarget) {
        return this._registerLinkTarget(pTarget);
    }

    public String registerLinkTarget(MindMapNode pTarget, String pProposedID) {
        return this._registerLinkTarget(pTarget, pProposedID);
    }

    public String _registerLinkTarget(MindMapNode target) {
        return this._registerLinkTarget(target, null);
    }

    public String _registerLinkTarget(MindMapNode target, String proposedID) {
        String id;
        if (this.mTargetToId.containsKey(target) && (id = (String)this.mTargetToId.get(target)) != null) {
            return id;
        }
        String newId = this.generateUniqueID(proposedID);
        this.mTargetToId.put(target, newId);
        this.mIdToTarget.put(newId, target);
        this.getAssignedLinksVector(newId);
        return newId;
    }

    public String getState(MindMapNode node) {
        if (this.mTargetToId.containsKey(node)) {
            return (String)this.mTargetToId.get(node);
        }
        return null;
    }

    public MindMapNode getTargetForId(String ID) {
        Object target = this.mIdToTarget.get(ID);
        return (MindMapNode)target;
    }

    private Vector getAssignedLinksVector(String newId) {
        Vector vec;
        String id = newId;
        if (this.mIdToLinks.containsKey(id)) {
            vec = (Vector)this.mIdToLinks.get(id);
        } else {
            vec = new SynchronousVector();
            this.mIdToLinks.put(id, vec);
        }
        return vec;
    }

    public void deregisterLinkTarget(MindMapNode target) throws IllegalArgumentException {
        Vector links = this.getAllLinks(target);
        for (int i = links.size() - 1; i >= 0; --i) {
            MindMapLink link = (MindMapLink)links.get(i);
            this.deregisterLink(link);
        }
        ListIterator e = target.childrenUnfolded();
        while (e.hasNext()) {
            MindMapNode child = (MindMapNode)e.next();
            this.deregisterLinkTarget(child);
        }
        String id = this.getState(target);
        if (id != null) {
            this.mTargetToId.remove(target);
            this.mIdToTarget.remove(id);
            this.mIdToLinks.remove(id);
        }
    }

    public void registerLink(MindMapLink link) throws IllegalArgumentException {
        if (link.getSource() == null || link.getTarget() == null || link.getDestinationLabel() == null) {
            throw new IllegalArgumentException("Illegal link specification." + link);
        }
        MindMapNode source = link.getSource();
        MindMapNode target = link.getTarget();
        logger.fine("Register link (" + link + ") from source node:" + source + " to target " + target);
        String id = this._registerLinkTarget(target);
        Vector vec = this.getAssignedLinksVector(id);
        for (int i = 0; i < vec.size(); ++i) {
            if (vec.get(i) != link) continue;
            return;
        }
        vec.add(link);
        String uniqueId = link.getUniqueId();
        if (uniqueId == null) {
            ((LinkAdapter)link).setUniqueId(this.generateUniqueLinkId(uniqueId));
            uniqueId = link.getUniqueId();
        }
        if (this.mIdToLink.containsKey(uniqueId) && this.mIdToLink.get(uniqueId) != link) {
            logger.warning("link with duplicated unique id found:" + link);
            ((LinkAdapter)link).setUniqueId(this.generateUniqueLinkId(uniqueId));
        }
        this.mIdToLink.put(link.getUniqueId(), link);
    }

    public void deregisterLink(MindMapLink link) {
        MindMapNode target = link.getTarget();
        String id = this._registerLinkTarget(target);
        Vector vec = this.getAssignedLinksVector(id);
        for (int i = vec.size() - 1; i >= 0; --i) {
            if (vec.get(i) != link) continue;
            vec.removeElementAt(i);
            logger.info("Deregister link  (" + link + ") from source node:" + link.getSource() + " to target " + target);
        }
        this.mIdToLink.remove(link.getUniqueId());
    }

    public MindMapLink getLinkForId(String pId) {
        if (this.mIdToLink.containsKey(pId)) {
            return (MindMapLink)this.mIdToLink.get(pId);
        }
        return null;
    }

    public Vector getAllSources(MindMapNode target) {
        Vector<MindMapNode> returnValue = new Vector<MindMapNode>();
        String id = this.getState(target);
        if (id != null) {
            Vector vec = this.getAssignedLinksVector(id);
            for (int i = 0; i < vec.size(); ++i) {
                returnValue.add(((MindMapLink)vec.get(i)).getSource());
            }
        }
        return returnValue;
    }

    public Vector getAllLinks(MindMapNode node) {
        Vector returnValue = new Vector();
        returnValue.addAll(this.getAllLinksIntoMe(node));
        returnValue.addAll(this.getAllLinksFromMe(node));
        return returnValue;
    }

    public Vector getAllLinksIntoMe(MindMapNode target) {
        Vector returnValue = new Vector();
        String id = this.getState(target);
        if (id != null) {
            Vector vec = this.getAssignedLinksVector(id);
            returnValue.addAll(vec);
        }
        return returnValue;
    }

    public Vector getAllLinksFromMe(MindMapNode source) {
        Vector returnValue = new Vector();
        Collection vec = (Collection)this.mSourceToLinks.get(source);
        if (vec != null) {
            returnValue.addAll(vec);
        }
        return returnValue;
    }

    public String getLabel(MindMapNode target) {
        return this.getState(target);
    }

    public void registerLocalHyperlinkId(String pTargetId) {
        this.mLocallyLinkedIds.add(pTargetId);
    }

    public boolean isTargetOfLocalHyperlinks(String pTargetId) {
        return this.mLocallyLinkedIds.contains(pTargetId);
    }

    private class SynchronousVector
    extends Vector {
        private SynchronousVector() {
        }

        @Override
        public synchronized boolean add(Object pE) {
            boolean add = super.add(pE);
            if (pE instanceof MindMapLink) {
                MindMapLink link = (MindMapLink)pE;
                MindMapNode source = link.getSource();
                if (!MindMapLinkRegistry.this.mSourceToLinks.containsKey(source)) {
                    MindMapLinkRegistry.this.mSourceToLinks.put(source, new Vector());
                }
                ((Vector)MindMapLinkRegistry.this.mSourceToLinks.get(source)).add(pE);
            }
            return add;
        }

        @Override
        public synchronized void removeElementAt(int pIndex) {
            MindMapLink link = (MindMapLink)this.get(pIndex);
            MindMapNode source = link.getSource();
            Vector vector = (Vector)MindMapLinkRegistry.this.mSourceToLinks.get(source);
            if (vector != null) {
                vector.remove(link);
                if (vector.isEmpty()) {
                    MindMapLinkRegistry.this.mSourceToLinks.remove(source);
                }
            }
            super.removeElementAt(pIndex);
        }
    }
}

