/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.util.GLBuffers;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.GLPixelStorageModes;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;
import javax.media.opengl.GL;
import javax.media.opengl.GL2ES3;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;

public class GLReadBufferUtil {
    protected final GLPixelBuffer.GLPixelBufferProvider pixelBufferProvider;
    protected final int componentCount;
    protected final int alignment;
    protected final Texture readTexture;
    protected final GLPixelStorageModes psm;
    protected GLPixelBuffer readPixelBuffer = null;
    protected TextureData readTextureData = null;

    public GLReadBufferUtil(boolean bl, boolean bl2) {
        this(GLPixelBuffer.defaultProviderNoRowStride, bl, bl2);
    }

    public GLReadBufferUtil(GLPixelBuffer.GLPixelBufferProvider gLPixelBufferProvider, boolean bl, boolean bl2) {
        this.pixelBufferProvider = gLPixelBufferProvider;
        this.componentCount = bl ? 4 : 3;
        this.alignment = bl ? 4 : 1;
        this.readTexture = bl2 ? new Texture(3553) : null;
        this.psm = new GLPixelStorageModes();
    }

    public GLPixelBuffer.GLPixelBufferProvider getPixelBufferProvider() {
        return this.pixelBufferProvider;
    }

    public boolean isValid() {
        return null != this.readTextureData && null != this.readPixelBuffer && this.readPixelBuffer.isValid();
    }

    public boolean hasAlpha() {
        return 4 == this.componentCount;
    }

    public GLPixelStorageModes getGLPixelStorageModes() {
        return this.psm;
    }

    public GLPixelBuffer getPixelBuffer() {
        return this.readPixelBuffer;
    }

    public void rewindPixelBuffer() {
        if (null != this.readPixelBuffer) {
            this.readPixelBuffer.rewind();
        }
    }

    public TextureData getTextureData() {
        return this.readTextureData;
    }

    public Texture getTexture() {
        return this.readTexture;
    }

    public void write(File file) {
        try {
            TextureIO.write(this.readTextureData, file);
            this.rewindPixelBuffer();
        }
        catch (IOException iOException) {
            throw new RuntimeException("can not write to file: " + file.getAbsolutePath(), iOException);
        }
    }

    public boolean readPixels(GL gL, boolean bl) {
        return this.readPixels(gL, 0, 0, 0, 0, bl);
    }

    public boolean readPixels(GL gL, int n, int n2, int n3, int n4, boolean bl) {
        GLDrawable gLDrawable = gL.getContext().getGLReadDrawable();
        int n5 = 0 >= n3 || gLDrawable.getWidth() < n3 ? gLDrawable.getWidth() : n3;
        int n6 = 0 >= n4 || gLDrawable.getHeight() < n4 ? gLDrawable.getHeight() : n4;
        return this.readPixelsImpl(gLDrawable, gL, n, n2, n5, n6, bl);
    }

    protected boolean readPixelsImpl(GLDrawable gLDrawable, GL gL, int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2;
        int n5;
        int n6 = gL.glGetError();
        if (0 != n6) {
            System.err.println("Info: GLReadBufferUtil.readPixels: pre-exisiting GL error 0x" + Integer.toHexString(n6));
        }
        GLPixelBuffer.GLPixelAttributes gLPixelAttributes = this.pixelBufferProvider.getAttributes(gL, this.componentCount);
        if (gL.isGL2GL3() && 3 == this.componentCount) {
            n5 = 6407;
        } else {
            int n7 = n5 = 4 == this.componentCount ? 6408 : 6407;
        }
        boolean bl3 = gLDrawable.isGLOriented() ? bl : !bl;
        int[] nArray = new int[1];
        int n8 = GLBuffers.sizeof(gL, nArray, gLPixelAttributes.bytesPerPixel, n3, n4, 1, true);
        boolean bl4 = false;
        if (null == this.readPixelBuffer || this.readPixelBuffer.requiresNewBuffer(gL, n3, n4, n8)) {
            this.readPixelBuffer = this.pixelBufferProvider.allocate(gL, gLPixelAttributes, n3, n4, 1, true, n8);
            Buffers.rangeCheckBytes((Object)this.readPixelBuffer.buffer, (int)n8);
            try {
                this.readTextureData = new TextureData(gL.getGLProfile(), n5, n3, n4, 0, gLPixelAttributes, false, false, bl3, this.readPixelBuffer.buffer, null);
                bl4 = true;
            }
            catch (Exception exception) {
                this.readTextureData = null;
                this.readPixelBuffer = null;
                throw new RuntimeException("can not fetch offscreen texture", exception);
            }
        } else {
            this.readTextureData.setInternalFormat(n5);
            this.readTextureData.setWidth(n3);
            this.readTextureData.setHeight(n4);
            this.readTextureData.setPixelAttributes(gLPixelAttributes);
        }
        boolean bl5 = bl2 = null != this.readPixelBuffer && this.readPixelBuffer.isValid();
        if (bl2) {
            this.psm.setAlignment(gL, this.alignment, this.alignment);
            if (gL.isGL2ES3()) {
                GL2ES3 gL2ES3 = gL.getGL2ES3();
                gL2ES3.glPixelStorei(3330, n3);
                gL2ES3.glReadBuffer(gL2ES3.getDefaultReadBuffer());
            }
            this.readPixelBuffer.clear();
            try {
                gL.glReadPixels(n, n2, n3, n4, gLPixelAttributes.format, gLPixelAttributes.type, this.readPixelBuffer.buffer);
            }
            catch (GLException gLException) {
                bl2 = false;
                gLException.printStackTrace();
            }
            this.readPixelBuffer.position(n8);
            this.readPixelBuffer.flip();
            int n9 = gL.glGetError();
            if (0 != n9) {
                System.err.println("GLReadBufferUtil.readPixels: readPixels error 0x" + Integer.toHexString(n9) + " " + n3 + "x" + n4 + ", " + gLPixelAttributes + ", " + this.readPixelBuffer + ", sz " + n8);
                bl2 = false;
            }
            if (bl2 && null != this.readTexture) {
                if (bl4) {
                    this.readTexture.updateImage(gL, this.readTextureData);
                } else {
                    this.readTexture.updateSubImage(gL, this.readTextureData, 0, 0, 0, 0, 0, n3, n4);
                }
                this.readPixelBuffer.rewind();
            }
            this.psm.restore(gL);
        }
        return bl2;
    }

    public void dispose(GL gL) {
        if (null != this.readTexture) {
            this.readTexture.destroy(gL);
            this.readTextureData = null;
        }
        if (null != this.readPixelBuffer) {
            this.readPixelBuffer.dispose();
            this.readPixelBuffer = null;
        }
    }
}

