/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.TreeBackedLighterAST;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.Trinity;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.StubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.BinaryFileStubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.stubs.BinaryFileStubBuilders;
import org.jetbrains.kotlin.com.intellij.psi.stubs.LightStubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.Stub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.indexing.FileContent;
import org.jetbrains.kotlin.com.intellij.util.indexing.FileContentImpl;
import org.jetbrains.kotlin.com.intellij.util.indexing.IndexingDataKeys;

public class StubTreeBuilder {
    private static final Key<Stub> stubElementKey = Key.create("stub.tree.for.file.content");

    private StubTreeBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Stub buildStubTree(FileContent inputData) {
        Stub data = inputData.getUserData(stubElementKey);
        if (data != null) {
            return data;
        }
        FileContent fileContent = inputData;
        synchronized (fileContent) {
            data = inputData.getUserData(stubElementKey);
            if (data != null) {
                return data;
            }
            FileType fileType = inputData.getFileType();
            BinaryFileStubBuilder builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType);
            if (builder != null) {
                data = builder.buildStubTree(inputData);
                if (data instanceof PsiFileStubImpl && !((PsiFileStubImpl)data).rootsAreSet()) {
                    ((PsiFileStubImpl)data).setStubRoots(new PsiFileStub[]{(PsiFileStubImpl)data});
                }
            } else {
                CharSequence contentAsText = inputData.getContentAsText();
                FileContentImpl fileContent2 = (FileContentImpl)inputData;
                PsiFile psi = fileContent2.getPsiFileForPsiDependentIndex();
                FileViewProvider viewProvider = psi.getViewProvider();
                psi = viewProvider.getStubBindingRoot();
                psi.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, contentAsText);
                psi.getManager().startBatchFilesProcessingMode();
                try {
                    IStubFileElementType stubFileElementType = ((PsiFileImpl)psi).getElementTypeForStubBuilder();
                    if (stubFileElementType != null) {
                        PsiFileStub[] stubsArray;
                        StubBuilder stubBuilder = stubFileElementType.getBuilder();
                        if (stubBuilder instanceof LightStubBuilder) {
                            LightStubBuilder.FORCED_AST.set(fileContent2.getLighterASTForPsiDependentIndex());
                        }
                        data = stubBuilder.buildStubTree(psi);
                        List<Pair<IStubFileElementType, PsiFile>> stubbedRoots = StubTreeBuilder.getStubbedRoots(viewProvider);
                        ArrayList<PsiFileStub> stubs = new ArrayList<PsiFileStub>(stubbedRoots.size());
                        stubs.add((PsiFileStub)data);
                        for (Pair<IStubFileElementType, PsiFile> stubbedRoot : stubbedRoots) {
                            StubElement element;
                            PsiFile secondaryPsi = (PsiFile)stubbedRoot.second;
                            if (psi == secondaryPsi) continue;
                            StubBuilder stubbedRootBuilder = ((IStubFileElementType)stubbedRoot.first).getBuilder();
                            if (stubbedRootBuilder instanceof LightStubBuilder) {
                                LightStubBuilder.FORCED_AST.set(new TreeBackedLighterAST(secondaryPsi.getNode()));
                            }
                            if (!((element = stubbedRootBuilder.buildStubTree(secondaryPsi)) instanceof PsiFileStub)) continue;
                            stubs.add((PsiFileStub)element);
                        }
                        for (PsiFileStub stub : stubsArray = stubs.toArray(new PsiFileStub[stubs.size()])) {
                            if (!(stub instanceof PsiFileStubImpl)) continue;
                            ((PsiFileStubImpl)stub).setStubRoots(stubsArray);
                        }
                    }
                }
                finally {
                    psi.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, null);
                    psi.getManager().finishBatchFilesProcessingMode();
                }
            }
            inputData.putUserData(stubElementKey, data);
            return data;
        }
    }

    @NotNull
    public static List<Pair<IStubFileElementType, PsiFile>> getStubbedRoots(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeBuilder", "getStubbedRoots"));
        }
        SmartList<Trinity<Language, IStubFileElementType, PsiFile>> roots2 = new SmartList<Trinity<Language, IStubFileElementType, PsiFile>>();
        final PsiFile stubBindingRoot = viewProvider.getStubBindingRoot();
        for (Language language : viewProvider.getLanguages()) {
            IStubFileElementType type2;
            PsiFile file2 = viewProvider.getPsi(language);
            if (!(file2 instanceof PsiFileImpl) || (type2 = ((PsiFileImpl)file2).getElementTypeForStubBuilder()) == null) continue;
            roots2.add(Trinity.create(language, type2, file2));
        }
        ContainerUtil.sort(roots2, new Comparator<Trinity<Language, IStubFileElementType, PsiFile>>(){

            @Override
            public int compare(Trinity<Language, IStubFileElementType, PsiFile> o1, Trinity<Language, IStubFileElementType, PsiFile> o2) {
                if (o1.third == stubBindingRoot) {
                    return o2.third == stubBindingRoot ? 0 : -1;
                }
                if (o2.third == stubBindingRoot) {
                    return 1;
                }
                return StringUtil.compare(((Language)o1.first).getID(), ((Language)o2.first).getID(), false);
            }
        });
        List<Pair<IStubFileElementType, PsiFile>> list2 = ContainerUtil.map(roots2, new Function<Trinity<Language, IStubFileElementType, PsiFile>, Pair<IStubFileElementType, PsiFile>>(){

            @Override
            public Pair<IStubFileElementType, PsiFile> fun(Trinity<Language, IStubFileElementType, PsiFile> trinity) {
                return Pair.create(trinity.second, trinity.third);
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeBuilder", "getStubbedRoots"));
        }
        return list2;
    }
}

