/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.CompositeDomainObjectSet;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.DefaultDependencySet;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.DefaultPublishArtifactSet;
import org.gradle.api.internal.artifacts.DefaultResolverResults;
import org.gradle.api.internal.artifacts.ExcludeRuleNotationConverter;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.component.ComponentIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.DetachedConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DirectBuildDependencies;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.configurations.TasksFromDependentProjects;
import org.gradle.api.internal.artifacts.configurations.TasksFromProjectDependencies;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ConfigurationComponentMetaDataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult.ResolvedProjectConfiguration;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.initialization.ProjectAccessListener;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.listener.ClosureBackedMethodInvocationDispatch;
import org.gradle.util.CollectionUtils;
import org.gradle.util.WrapUtil;

public class DefaultConfiguration
extends AbstractFileCollection
implements ConfigurationInternal,
MutationValidator {
    private final ConfigurationResolver resolver;
    private final ListenerManager listenerManager;
    private final DependencyMetaDataProvider metaDataProvider;
    private final DefaultDependencySet dependencies;
    private final CompositeDomainObjectSet<Dependency> inheritedDependencies;
    private final DefaultDependencySet allDependencies;
    private final List<Action<? super DependencySet>> defaultDependencyActions = new ArrayList<Action<? super DependencySet>>();
    private final DefaultPublishArtifactSet artifacts;
    private final CompositeDomainObjectSet<PublishArtifact> inheritedArtifacts;
    private final DefaultPublishArtifactSet allArtifacts;
    private final ConfigurationResolvableDependencies resolvableDependencies = new ConfigurationResolvableDependencies();
    private final ListenerBroadcast<DependencyResolutionListener> dependencyResolutionListeners;
    private final ProjectAccessListener projectAccessListener;
    private final ProjectFinder projectFinder;
    private final ResolutionStrategyInternal resolutionStrategy;
    private final ConfigurationComponentMetaDataBuilder configurationComponentMetaDataBuilder;
    private final FileCollectionFactory fileCollectionFactory;
    private final ComponentIdentifierFactory componentIdentifierFactory;
    private final Set<MutationValidator> childMutationValidators = Sets.newHashSet();
    private final MutationValidator parentMutationValidator = new MutationValidator(){

        @Override
        public void validateMutation(MutationValidator.MutationType type) {
            DefaultConfiguration.this.validateParentMutation(type);
        }
    };
    private final String path;
    private final String name;
    private boolean visible = true;
    private boolean transitive = true;
    private Set<Configuration> extendsFrom = new LinkedHashSet<Configuration>();
    private String description;
    private ConfigurationsProvider configurationsProvider;
    private Set<ExcludeRule> excludeRules = new LinkedHashSet<ExcludeRule>();
    private final Object observationLock = new Object();
    private ConfigurationInternal.InternalState observedState = ConfigurationInternal.InternalState.UNRESOLVED;
    private final Object resolutionLock = new Object();
    private ConfigurationInternal.InternalState resolvedState = ConfigurationInternal.InternalState.UNRESOLVED;
    private boolean insideBeforeResolve;
    private ResolverResults cachedResolverResults = new DefaultResolverResults();
    private boolean dependenciesModified;

    public DefaultConfiguration(String path, String name, ConfigurationsProvider configurationsProvider, ConfigurationResolver resolver, ListenerManager listenerManager, DependencyMetaDataProvider metaDataProvider, ResolutionStrategyInternal resolutionStrategy, ProjectAccessListener projectAccessListener, ProjectFinder projectFinder, ConfigurationComponentMetaDataBuilder configurationComponentMetaDataBuilder, FileCollectionFactory fileCollectionFactory, ComponentIdentifierFactory componentIdentifierFactory) {
        this.path = path;
        this.name = name;
        this.configurationsProvider = configurationsProvider;
        this.resolver = resolver;
        this.listenerManager = listenerManager;
        this.metaDataProvider = metaDataProvider;
        this.resolutionStrategy = resolutionStrategy;
        this.projectAccessListener = projectAccessListener;
        this.projectFinder = projectFinder;
        this.configurationComponentMetaDataBuilder = configurationComponentMetaDataBuilder;
        this.fileCollectionFactory = fileCollectionFactory;
        this.componentIdentifierFactory = componentIdentifierFactory;
        this.dependencyResolutionListeners = listenerManager.createAnonymousBroadcaster(DependencyResolutionListener.class);
        DefaultDomainObjectSet ownDependencies = new DefaultDomainObjectSet(Dependency.class);
        ownDependencies.beforeChange(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.DEPENDENCIES));
        String displayName = this.getDisplayName();
        this.dependencies = new DefaultDependencySet(displayName + " dependencies", (DomainObjectSet)ownDependencies);
        this.inheritedDependencies = CompositeDomainObjectSet.create(Dependency.class, (DomainObjectCollection[])new DomainObjectCollection[]{ownDependencies});
        this.allDependencies = new DefaultDependencySet(displayName + " all dependencies", this.inheritedDependencies);
        DefaultDomainObjectSet ownArtifacts = new DefaultDomainObjectSet(PublishArtifact.class);
        ownArtifacts.beforeChange(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.ARTIFACTS));
        this.artifacts = new DefaultPublishArtifactSet(displayName + " artifacts", (DomainObjectSet)ownArtifacts, fileCollectionFactory);
        this.inheritedArtifacts = CompositeDomainObjectSet.create(PublishArtifact.class, (DomainObjectCollection[])new DomainObjectCollection[]{ownArtifacts});
        this.allArtifacts = new DefaultPublishArtifactSet(displayName + " all artifacts", this.inheritedArtifacts, fileCollectionFactory);
        resolutionStrategy.setMutationValidator(this);
    }

    private static Runnable validateMutationType(final MutationValidator mutationValidator, final MutationValidator.MutationType type) {
        return new Runnable(){

            @Override
            public void run() {
                mutationValidator.validateMutation(type);
            }
        };
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration.State getState() {
        Object object = this.resolutionLock;
        synchronized (object) {
            if (this.resolvedState == ConfigurationInternal.InternalState.RESULTS_RESOLVED || this.resolvedState == ConfigurationInternal.InternalState.TASK_DEPENDENCIES_RESOLVED) {
                if (this.cachedResolverResults.hasError()) {
                    return Configuration.State.RESOLVED_WITH_FAILURES;
                }
                return Configuration.State.RESOLVED;
            }
            return Configuration.State.UNRESOLVED;
        }
    }

    @Override
    public ConfigurationInternal.InternalState getResolvedState() {
        return this.resolvedState;
    }

    public Module getModule() {
        return this.metaDataProvider.getModule();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Configuration setVisible(boolean visible) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.visible = visible;
        return this;
    }

    public Set<Configuration> getExtendsFrom() {
        return Collections.unmodifiableSet(this.extendsFrom);
    }

    public Configuration setExtendsFrom(Iterable<Configuration> extendsFrom) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        for (Configuration configuration : this.extendsFrom) {
            this.inheritedArtifacts.removeCollection((DomainObjectCollection)configuration.getAllArtifacts());
            this.inheritedDependencies.removeCollection((DomainObjectCollection)configuration.getAllDependencies());
            ((ConfigurationInternal)configuration).removeMutationValidator(this.parentMutationValidator);
        }
        this.extendsFrom = new HashSet<Configuration>();
        for (Configuration configuration : extendsFrom) {
            this.extendsFrom(configuration);
        }
        return this;
    }

    public Configuration extendsFrom(Configuration ... extendsFrom) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        for (Configuration configuration : extendsFrom) {
            if (configuration.getHierarchy().contains(this)) {
                throw new InvalidUserDataException(String.format("Cyclic extendsFrom from %s and %s is not allowed. See existing hierarchy: %s", this, configuration, configuration.getHierarchy()));
            }
            if (!this.extendsFrom.add(configuration)) continue;
            this.inheritedArtifacts.addCollection((DomainObjectCollection)configuration.getAllArtifacts());
            this.inheritedDependencies.addCollection((DomainObjectCollection)configuration.getAllDependencies());
            ((ConfigurationInternal)configuration).addMutationValidator(this.parentMutationValidator);
        }
        return this;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public Configuration setTransitive(boolean transitive) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.transitive = transitive;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Configuration setDescription(String description) {
        this.description = description;
        return this;
    }

    public Set<Configuration> getHierarchy() {
        Set result = WrapUtil.toLinkedSet((Object[])new Configuration[]{this});
        this.collectSuperConfigs(this, result);
        return result;
    }

    private void collectSuperConfigs(Configuration configuration, Set<Configuration> result) {
        for (Configuration superConfig : configuration.getExtendsFrom()) {
            if (result.contains(superConfig)) {
                result.remove(superConfig);
            }
            result.add(superConfig);
            this.collectSuperConfigs(superConfig, result);
        }
    }

    public Configuration defaultDependencies(Action<? super DependencySet> action) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.defaultDependencyActions.add(action);
        return this;
    }

    @Override
    public void triggerWhenEmptyActionsIfNecessary() {
        if (!this.defaultDependencyActions.isEmpty()) {
            for (Action<? super DependencySet> action : this.defaultDependencyActions) {
                if (!this.dependencies.isEmpty()) break;
                action.execute((Object)this.dependencies);
            }
        }
        for (Configuration superConfig : this.extendsFrom) {
            ((ConfigurationInternal)superConfig).triggerWhenEmptyActionsIfNecessary();
        }
    }

    public Set<Configuration> getAll() {
        return this.configurationsProvider.getAll();
    }

    public Set<File> resolve() {
        return this.getFiles();
    }

    public Set<File> getFiles() {
        return this.fileCollection((Spec<? super Dependency>)Specs.SATISFIES_ALL).getFiles();
    }

    public Set<File> files(Dependency ... dependencies) {
        return this.fileCollection(dependencies).getFiles();
    }

    public Set<File> files(Closure dependencySpecClosure) {
        return this.fileCollection(dependencySpecClosure).getFiles();
    }

    public Set<File> files(Spec<? super Dependency> dependencySpec) {
        return this.fileCollection(dependencySpec).getFiles();
    }

    public FileCollection fileCollection(Spec<? super Dependency> dependencySpec) {
        return new ConfigurationFileCollection(dependencySpec);
    }

    public FileCollection fileCollection(Closure dependencySpecClosure) {
        return new ConfigurationFileCollection(dependencySpecClosure);
    }

    public FileCollection fileCollection(Dependency ... dependencies) {
        return new ConfigurationFileCollection(WrapUtil.toLinkedSet((Object[])dependencies));
    }

    @Override
    public void markAsObserved(ConfigurationInternal.InternalState requestedState) {
        this.markThisObserved(requestedState);
        this.markParentsObserved(requestedState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markThisObserved(ConfigurationInternal.InternalState requestedState) {
        Object object = this.observationLock;
        synchronized (object) {
            if (this.observedState.compareTo(requestedState) < 0) {
                this.observedState = requestedState;
            }
        }
    }

    private void markParentsObserved(ConfigurationInternal.InternalState requestedState) {
        for (Configuration configuration : this.extendsFrom) {
            ((ConfigurationInternal)configuration).markAsObserved(requestedState);
        }
    }

    public ResolvedConfiguration getResolvedConfiguration() {
        this.resolveNow(ConfigurationInternal.InternalState.RESULTS_RESOLVED);
        return this.cachedResolverResults.getResolvedConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveNow(ConfigurationInternal.InternalState requestedState) {
        Object object = this.resolutionLock;
        synchronized (object) {
            if (requestedState == ConfigurationInternal.InternalState.TASK_DEPENDENCIES_RESOLVED || requestedState == ConfigurationInternal.InternalState.RESULTS_RESOLVED) {
                this.resolveGraphIfRequired(requestedState);
            }
            if (requestedState == ConfigurationInternal.InternalState.RESULTS_RESOLVED) {
                this.resolveArtifactsIfRequired();
            }
        }
    }

    private void resolveGraphIfRequired(ConfigurationInternal.InternalState requestedState) {
        if (this.resolvedState == ConfigurationInternal.InternalState.RESULTS_RESOLVED) {
            if (this.dependenciesModified) {
                throw new InvalidUserDataException(String.format("Attempted to resolve %s that has been resolved previously.", this.getDisplayName()));
            }
            return;
        }
        if (this.resolvedState == ConfigurationInternal.InternalState.TASK_DEPENDENCIES_RESOLVED) {
            if (!this.dependenciesModified) {
                return;
            }
            throw new InvalidUserDataException(String.format("Resolved %s again after modification", this.getDisplayName()));
        }
        ResolvableDependencies incoming = this.getIncoming();
        this.performPreResolveActions(incoming);
        this.resolver.resolve(this, this.cachedResolverResults);
        this.dependenciesModified = false;
        if (this.resolvedState != ConfigurationInternal.InternalState.RESULTS_RESOLVED) {
            this.resolvedState = ConfigurationInternal.InternalState.TASK_DEPENDENCIES_RESOLVED;
        }
        this.markParentsObserved(requestedState);
        this.markReferencedProjectConfigurationsObserved(requestedState);
        ((DependencyResolutionListener)this.dependencyResolutionListeners.getSource()).afterResolve(incoming);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performPreResolveActions(ResolvableDependencies incoming) {
        DependencyResolutionListener dependencyResolutionListener = (DependencyResolutionListener)this.dependencyResolutionListeners.getSource();
        this.insideBeforeResolve = true;
        try {
            dependencyResolutionListener.beforeResolve(incoming);
        }
        finally {
            this.insideBeforeResolve = false;
        }
        this.triggerWhenEmptyActionsIfNecessary();
    }

    private void markReferencedProjectConfigurationsObserved(ConfigurationInternal.InternalState requestedState) {
        for (ResolvedProjectConfiguration projectResult : this.cachedResolverResults.getResolvedLocalComponents().getResolvedProjectConfigurations()) {
            if (!projectResult.getId().getBuild().isCurrentBuild()) continue;
            ProjectInternal project = this.projectFinder.getProject(projectResult.getId().getProjectPath());
            ConfigurationInternal targetConfig = (ConfigurationInternal)project.getConfigurations().getByName(projectResult.getTargetConfiguration());
            targetConfig.markAsObserved(requestedState);
        }
    }

    private void resolveArtifactsIfRequired() {
        if (this.resolvedState == ConfigurationInternal.InternalState.RESULTS_RESOLVED) {
            return;
        }
        this.resolver.resolveArtifacts(this, this.cachedResolverResults);
        this.resolvedState = ConfigurationInternal.InternalState.RESULTS_RESOLVED;
    }

    public TaskDependency getBuildDependencies() {
        if (this.resolutionStrategy.resolveGraphToDetermineTaskDependencies()) {
            DefaultTaskDependency taskDependency = new DefaultTaskDependency();
            this.resolveNow(ConfigurationInternal.InternalState.TASK_DEPENDENCIES_RESOLVED);
            taskDependency.add(new Object[]{this.cachedResolverResults.getResolvedLocalComponents().getComponentBuildDependencies()});
            taskDependency.add(new Object[]{DirectBuildDependencies.forDependenciesOnly(this)});
            return taskDependency;
        }
        return this.allDependencies.getBuildDependencies();
    }

    public TaskDependency getTaskDependencyFromProjectDependency(boolean useDependedOn, String taskName) {
        if (useDependedOn) {
            return new TasksFromProjectDependencies(taskName, this.getAllDependencies(), this.projectAccessListener);
        }
        return new TasksFromDependentProjects(taskName, this.getName());
    }

    public DependencySet getDependencies() {
        return this.dependencies;
    }

    public DependencySet getAllDependencies() {
        return this.allDependencies;
    }

    public PublishArtifactSet getArtifacts() {
        return this.artifacts;
    }

    public PublishArtifactSet getAllArtifacts() {
        return this.allArtifacts;
    }

    public Set<ExcludeRule> getExcludeRules() {
        return Collections.unmodifiableSet(this.excludeRules);
    }

    public void setExcludeRules(Set<ExcludeRule> excludeRules) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.excludeRules = excludeRules;
    }

    public DefaultConfiguration exclude(Map<String, String> excludeRuleArgs) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.excludeRules.add((ExcludeRule)ExcludeRuleNotationConverter.parser().parseNotation(excludeRuleArgs));
        return this;
    }

    public String getUploadTaskName() {
        return Configurations.uploadTaskName(this.getName());
    }

    @Override
    public String getDisplayName() {
        StringBuilder builder = new StringBuilder();
        builder.append("configuration '");
        builder.append(this.path);
        builder.append("'");
        return builder.toString();
    }

    public ResolvableDependencies getIncoming() {
        return this.resolvableDependencies;
    }

    public ConfigurationInternal copy() {
        return this.createCopy((Set<Dependency>)this.getDependencies(), false);
    }

    public Configuration copyRecursive() {
        return this.createCopy((Set<Dependency>)this.getAllDependencies(), true);
    }

    public Configuration copy(Spec<? super Dependency> dependencySpec) {
        return this.createCopy(CollectionUtils.filter((Set)this.getDependencies(), dependencySpec), false);
    }

    public Configuration copyRecursive(Spec<? super Dependency> dependencySpec) {
        return this.createCopy(CollectionUtils.filter((Set)this.getAllDependencies(), dependencySpec), true);
    }

    private DefaultConfiguration createCopy(Set<Dependency> dependencies, boolean recursive) {
        DetachedConfigurationsProvider configurationsProvider = new DetachedConfigurationsProvider();
        DefaultConfiguration copiedConfiguration = new DefaultConfiguration(this.path + "Copy", this.name + "Copy", configurationsProvider, this.resolver, this.listenerManager, this.metaDataProvider, this.resolutionStrategy.copy(), this.projectAccessListener, this.projectFinder, this.configurationComponentMetaDataBuilder, this.fileCollectionFactory, this.componentIdentifierFactory);
        configurationsProvider.setTheOnlyConfiguration(copiedConfiguration);
        copiedConfiguration.visible = this.visible;
        copiedConfiguration.transitive = this.transitive;
        copiedConfiguration.description = this.description;
        copiedConfiguration.defaultDependencyActions.addAll(this.defaultDependencyActions);
        copiedConfiguration.getArtifacts().addAll((Collection)this.getAllArtifacts());
        LinkedHashSet<Configuration> excludeRuleSources = new LinkedHashSet<Configuration>();
        excludeRuleSources.add(this);
        if (recursive) {
            excludeRuleSources.addAll(this.getHierarchy());
        }
        for (Configuration excludeRuleSource : excludeRuleSources) {
            for (ExcludeRule excludeRule : excludeRuleSource.getExcludeRules()) {
                copiedConfiguration.excludeRules.add((ExcludeRule)new DefaultExcludeRule(excludeRule.getGroup(), excludeRule.getModule()));
            }
        }
        DependencySet copiedDependencies = copiedConfiguration.getDependencies();
        for (Dependency dependency : dependencies) {
            copiedDependencies.add((Object)dependency.copy());
        }
        return copiedConfiguration;
    }

    public Configuration copy(Closure dependencySpec) {
        return this.copy((Spec<? super Dependency>)Specs.convertClosureToSpec((Closure)dependencySpec));
    }

    public Configuration copyRecursive(Closure dependencySpec) {
        return this.copyRecursive((Spec<? super Dependency>)Specs.convertClosureToSpec((Closure)dependencySpec));
    }

    @Override
    public ResolutionStrategyInternal getResolutionStrategy() {
        return this.resolutionStrategy;
    }

    @Override
    public ComponentResolveMetadata toRootComponentMetaData() {
        Module module = this.getModule();
        Set<Configuration> configurations = this.getAll();
        ComponentIdentifier componentIdentifier = this.componentIdentifierFactory.createComponentIdentifier(module);
        ModuleVersionIdentifier moduleVersionIdentifier = DefaultModuleVersionIdentifier.newId(module);
        DefaultLocalComponentMetadata metaData = new DefaultLocalComponentMetadata(moduleVersionIdentifier, componentIdentifier, module.getStatus());
        this.configurationComponentMetaDataBuilder.addConfigurations(metaData, configurations);
        return metaData;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public Configuration resolutionStrategy(Closure closure) {
        return this.resolutionStrategy((Action<? super ResolutionStrategy>)ClosureBackedAction.of((Closure)closure));
    }

    public Configuration resolutionStrategy(Action<? super ResolutionStrategy> action) {
        action.execute((Object)this.resolutionStrategy);
        return this;
    }

    @Override
    public void addMutationValidator(MutationValidator validator) {
        this.childMutationValidators.add(validator);
    }

    @Override
    public void removeMutationValidator(MutationValidator validator) {
        this.childMutationValidators.remove(validator);
    }

    private void validateParentMutation(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.STRATEGY) {
            return;
        }
        if (this.resolvedState == ConfigurationInternal.InternalState.RESULTS_RESOLVED) {
            throw new InvalidUserDataException(String.format("Cannot change %s of parent of %s after it has been resolved", new Object[]{type, this.getDisplayName()}));
        }
        if (this.resolvedState == ConfigurationInternal.InternalState.TASK_DEPENDENCIES_RESOLVED && type == MutationValidator.MutationType.DEPENDENCIES) {
            throw new InvalidUserDataException(String.format("Cannot change %s of parent of %s after task dependencies have been resolved", new Object[]{type, this.getDisplayName()}));
        }
        this.markAsModifiedAndNotifyChildren(type);
    }

    @Override
    public void validateMutation(MutationValidator.MutationType type) {
        if (this.resolvedState == ConfigurationInternal.InternalState.RESULTS_RESOLVED) {
            throw new InvalidUserDataException(String.format("Cannot change %s of %s after it has been resolved.", new Object[]{type, this.getDisplayName()}));
        }
        if (this.resolvedState == ConfigurationInternal.InternalState.TASK_DEPENDENCIES_RESOLVED) {
            throw new InvalidUserDataException(String.format("Cannot change %s of %s after task dependencies have been resolved", new Object[]{type, this.getDisplayName()}));
        }
        if ((this.observedState == ConfigurationInternal.InternalState.TASK_DEPENDENCIES_RESOLVED || this.observedState == ConfigurationInternal.InternalState.RESULTS_RESOLVED) && type != MutationValidator.MutationType.STRATEGY) {
            String extraMessage = this.insideBeforeResolve ? " Use 'defaultDependencies' instead of 'beforeResolve' to specify default dependencies for a configuration." : "";
            throw new InvalidUserDataException(String.format("Cannot change %s of %s after it has been included in dependency resolution.%s", new Object[]{type, this.getDisplayName(), extraMessage}));
        }
        this.markAsModifiedAndNotifyChildren(type);
    }

    private void markAsModifiedAndNotifyChildren(MutationValidator.MutationType type) {
        for (MutationValidator validator : this.childMutationValidators) {
            validator.validateMutation(type);
        }
        if (type != MutationValidator.MutationType.STRATEGY) {
            this.dependenciesModified = true;
        }
    }

    public void registerWatchPoints(FileSystemSubset.Builder builder) {
        for (Dependency dependency : this.allDependencies) {
            if (!(dependency instanceof FileCollectionDependency)) continue;
            ((FileCollectionDependency)dependency).registerWatchPoints(builder);
        }
        super.registerWatchPoints(builder);
    }

    public String dump() {
        StringBuilder reply = new StringBuilder();
        reply.append("\nConfiguration:");
        reply.append("  class='" + this.getClass() + "'");
        reply.append("  name='" + this.getName() + "'");
        reply.append("  hashcode='" + this.hashCode() + "'");
        reply.append("\nLocal Dependencies:");
        if (this.getDependencies().size() > 0) {
            for (Dependency d : this.getDependencies()) {
                reply.append("\n   " + d);
            }
        } else {
            reply.append("\n   none");
        }
        reply.append("\nLocal Artifacts:");
        if (this.getArtifacts().size() > 0) {
            for (PublishArtifact a : this.getArtifacts()) {
                reply.append("\n   " + a);
            }
        } else {
            reply.append("\n   none");
        }
        reply.append("\nAll Dependencies:");
        if (this.getAllDependencies().size() > 0) {
            for (Dependency d : this.getAllDependencies()) {
                reply.append("\n   " + d);
            }
        } else {
            reply.append("\n   none");
        }
        reply.append("\nAll Artifacts:");
        if (this.getAllArtifacts().size() > 0) {
            for (PublishArtifact a : this.getAllArtifacts()) {
                reply.append("\n   " + a);
            }
        } else {
            reply.append("\n   none");
        }
        return reply.toString();
    }

    private class ConfigurationResolvableDependencies
    implements ResolvableDependencies {
        private ConfigurationResolvableDependencies() {
        }

        public String getName() {
            return DefaultConfiguration.this.name;
        }

        public String getPath() {
            return DefaultConfiguration.this.path;
        }

        public String toString() {
            return "dependencies '" + DefaultConfiguration.this.path + "'";
        }

        public FileCollection getFiles() {
            return DefaultConfiguration.this.fileCollection((Spec<? super Dependency>)Specs.satisfyAll());
        }

        public DependencySet getDependencies() {
            return DefaultConfiguration.this.getAllDependencies();
        }

        public void beforeResolve(Action<? super ResolvableDependencies> action) {
            DefaultConfiguration.this.dependencyResolutionListeners.add("beforeResolve", action);
        }

        public void beforeResolve(Closure action) {
            DefaultConfiguration.this.dependencyResolutionListeners.add((Dispatch)new ClosureBackedMethodInvocationDispatch("beforeResolve", action));
        }

        public void afterResolve(Action<? super ResolvableDependencies> action) {
            DefaultConfiguration.this.dependencyResolutionListeners.add("afterResolve", action);
        }

        public void afterResolve(Closure action) {
            DefaultConfiguration.this.dependencyResolutionListeners.add((Dispatch)new ClosureBackedMethodInvocationDispatch("afterResolve", action));
        }

        public ResolutionResult getResolutionResult() {
            DefaultConfiguration.this.resolveNow(ConfigurationInternal.InternalState.RESULTS_RESOLVED);
            return DefaultConfiguration.this.cachedResolverResults.getResolutionResult();
        }
    }

    class ConfigurationFileCollection
    extends AbstractFileCollection {
        private Spec<? super Dependency> dependencySpec;

        private ConfigurationFileCollection(Spec<? super Dependency> dependencySpec) {
            this.dependencySpec = dependencySpec;
        }

        public ConfigurationFileCollection(Closure dependencySpecClosure) {
            this.dependencySpec = Specs.convertClosureToSpec((Closure)dependencySpecClosure);
        }

        public ConfigurationFileCollection(final Set<Dependency> dependencies) {
            this.dependencySpec = new Spec<Dependency>(){

                public boolean isSatisfiedBy(Dependency element) {
                    return dependencies.contains(element);
                }
            };
        }

        public TaskDependency getBuildDependencies() {
            return DefaultConfiguration.this.getBuildDependencies();
        }

        public Spec<? super Dependency> getDependencySpec() {
            return this.dependencySpec;
        }

        public String getDisplayName() {
            return DefaultConfiguration.this + " dependencies";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<File> getFiles() {
            Object object = DefaultConfiguration.this.resolutionLock;
            synchronized (object) {
                ResolvedConfiguration resolvedConfiguration = DefaultConfiguration.this.getResolvedConfiguration();
                if (DefaultConfiguration.this.getState() == Configuration.State.RESOLVED_WITH_FAILURES) {
                    resolvedConfiguration.rethrowFailure();
                }
                return resolvedConfiguration.getFiles(this.dependencySpec);
            }
        }
    }
}

